/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.views;

import com.codename1.charts.compat.Canvas;
import com.codename1.charts.compat.Paint;
import com.codename1.charts.models.XYMultipleSeriesDataset;
import com.codename1.charts.renderers.SimpleSeriesRenderer;
import com.codename1.charts.renderers.XYMultipleSeriesRenderer;
import com.codename1.charts.renderers.XYSeriesRenderer;
import com.codename1.charts.views.ClickableArea;
import com.codename1.charts.views.PkgUtils;
import com.codename1.charts.views.PointStyle;
import com.codename1.charts.views.XYChart;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScatterChart
extends XYChart {
    public static final String TYPE = "Scatter";
    private static final float SIZE = 3.0f;
    private static final int SHAPE_WIDTH = 10;
    private float size = 3.0f;

    ScatterChart() {
    }

    public ScatterChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
        this.size = renderer.getPointSize();
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super.setDatasetRenderer(dataset, renderer);
        this.size = renderer.getPointSize();
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, List<Float> points, XYSeriesRenderer renderer, float yAxisValue, int seriesIndex, int startIndex) {
        paint.setColor(renderer.getColor());
        float stroke = paint.getStrokeWidth();
        if (renderer.isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStrokeWidth(renderer.getPointStrokeWidth());
            paint.setStyle(Paint.Style.STROKE);
        }
        int length = points.size();
        PointStyle ps = renderer.getPointStyle();
        if (ps == PointStyle.X) {
            paint.setStrokeWidth(renderer.getPointStrokeWidth());
            for (int i = 0; i < length; i += 2) {
                this.drawX(canvas, paint, points.get(i).floatValue(), points.get(i + 1).floatValue());
            }
        } else if (ps == PointStyle.CIRCLE) {
            for (int i = 0; i < length; i += 2) {
                this.drawCircle(canvas, paint, points.get(i).floatValue(), points.get(i + 1).floatValue());
            }
        } else if (ps == PointStyle.TRIANGLE) {
            float[] path = new float[6];
            for (int i = 0; i < length; i += 2) {
                this.drawTriangle(canvas, paint, path, points.get(i).floatValue(), points.get(i + 1).floatValue());
            }
        } else if (ps == PointStyle.SQUARE) {
            for (int i = 0; i < length; i += 2) {
                this.drawSquare(canvas, paint, points.get(i).floatValue(), points.get(i + 1).floatValue());
            }
        } else if (ps == PointStyle.DIAMOND) {
            float[] path = new float[8];
            for (int i = 0; i < length; i += 2) {
                this.drawDiamond(canvas, paint, path, points.get(i).floatValue(), points.get(i + 1).floatValue());
            }
        } else if (ps == PointStyle.POINT) {
            for (int i = 0; i < length; i += 2) {
                canvas.drawPoint(points.get(i), points.get(i + 1), paint);
            }
        }
        paint.setStrokeWidth(stroke);
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(List<Float> points, List<Double> values, float yAxisValue, int seriesIndex, int startIndex) {
        int length = points.size();
        ClickableArea[] ret = new ClickableArea[length / 2];
        for (int i = 0; i < length; i += 2) {
            int selectableBuffer = this.mRenderer.getSelectableBuffer();
            ret[i / 2] = new ClickableArea(PkgUtils.makeRect(points.get(i).floatValue() - (float)selectableBuffer, points.get(i + 1).floatValue() - (float)selectableBuffer, points.get(i).floatValue() + (float)selectableBuffer, points.get(i + 1).floatValue() + (float)selectableBuffer), values.get(i), values.get(i + 1));
        }
        return ret;
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        if (((XYSeriesRenderer)renderer).isFillPoints()) {
            paint.setStyle(Paint.Style.FILL);
        } else {
            paint.setStyle(Paint.Style.STROKE);
        }
        PointStyle ps = ((XYSeriesRenderer)renderer).getPointStyle();
        if (ps == PointStyle.X) {
            this.drawX(canvas, paint, x + 10.0f, y);
        } else if (ps == PointStyle.CIRCLE) {
            this.drawCircle(canvas, paint, x + 10.0f, y);
        } else if (ps == PointStyle.TRIANGLE) {
            this.drawTriangle(canvas, paint, new float[6], x + 10.0f, y);
        } else if (ps == PointStyle.SQUARE) {
            this.drawSquare(canvas, paint, x + 10.0f, y);
        } else if (ps == PointStyle.DIAMOND) {
            this.drawDiamond(canvas, paint, new float[8], x + 10.0f, y);
        } else if (ps == PointStyle.POINT) {
            this.drawDiamond(canvas, paint, new float[8], x + 10.0f, y);
        }
    }

    private void drawX(Canvas canvas, Paint paint, float x, float y) {
        canvas.drawLine(x - this.size, y - this.size, x + this.size, y + this.size, paint);
        canvas.drawLine(x + this.size, y - this.size, x - this.size, y + this.size, paint);
    }

    private void drawCircle(Canvas canvas, Paint paint, float x, float y) {
        canvas.drawCircle(x, y, this.size, paint);
    }

    private void drawTriangle(Canvas canvas, Paint paint, float[] path, float x, float y) {
        path[0] = x;
        path[1] = y - this.size - this.size / 2.0f;
        path[2] = x - this.size;
        path[3] = y + this.size;
        path[4] = x + this.size;
        path[5] = path[3];
        this.drawPath(canvas, path, paint, true);
    }

    private void drawSquare(Canvas canvas, Paint paint, float x, float y) {
        canvas.drawRect(x - this.size, y - this.size, x + this.size, y + this.size, paint);
    }

    private void drawDiamond(Canvas canvas, Paint paint, float[] path, float x, float y) {
        path[0] = x;
        path[1] = y - this.size;
        path[2] = x - this.size;
        path[3] = y;
        path[4] = x;
        path[5] = y + this.size;
        path[6] = x + this.size;
        path[7] = y;
        this.drawPath(canvas, path, paint, true);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

