/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Button;
import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Label;
import com.codename1.ui.Painter;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.FlowLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.plaf.Border;
import com.codename1.ui.plaf.RoundRectBorder;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.EventDispatcher;

public class Sheet
extends Container {
    private final Sheet parentSheet;
    private EventDispatcher closeListeners = new EventDispatcher();
    private EventDispatcher backListeners = new EventDispatcher();
    private Button backButton = new Button('\ue5cd');
    private final Label title = new Label();
    private Container commandsContainer = new Container(BoxLayout.x());
    private boolean allowClose = true;
    private Container titleBar = BorderLayout.center(LayeredLayout.encloseIn(BorderLayout.center(FlowLayout.encloseCenterMiddle(this.title)), BorderLayout.centerEastWest(null, this.commandsContainer, this.backButton)));
    private Container contentPane = new Container(BoxLayout.y());
    private static int DEFAULT_TRANSITION_DURATION = 300;
    private String position;
    private String tabletPosition = this.position = "South";
    private ActionListener formPointerListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            Form f = Sheet.this.getComponentForm();
            if (f == null) {
                return;
            }
            if (Display.impl.isScrollWheeling()) {
                return;
            }
            Component cmp = f.getComponentAt(evt.getX(), evt.getY());
            if (cmp == null) {
                return;
            }
            if (!Sheet.this.contains(cmp) && Sheet.this != cmp && !cmp.isOwnedBy(Sheet.this)) {
                evt.consume();
                Sheet.this.hide(DEFAULT_TRANSITION_DURATION);
            }
        }
    };
    private static final int N = 0;
    private static final int S = 1;
    private static final int E = 2;
    private static final int W = 3;
    private static final int C = 4;
    private Form form;

    public Sheet(Sheet parent, String title) {
        this(parent, title, "Sheet");
    }

    public Sheet(Sheet parent, String title, String uiid) {
        if (parent != null) {
            this.allowClose = parent.allowClose;
            this.position = parent.position;
            this.tabletPosition = parent.tabletPosition;
        }
        if (uiid == null) {
            uiid = "Sheet";
        }
        ComponentSelector.$(this).addTags("Sheet");
        this.setGrabsPointerEvents(true);
        this.setUIID(uiid);
        this.title.setUIID(uiid + "Title");
        this.titleBar.setUIID(uiid + "TitleBar");
        this.backButton.setUIID(uiid + "BackButton");
        this.parentSheet = parent;
        this.title.setText(title);
        this.initUI();
        this.updateBorderForPosition();
    }

    public void setAllowClose(boolean allowClose) {
        if (allowClose != this.allowClose) {
            this.allowClose = allowClose;
            if (!allowClose && this.isInitialized()) {
                this.form.removePointerPressedListener(this.formPointerListener);
            } else if (allowClose && this.isInitialized()) {
                this.form.addPointerPressedListener(this.formPointerListener);
            }
            if (this.parentSheet == null) {
                this.backButton.setVisible(allowClose);
                this.backButton.setEnabled(allowClose);
            }
        }
    }

    public boolean isAllowClose() {
        return this.allowClose;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    public void hideBackButton() {
        this.backButton.setVisible(false);
    }

    public void showBackButton() {
        this.backButton.setVisible(true);
    }

    public Container getCommandsContainer() {
        return this.commandsContainer;
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.contentPane.setSafeArea(true);
        this.titleBar.setSafeArea(true);
        this.add((Object)"North", this.titleBar);
        if (this.parentSheet != null) {
            FontImage.setMaterialIcon(this.backButton, '\ue5c4');
        }
        this.add((Object)"Center", this.contentPane);
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sheet.this.back(DEFAULT_TRANSITION_DURATION);
            }
        });
    }

    public void show() {
        this.show(DEFAULT_TRANSITION_DURATION);
    }

    public static Sheet getCurrentSheet() {
        if (CN.getCurrentForm() == null) {
            return null;
        }
        Container cnt = CN.getCurrentForm().getFormLayeredPaneIfExists();
        if (cnt == null) {
            return null;
        }
        for (Component cmp : ComponentSelector.$(".Sheet", cnt)) {
            if (!(cmp instanceof Sheet)) continue;
            return (Sheet)cmp;
        }
        return null;
    }

    public void show(final int duration) {
        Container cnt;
        int titleMargin = Math.max(this.commandsContainer.getPreferredW() + this.commandsContainer.getStyle().getHorizontalMargins(), this.backButton.getPreferredW() + this.backButton.getStyle().getHorizontalMargins());
        Style s = this.getStyle();
        Style titleParentStyle = this.title.getParent().getStyle();
        titleParentStyle.setMarginLeft(titleMargin);
        titleParentStyle.setMarginRight(titleMargin);
        Border border = s.getBorder();
        if (border instanceof RoundRectBorder) {
            RoundRectBorder b = (RoundRectBorder)border;
            ComponentSelector.$(this.contentPane).setPaddingMillimeters(b.getCornerRadius());
        }
        UIManager uim = UIManager.getInstance();
        Style statusBarStyle = uim.getComponentStyle("StatusBar");
        Style titleAreaStyle = uim.getComponentStyle("TitleArea");
        int topPadding = statusBarStyle.getPaddingTop() + statusBarStyle.getPaddingBottom() + titleAreaStyle.getPaddingTop();
        int positionInt = this.getPositionInt();
        Rectangle displaySafeArea = new Rectangle();
        Display.getInstance().getDisplaySafeArea(displaySafeArea);
        int bottomPadding = s.getPaddingBottom();
        int safeAreaBottomPadding = CN.getDisplayHeight() - (displaySafeArea.getY() + displaySafeArea.getHeight());
        bottomPadding += safeAreaBottomPadding;
        if (positionInt == 1 || positionInt == 4) {
            ComponentSelector.$(this).setMargin(topPadding, 0, 0, 0);
            ComponentSelector.$(this).setPadding(s.getPaddingTop(), s.getPaddingRightNoRTL(), bottomPadding, s.getPaddingLeftNoRTL());
        } else {
            ComponentSelector.$(this).setPadding(topPadding, s.getPaddingRightNoRTL(), bottomPadding, s.getPaddingLeftNoRTL());
        }
        Form f = CN.getCurrentForm();
        if (f.getAnimationManager().isAnimating()) {
            f.getAnimationManager().flushAnimation(new Runnable(){

                public void run() {
                    Sheet.this.show(duration);
                }
            });
            return;
        }
        if (this.getParent() != null) {
            this.remove();
        }
        if (!((cnt = CN.getCurrentForm().getFormLayeredPane(Sheet.class, true)).getLayout() instanceof BorderLayout)) {
            cnt.setLayout(new BorderLayout(2));
            cnt.getStyle().setBgPainter(new Painter(){

                public void paint(Graphics g, Rectangle rect) {
                    int alph = g.getAlpha();
                    g.setAlpha((int)((double)(alph * 30) / 100.0));
                    g.setColor(0);
                    g.fillRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
                    g.setAlpha(alph);
                }
            });
            cnt.revalidate();
        }
        if (cnt.getComponentCount() > 0) {
            ComponentSelector.$(".Sheet", cnt).each(new ComponentSelector.ComponentClosure(){

                public void call(Component c) {
                    if (c instanceof Sheet) {
                        Sheet s = (Sheet)c;
                        if (s.isAncestorSheetOf(Sheet.this) || s == Sheet.this) {
                            return;
                        }
                        s.fireCloseEvent(false);
                        for (Sheet sp = s.getParentSheet(); sp != null && sp != Sheet.this; sp = sp.getParentSheet()) {
                            if (sp.isAncestorSheetOf(Sheet.this)) continue;
                            sp.fireCloseEvent(false);
                        }
                    }
                }
            });
            Component existing = cnt.getComponentAt(0);
            cnt.replace(existing, (Component)this, null);
            cnt.animateLayout(duration);
        } else {
            cnt.add((Object)this.getPosition(), this);
            this.setWidth(this.getPreferredW(cnt));
            this.setHeight(this.getPreferredH(cnt));
            this.setX(this.getHiddenX(cnt));
            this.setY(this.getHiddenY(cnt));
            cnt.animateLayout(duration);
        }
    }

    public String getPosition() {
        if (CN.isTablet()) {
            return this.tabletPosition;
        }
        return this.position;
    }

    public void setPosition(String position) {
        if (CN.isTablet()) {
            if (!position.equals(this.tabletPosition)) {
                this.tabletPosition = position;
                this.updateBorderForPosition();
            }
        } else if (!position.equals(this.position)) {
            this.position = position;
            this.updateBorderForPosition();
        }
    }

    private void updateBorderForPosition() {
        Border border = this.getStyle().getBorder();
        if (border instanceof RoundRectBorder) {
            RoundRectBorder b = (RoundRectBorder)border;
            RoundRectBorder nb = RoundRectBorder.create();
            nb.bezierCorners(b.isBezierCorners());
            nb.bottomLeftMode(b.isBottomLeft());
            nb.bottomRightMode(b.isBottomRight());
            nb.topRightMode(b.isTopRight());
            nb.topLeftMode(b.isTopLeft());
            nb.cornerRadius(b.getCornerRadius());
            nb.shadowBlur(b.getShadowBlur());
            nb.shadowColor(b.getShadowColor());
            nb.shadowOpacity(b.getShadowOpacity());
            nb.shadowSpread(b.getShadowSpread());
            nb.shadowX(b.getShadowX());
            nb.shadowY(b.getShadowY());
            nb.strokeColor(b.getStrokeColor());
            nb.strokeOpacity(b.getStrokeOpacity());
            nb.stroke(b.getStrokeThickness(), b.isStrokeMM());
            b = nb;
            switch (this.getPositionInt()) {
                case 4: {
                    b.bottomRightMode(true);
                    b.bottomLeftMode(true);
                    b.topLeftMode(true);
                    b.topRightMode(true);
                    break;
                }
                case 2: {
                    b.bottomLeftMode(true);
                    b.topLeftMode(true);
                    b.topRightMode(false);
                    b.bottomRightMode(false);
                    break;
                }
                case 3: {
                    b.bottomLeftMode(false);
                    b.bottomRightMode(true);
                    b.topLeftMode(false);
                    b.topRightMode(true);
                    break;
                }
                case 1: {
                    b.topLeftMode(true);
                    b.topRightMode(true);
                    b.bottomLeftMode(false);
                    b.bottomRightMode(false);
                    break;
                }
                case 0: {
                    b.topLeftMode(false);
                    b.topRightMode(false);
                    b.bottomLeftMode(true);
                    b.bottomRightMode(true);
                }
            }
            this.getStyle().setBorder(b);
        }
    }

    public void setPosition(String phonePosition, String tabletPosition) {
        boolean changed = false;
        if (CN.isTablet() && !tabletPosition.equals(this.tabletPosition)) {
            changed = true;
        } else if (!CN.isTablet() && !phonePosition.equals(this.position)) {
            changed = true;
        }
        this.position = phonePosition;
        this.tabletPosition = tabletPosition;
        if (changed) {
            this.updateBorderForPosition();
        }
    }

    private int getHiddenX(Container cnt) {
        switch (this.getPositionInt()) {
            case 0: 
            case 1: {
                return 0;
            }
            case 4: {
                return (cnt.getWidth() - this.getPreferredW(cnt)) / 2;
            }
            case 2: {
                return cnt.getWidth();
            }
            case 3: {
                return -this.getPreferredW(cnt);
            }
        }
        return 0;
    }

    private int getHiddenY(Container cnt) {
        switch (this.getPositionInt()) {
            case 1: 
            case 4: {
                return cnt.getHeight();
            }
            case 2: 
            case 3: {
                return 0;
            }
            case 0: {
                return -this.getPreferredH(cnt);
            }
        }
        return 0;
    }

    private int getPreferredW(Container cnt) {
        switch (this.getPositionInt()) {
            case 0: 
            case 1: {
                return cnt.getWidth();
            }
            case 2: 
            case 3: 
            case 4: {
                return Math.min(this.getPreferredW() + (this.backButton.getPreferredW() + this.backButton.getStyle().getHorizontalMargins()) * 2, cnt.getWidth());
            }
        }
        return this.getPreferredW();
    }

    private int getPositionInt() {
        String pos = this.getPosition();
        if ("North".equals(pos)) {
            return 0;
        }
        if ("South".equals(pos)) {
            return 1;
        }
        if ("East".equals(pos)) {
            return 2;
        }
        if ("West".equals(pos)) {
            return 3;
        }
        if ("Center".equals(pos)) {
            return 4;
        }
        return 1;
    }

    private int getPreferredH(Container cnt) {
        switch (this.getPositionInt()) {
            case 2: 
            case 3: {
                return cnt.getHeight();
            }
        }
        return Math.min(this.getPreferredH(), cnt.getHeight());
    }

    public void back() {
        this.back(DEFAULT_TRANSITION_DURATION);
    }

    public void back(int duration) {
        if (this.parentSheet != null) {
            this.fireBackEvent();
            this.parentSheet.show(duration);
        } else {
            this.hide(duration);
        }
    }

    private void hide(int duration) {
        final Container cnt = CN.getCurrentForm().getFormLayeredPane(Sheet.class, true);
        this.setX(this.getHiddenX(cnt));
        this.setY(this.getHiddenY(cnt));
        cnt.animateUnlayout(duration, 255, new Runnable(){

            public void run() {
                Container parent = cnt.getParent();
                if (parent != null && parent.getComponentForm() != null) {
                    cnt.remove();
                    parent.getComponentForm().revalidateLater();
                    Sheet.this.fireCloseEvent(true);
                }
            }
        });
    }

    public Sheet getParentSheet() {
        return this.parentSheet;
    }

    protected void initComponent() {
        super.initComponent();
        this.form = this.getComponentForm();
        if (this.form != null && this.allowClose) {
            this.form.addPointerPressedListener(this.formPointerListener);
        }
    }

    protected void deinitialize() {
        if (this.form != null) {
            this.form.removePointerPressedListener(this.formPointerListener);
            this.form = null;
        }
        super.deinitialize();
    }

    public static Sheet findContainingSheet(Component cmp) {
        for (Container parent = cmp.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Sheet)) continue;
            return (Sheet)parent;
        }
        return null;
    }

    public boolean isAncestorSheetOf(Sheet sheet) {
        if ((sheet = sheet.getParentSheet()) == this) {
            return true;
        }
        if (sheet == null) {
            return false;
        }
        return this.isAncestorSheetOf(sheet);
    }

    public void addCloseListener(ActionListener l) {
        this.closeListeners.addListener(l);
    }

    public void removeCloseListener(ActionListener l) {
        this.closeListeners.removeListener(l);
    }

    private void fireCloseEvent(boolean parentsToo) {
        this.closeListeners.fireActionEvent(new ActionEvent(this));
        if (parentsToo && this.parentSheet != null) {
            this.parentSheet.fireCloseEvent(true);
        }
    }

    public void addBackListener(ActionListener l) {
        this.backListeners.addListener(l);
    }

    public void removeBackListener(ActionListener l) {
        this.backListeners.removeListener(l);
    }

    private void fireBackEvent() {
        this.backListeners.fireActionEvent(new ActionEvent(this));
    }
}

