/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.Component;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Stroke;
import com.codename1.ui.animations.CommonTransitions;
import com.codename1.ui.animations.Motion;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.GeneralPath;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.WeakHashMap;

public class InfiniteProgress
extends Component {
    private static boolean defaultMaterialDesignMode;
    private static int defaultMaterialDesignColor;
    private Image animation;
    private int angle = 0;
    private int tick;
    private WeakHashMap<Integer, Image> cache = new WeakHashMap();
    private int tintColor = -1879048192;
    private boolean materialDesignMode = defaultMaterialDesignMode;
    private int materialDesignColor = defaultMaterialDesignColor;
    private Motion materialLengthAngle;
    private boolean materialLengthDirection;
    private int tickCount = 3;
    private int angleIncrease = 16;

    public static boolean isDefaultMaterialDesignMode() {
        return defaultMaterialDesignMode;
    }

    public static void setDefaultMaterialDesignMode(boolean aDefaultMaterialDesignMode) {
        defaultMaterialDesignMode = aDefaultMaterialDesignMode;
    }

    public static int getDefaultMaterialDesignColor() {
        return defaultMaterialDesignColor;
    }

    public static void setDefaultMaterialDesignColor(int aDefaultMaterialDesignColor) {
        defaultMaterialDesignColor = aDefaultMaterialDesignColor;
    }

    public InfiniteProgress() {
        this.setUIID("InfiniteProgress");
    }

    public Dialog showInifiniteBlocking() {
        return this.showInfiniteBlocking();
    }

    public Dialog showInfiniteBlocking() {
        Form f = Display.getInstance().getCurrent();
        if (f == null) {
            f = new Form();
            f.show();
        }
        if (f.getClientProperty("isInfiniteProgress") == null) {
            f.setTintColor(this.tintColor);
        }
        Dialog d = new Dialog();
        d.putClientProperty("isInfiniteProgress", true);
        d.setTintColor(0);
        d.setDialogUIID("Container");
        d.setLayout(new BorderLayout());
        d.addComponent("Center", (Component)this);
        d.setTransitionInAnimator(CommonTransitions.createEmpty());
        d.setTransitionOutAnimator(CommonTransitions.createEmpty());
        d.showPacked("Center", false);
        return d;
    }

    protected void initComponent() {
        Form f;
        super.initComponent();
        if (this.animation == null) {
            this.animation = UIManager.getInstance().getThemeImageConstant("infiniteImage");
        }
        if ((f = this.getComponentForm()) != null) {
            f.registerAnimated(this);
        }
    }

    protected void deinitialize() {
        Form f = this.getComponentForm();
        if (f == null) {
            f = Display.getInstance().getCurrent();
        }
        f.deregisterAnimated(this);
        super.deinitialize();
    }

    public boolean animate() {
        return this.animate(false);
    }

    public boolean animate(boolean force) {
        if (!(force || this.isVisible() && Display.getInstance().getCurrent() == this.getComponentForm())) {
            return false;
        }
        boolean val = super.animate() || this.tick % this.tickCount == 0;
        ++this.tick;
        if (val) {
            this.angle += this.angleIncrease;
        }
        return val;
    }

    private int getMaterialDesignSize() {
        float dipCount = Float.parseFloat(this.getUIManager().getThemeConstant("infiniteMaterialDesignSize", "6.667f"));
        return Display.getInstance().convertToPixels(dipCount);
    }

    private int getMaterialImageSize() {
        float dipCount = Float.parseFloat(this.getUIManager().getThemeConstant("infiniteMaterialImageSize", "7"));
        return Display.getInstance().convertToPixels(dipCount);
    }

    protected Dimension calcPreferredSize() {
        if (this.materialDesignMode) {
            int size = this.getMaterialDesignSize();
            return new Dimension(this.getStyle().getHorizontalPadding() + size, this.getStyle().getVerticalPadding() + size);
        }
        if (this.animation == null) {
            this.animation = UIManager.getInstance().getThemeImageConstant("infiniteImage");
            if (this.animation == null) {
                int size = this.getMaterialImageSize();
                String f = this.getUIManager().getThemeConstant("infiniteDefaultColor", null);
                int color = 0x777777;
                if (f != null) {
                    color = Integer.parseInt(f, 16);
                }
                FontImage fi = FontImage.createFixed("\ue863", FontImage.getMaterialDesignFont(), color, size, size, 0);
                this.animation = fi.toImage();
            }
        }
        if (this.animation == null) {
            return new Dimension(100, 100);
        }
        Style s = this.getStyle();
        return new Dimension(s.getHorizontalPadding() + this.animation.getWidth(), s.getVerticalPadding() + this.animation.getHeight());
    }

    public void paint(Graphics g) {
        Image rotated;
        if (this.getComponentForm() != null && Display.getInstance().getCurrent() != this.getComponentForm()) {
            return;
        }
        super.paint(g);
        if (this.materialDesignMode) {
            double dr;
            int size = this.getMaterialDesignSize();
            int strokeWidth = Display.getInstance().convertToPixels(0.635f);
            int oldColor = g.getColor();
            g.setColor(this.materialDesignColor);
            int oldAlpha = g.setAndGetAlpha(255);
            Style s = this.getStyle();
            GeneralPath gp = new GeneralPath();
            if (this.materialLengthAngle == null || this.materialLengthAngle.isFinished()) {
                this.materialLengthAngle = Motion.createEaseInOutMotion(10, 300, 1000);
                this.materialLengthAngle.start();
                this.materialLengthDirection = !this.materialLengthDirection;
            }
            int angleLength = this.materialLengthAngle.getValue();
            if (!this.materialLengthDirection) {
                angleLength = 300 - angleLength;
                dr = Math.toRadians((this.angle - angleLength) % 360);
            } else {
                dr = Math.toRadians(this.angle % 360);
            }
            double x = this.getX() + s.getPaddingLeft(this.isRTL());
            double y = this.getY() + s.getPaddingTop();
            gp.arc(x, y, (double)size, (double)size, dr, Math.toRadians(angleLength));
            Stroke st = new Stroke(strokeWidth, 1, 0, 1.0f);
            g.setAntiAliased(true);
            g.drawShape(gp, st);
            g.setColor(oldColor);
            g.setAlpha(oldAlpha);
            return;
        }
        if (this.animation == null) {
            return;
        }
        int v = this.angle % 360;
        Style s = this.getStyle();
        if (this.animation instanceof FontImage) {
            rotated = this.animation.rotate(v);
        } else {
            Integer angle = new Integer(v);
            rotated = this.cache.get(angle);
            if (rotated == null) {
                rotated = this.animation.rotate(v);
                this.cache.put(v, rotated);
            }
        }
        g.drawImage(rotated, this.getX() + s.getPaddingLeftNoRTL(), this.getY() + s.getPaddingTop());
    }

    public Image getAnimation() {
        return this.animation;
    }

    public void setAnimation(Image animation) {
        this.animation = animation;
        this.cache.clear();
    }

    public String[] getPropertyNames() {
        return new String[]{"animation"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Image.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("animation")) {
            return this.animation;
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("animation")) {
            this.animation = (Image)value;
            this.cache.clear();
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public void setTintColor(int tintColor) {
        this.tintColor = tintColor;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public void setTickCount(int tickCount) {
        this.tickCount = tickCount;
    }

    public int getAngleIncrease() {
        return this.angleIncrease;
    }

    public void setAngleIncrease(int angleIncrease) {
        this.angleIncrease = angleIncrease;
    }

    public boolean isMaterialDesignMode() {
        return this.materialDesignMode;
    }

    public void setMaterialDesignMode(boolean materialDesignMode) {
        this.materialDesignMode = materialDesignMode;
    }

    public int getMaterialDesignColor() {
        return this.materialDesignColor;
    }

    public void setMaterialDesignColor(int materialDesignColor) {
        this.materialDesignColor = materialDesignColor;
    }

    static {
        defaultMaterialDesignColor = 6422766;
    }
}

