/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.util;

import com.codename1.io.Log;
import com.codename1.l10n.L10NManager;
import com.codename1.l10n.ParseException;
import com.codename1.ui.Display;
import com.codename1.util.StringUtil;

public class NumberFormat {
    static NumberFormat instance = new NumberFormat();

    private L10NManager l10n() {
        return Display.getInstance().getLocalizationManager();
    }

    public static NumberFormat getNumberInstance() {
        return instance;
    }

    public String format(double label) {
        return this.l10n().format(label);
    }

    public void setMaximumFractionDigits(int i) {
    }

    public double parseDouble(String format) throws ParseException {
        try {
            String t = StringUtil.replaceAll(format, ",", "");
            t = StringUtil.replaceAll(t, " ", "");
            return Double.parseDouble(t);
        }
        catch (Exception err) {
            try {
                double val = L10NManager.getInstance().parseDouble(format);
                return val;
            }
            catch (Exception err2) {
                try {
                    double v2 = L10NManager.getInstance().parseCurrency(format);
                    return v2;
                }
                catch (Exception err3) {
                    Log.e(err3);
                    return 0.0;
                }
            }
        }
    }
}

