/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.components;

import com.codename1.ui.Button;
import com.codename1.ui.CN;
import com.codename1.ui.Component;
import com.codename1.ui.ComponentSelector;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.FontImage;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.Label;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.plaf.Border;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitPane
extends Container {
    private final int orientation;
    public static final int HORIZONTAL_SPLIT = 0;
    public static final int VERTICAL_SPLIT = 1;
    private final Container topOrLeft;
    private final Container bottomOrRight;
    private String expandButtonUIID = "Label";
    private String collapseButtonUIID = "Label";
    private String dragHandleUIID = "Label";
    private char expandMaterialIcon;
    private char collapseMaterialIcon;
    private char dragHandleMaterialIcon;
    private Image expandIcon;
    private Image collapseIcon;
    private Image dragHandleIcon;
    private String dividerUIID = null;
    private float dividerThicknessMM = 3.0f;
    private boolean showExpandCollapseButtons = true;
    private boolean showDragHandle = true;
    private final Divider divider;
    private LayeredLayout.LayeredLayoutConstraint minInset;
    private LayeredLayout.LayeredLayoutConstraint maxInset;
    private LayeredLayout.LayeredLayoutConstraint preferredInset;
    private boolean isExpanded;
    private boolean isCollapsed;

    public SplitPane(Settings settings, Component topOrLeft, Component bottomOrRight) {
        super(new LayeredLayout());
        int orientation = settings.orientation;
        String minInset = settings.minInset;
        String preferredInset = settings.preferredInset;
        String maxInset = settings.maxInset;
        this.orientation = orientation;
        this.topOrLeft = BorderLayout.center(topOrLeft);
        this.bottomOrRight = BorderLayout.center(bottomOrRight);
        this.expandButtonUIID = settings.expandButtonUIID;
        this.collapseButtonUIID = settings.collapseButtonUIID;
        this.dragHandleUIID = settings.dragHandleUIID;
        this.dividerThicknessMM = settings.dividerThicknessMM;
        this.showDragHandle = settings.showDragHandle;
        this.showExpandCollapseButtons = settings.showExpandCollapseButtons;
        this.dividerUIID = settings.dividerUIID;
        this.divider = new Divider();
        this.add(this.topOrLeft).add(this.bottomOrRight).add(this.divider);
        LayeredLayout l = (LayeredLayout)this.getLayout();
        this.preferredInset = this.initDividerInset(l.createConstraint(), preferredInset);
        this.minInset = this.initDividerInset(l.createConstraint(), minInset);
        this.maxInset = this.initDividerInset(l.createConstraint(), maxInset);
        l.setInsets(this.topOrLeft, "0 0 0 0").setInsets(this.topOrLeft, "0 0 0 0");
        this.preferredInset.copyTo(l.getOrCreateConstraint(this.divider));
        switch (orientation) {
            case 0: {
                l.setReferenceComponentRight(this.topOrLeft, this.divider, 1.0f);
                l.setReferenceComponentLeft(this.bottomOrRight, this.divider, 1.0f);
                break;
            }
            default: {
                l.setReferenceComponentBottom(this.topOrLeft, this.divider, 1.0f);
                l.setReferenceComponentTop(this.bottomOrRight, this.divider, 1.0f);
            }
        }
    }

    public SplitPane(int orientation, Component topOrLeft, Component bottomOrRight, String minInset, String preferredInset, String maxInset) {
        this(new Settings(orientation, minInset, preferredInset, maxInset), topOrLeft, bottomOrRight);
    }

    public void changeInsets(String minInset, String preferredInset, String maxInset) {
        LayeredLayout l = (LayeredLayout)this.getLayout();
        this.initDividerInset(l.createConstraint(), preferredInset).copyTo(this.preferredInset);
        this.initDividerInset(l.createConstraint(), minInset).copyTo(this.minInset);
        this.initDividerInset(l.createConstraint(), maxInset).copyTo(this.maxInset);
        l.setInsets(this.topOrLeft, "0 0 0 0").setInsets(this.topOrLeft, "0 0 0 0");
        this.preferredInset.copyTo(l.getOrCreateConstraint(this.divider));
    }

    private LayeredLayout.LayeredLayoutConstraint.Inset getDividerInset() {
        LayeredLayout.LayeredLayoutConstraint cnst = ((LayeredLayout)this.getLayout()).getOrCreateConstraint(this.divider);
        return this.getFixedInset(cnst);
    }

    private LayeredLayout.LayeredLayoutConstraint.Inset getAutoInset() {
        LayeredLayout.LayeredLayoutConstraint cnst = ((LayeredLayout)this.getLayout()).getOrCreateConstraint(this.divider);
        return this.getAutoInset(cnst);
    }

    private LayeredLayout.LayeredLayoutConstraint.Inset getFixedInset(LayeredLayout.LayeredLayoutConstraint cnst) {
        switch (this.orientation) {
            case 1: {
                return cnst.top();
            }
        }
        return cnst.left();
    }

    private LayeredLayout.LayeredLayoutConstraint.Inset getMinDividerInset() {
        return this.getFixedInset(this.minInset);
    }

    private LayeredLayout.LayeredLayoutConstraint.Inset getMaxDividerInset() {
        return this.getFixedInset(this.maxInset);
    }

    private void setDividerInset(String inset) {
        this.getDividerInset().setValueAsString(inset);
        this.clampInset();
    }

    private LayeredLayout.LayeredLayoutConstraint.Inset getAutoInset(LayeredLayout.LayeredLayoutConstraint cnst) {
        switch (this.orientation) {
            case 1: {
                return cnst.bottom();
            }
        }
        return cnst.right();
    }

    private Set<LayeredLayout.LayeredLayoutConstraint.Inset> getZeroInsets(LayeredLayout.LayeredLayoutConstraint cnst) {
        HashSet<LayeredLayout.LayeredLayoutConstraint.Inset> out = new HashSet<LayeredLayout.LayeredLayoutConstraint.Inset>();
        switch (this.orientation) {
            case 1: {
                out.add(cnst.left());
                out.add(cnst.right());
                break;
            }
            default: {
                out.add(cnst.top());
                out.add(cnst.bottom());
            }
        }
        return out;
    }

    private LayeredLayout.LayeredLayoutConstraint initDividerInset(LayeredLayout.LayeredLayoutConstraint cnst, String insetVal) {
        this.getFixedInset(cnst).setValueAsString(insetVal);
        this.getAutoInset(cnst).setValueAsString("auto");
        for (LayeredLayout.LayeredLayoutConstraint.Inset i : this.getZeroInsets(cnst)) {
            i.setValueAsString("0");
        }
        return cnst;
    }

    private void clampInset() {
        LayeredLayout.LayeredLayoutConstraint.Inset maxInset;
        int px = this.getDividerInset().getAbsolutePixels(this.divider);
        this.isCollapsed = false;
        this.isExpanded = false;
        LayeredLayout.LayeredLayoutConstraint.Inset minInset = this.getMinDividerInset();
        if (minInset.getAbsolutePixels(this.divider) >= px) {
            minInset.copyTo(this.getDividerInset());
            this.isCollapsed = true;
            this.isExpanded = false;
        }
        if ((maxInset = this.getMaxDividerInset()).getAbsolutePixels(this.divider) <= px) {
            maxInset.copyTo(this.getDividerInset());
            this.isExpanded = true;
            this.isCollapsed = false;
        }
        if ((px = this.getAutoInset().getAbsolutePixels(this.divider)) < 0) {
            this.getDividerInset().translatePixels(px, true, this.divider.getParent());
            this.isExpanded = true;
            this.isCollapsed = false;
        }
    }

    private void setTopOrLeftComponent(Component cmp) {
        this.topOrLeft.removeAll();
        this.topOrLeft.add((Object)"Center", cmp);
    }

    public void setTop(Component cmp) {
        this.setTopOrLeftComponent(cmp);
    }

    public void setLeft(Component cmp) {
        this.setTopOrLeftComponent(cmp);
    }

    private void setBottomOrRightComponent(Component cmp) {
        this.bottomOrRight.removeAll();
        this.bottomOrRight.add((Object)"Center", cmp);
    }

    public void setBottom(Component cmp) {
        this.setBottomOrRightComponent(cmp);
    }

    public Component getBottomOrRightComponent() {
        Iterator<Component> iterator = this.bottomOrRight.iterator();
        if (iterator.hasNext()) {
            Component c = iterator.next();
            return c;
        }
        return null;
    }

    public Component getBottom() {
        return this.getBottomOrRightComponent();
    }

    public Component getRight() {
        return this.getBottomOrRightComponent();
    }

    public Component getTopOrLeftComponent() {
        Iterator<Component> iterator = this.topOrLeft.iterator();
        if (iterator.hasNext()) {
            Component c = iterator.next();
            return c;
        }
        return null;
    }

    public Component getTop() {
        return this.getTopOrLeftComponent();
    }

    public Component getLeft() {
        return this.getTopOrLeftComponent();
    }

    public void setRight(Component cmp) {
        this.setBottomOrRightComponent(cmp);
    }

    public void toggleCollapsePreferred() {
        if (this.isCollapsed) {
            this.expand();
        } else if (this.isExpanded) {
            this.collapse(true);
        } else {
            this.collapse();
        }
    }

    public void toggleExpandPreferred() {
        if (this.isExpanded) {
            this.collapse();
        } else if (this.isCollapsed) {
            this.expand(true);
        } else {
            this.expand();
        }
    }

    public void expand() {
        this.expand(false);
    }

    public void expand(boolean force) {
        if (this.isCollapsed && !force) {
            this.getFixedInset(this.preferredInset).copyTo(this.getDividerInset());
            this.clampInset();
            this.isCollapsed = false;
            this.animateLayout(300);
        } else if (!this.isExpanded) {
            this.getFixedInset(this.maxInset).copyTo(this.getDividerInset());
            this.clampInset();
            this.isExpanded = true;
            this.animateLayout(300);
        }
    }

    public void collapse() {
        this.collapse(false);
    }

    public void collapse(boolean force) {
        if (!this.isCollapsed) {
            if (this.isExpanded && !force) {
                this.getFixedInset(this.preferredInset).copyTo(this.getDividerInset());
                this.clampInset();
                this.isExpanded = false;
                this.animateLayout(300);
            } else {
                this.getFixedInset(this.minInset).copyTo(this.getDividerInset());
                this.clampInset();
                this.isCollapsed = true;
                this.animateLayout(300);
            }
        }
    }

    public void setInset(String inset, boolean clamp) {
        this.getDividerInset().setValueAsString(inset);
        this.isExpanded = false;
        this.isCollapsed = false;
        if (clamp) {
            this.clampInset();
        }
    }

    public void setInset(String inset) {
        this.setInset(inset, true);
    }

    public void setPreferredInset(String inset) {
        this.getFixedInset(this.preferredInset).setValueAsString(inset);
    }

    public String getPreferredInset() {
        return this.getFixedInset(this.preferredInset).getValueAsString();
    }

    public void setMinInset(String inset) {
        this.getFixedInset(this.minInset).setValueAsString(inset);
    }

    public String getMinInset() {
        return this.getFixedInset(this.minInset).getValueAsString();
    }

    public void setMaxInset(String inset) {
        this.getFixedInset(this.maxInset).setValueAsString(inset);
    }

    public String getMaxInset() {
        return this.getFixedInset(this.maxInset).getValueAsString();
    }

    private class Divider
    extends Container {
        int pressedX;
        int pressedY;
        int draggedX;
        int draggedY;
        LayeredLayout.LayeredLayoutConstraint pressedPreferredConstraint;
        LayeredLayout.LayeredLayoutConstraint pressedConstraint;
        private final Button btnCollapse;
        private final Button btnExpand;
        private final Label dragHandle;
        private boolean inDrag;

        private char getCollapseMaterialIcon() {
            if (SplitPane.this.collapseMaterialIcon != '\u0000') {
                return SplitPane.this.collapseMaterialIcon;
            }
            switch (SplitPane.this.orientation) {
                case 0: {
                    return '\ue314';
                }
            }
            return '\ue316';
        }

        private char getExpandMaterialIcon() {
            if (SplitPane.this.expandMaterialIcon != '\u0000') {
                return SplitPane.this.expandMaterialIcon;
            }
            switch (SplitPane.this.orientation) {
                case 0: {
                    return '\ue315';
                }
            }
            return '\ue313';
        }

        private Image getDragIconImage() {
            Image img = null;
            if (SplitPane.this.dragHandleIcon != null) {
                img = SplitPane.this.dragHandleIcon;
            } else {
                char materialIcon = '\ue25d';
                if (SplitPane.this.dragHandleMaterialIcon != '\u0000') {
                    materialIcon = SplitPane.this.dragHandleMaterialIcon;
                }
                img = FontImage.createMaterial(materialIcon, this.getStyle(), 3.0f);
            }
            switch (SplitPane.this.orientation) {
                case 0: {
                    return img.rotate90Degrees(true);
                }
            }
            return img;
        }

        private int getDragCursor() {
            return SplitPane.this.orientation == 0 ? 11 : 8;
        }

        private Border createBorder() {
            return SplitPane.this.orientation == 0 ? Border.createCompoundBorder(Border.createEmpty(), Border.createEmpty(), Border.createBevelRaised(), Border.createBevelRaised()) : Border.createCompoundBorder(Border.createBevelRaised(), Border.createBevelRaised(), Border.createEmpty(), Border.createEmpty());
        }

        Divider() {
            super(new LayeredLayout());
            if (SplitPane.this.dividerUIID != null) {
                this.setUIID(SplitPane.this.dividerUIID);
            }
            this.btnCollapse = ComponentSelector.$(new Button()).setUIID(SplitPane.this.collapseButtonUIID).setCursor(12).each(new ComponentSelector.ComponentClosure(){

                public void call(Component c) {
                    if (SplitPane.this.collapseIcon != null) {
                        ((Label)c).setIcon(SplitPane.this.collapseIcon);
                    } else {
                        ((Label)c).setMaterialIcon(Divider.this.getCollapseMaterialIcon());
                    }
                }
            }).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SplitPane.this.collapse();
                }
            }).selectAllStyles().setMargin(0).setPadding(0).asComponent(Button.class);
            this.btnExpand = ComponentSelector.$(new Button()).setCursor(12).setUIID(SplitPane.this.expandButtonUIID).each(new ComponentSelector.ComponentClosure(){

                public void call(Component c) {
                    if (SplitPane.this.expandIcon != null) {
                        ((Label)c).setIcon(SplitPane.this.expandIcon);
                    } else {
                        ((Label)c).setMaterialIcon(Divider.this.getExpandMaterialIcon());
                    }
                }
            }).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SplitPane.this.expand();
                }
            }).selectAllStyles().setMargin(0).setPadding(0).asComponent(Button.class);
            this.dragHandle = ComponentSelector.$(new Label()).setUIID(SplitPane.this.dragHandleUIID).setIcon(this.getDragIconImage()).setMargin(0).setIgnorePointerEvents(true).setPadding(0).setDraggable(true).setCursor(this.getDragCursor()).asComponent(Label.class);
            if (SplitPane.this.showExpandCollapseButtons) {
                this.add(this.btnCollapse).add(this.btnExpand);
            }
            if (SplitPane.this.showDragHandle) {
                this.add(this.dragHandle);
            }
            boolean isDesktop = CN.isDesktop();
            LayeredLayout l = (LayeredLayout)this.getLayout();
            switch (SplitPane.this.orientation) {
                case 0: {
                    l.setInsets(this.btnCollapse, "0 0 auto 0").setInsets(this.btnExpand, "0 0 auto 0").setInsets(this.dragHandle, "auto auto auto auto").setReferenceComponentTop(this.btnExpand, this.btnCollapse, 1.0f);
                    if (isDesktop) break;
                    l.setInsets(this.btnExpand, "auto 0 0 0").setReferenceComponentTop(this.btnExpand, null, 1.0f);
                    break;
                }
                default: {
                    l.setInsets(this.btnCollapse, "0 auto 0 0").setInsets(this.btnExpand, "0 auto 0 0").setInsets(this.dragHandle, "auto auto auto auto").setReferenceComponentLeft(this.btnExpand, this.btnCollapse, 1.0f);
                    if (isDesktop) break;
                    l.setInsets(this.btnExpand, "0 0 0 auto").setReferenceComponentLeft(this.btnExpand, null, 1.0f);
                }
            }
            if (SplitPane.this.dividerUIID == null) {
                ComponentSelector.$(this).setBorder(this.createBorder()).setCursor(this.getDragCursor()).setDraggable(true);
            } else {
                ComponentSelector.$(this).setCursor(this.getDragCursor()).setDraggable(true);
            }
        }

        protected boolean isStickyDrag() {
            return true;
        }

        protected void initComponent() {
            super.initComponent();
            this.getComponentForm().setEnableCursors(true);
        }

        protected Dimension calcPreferredSize() {
            Display d = Display.getInstance();
            switch (SplitPane.this.orientation) {
                case 1: {
                    return new Dimension(d.getDisplayWidth(), d.convertToPixels(SplitPane.this.dividerThicknessMM));
                }
            }
            return new Dimension(d.convertToPixels(SplitPane.this.dividerThicknessMM), d.getDisplayHeight());
        }

        public void pointerPressed(int x, int y) {
            super.pointerPressed(x, y);
            this.pressedX = x;
            this.pressedY = y;
            this.pressedConstraint = ((LayeredLayout)this.getLayout()).getOrCreateConstraint(this).copy();
            this.pressedPreferredConstraint = SplitPane.this.preferredInset.copy();
            this.inDrag = true;
            this.pointerDragged(x, y);
        }

        public void pointerDragged(int x, int y) {
            super.pointerDragged(x, y);
            if (!this.inDrag) {
                return;
            }
            this.setVisible(true);
            this.draggedX = x;
            this.draggedY = y;
            this.updateInsets();
            SplitPane.this.revalidate();
        }

        public void pointerReleased(int x, int y) {
            super.pointerReleased(x, y);
            this.inDrag = false;
        }

        protected void dragFinished(int x, int y) {
            super.dragFinished(x, y);
            if (!SplitPane.this.isExpanded && !SplitPane.this.isCollapsed) {
                SplitPane.this.getDividerInset().constraint().copyTo(SplitPane.this.preferredInset);
            }
            this.inDrag = false;
        }

        private void updateInsets() {
            LayeredLayout ll = (LayeredLayout)SplitPane.this.getLayout();
            LayeredLayout.LayeredLayoutConstraint cnst = this.pressedConstraint.copy();
            int diff = 0;
            if (SplitPane.this.orientation == 0) {
                diff = this.draggedX - this.pressedX;
                cnst.left().translatePixels(diff, false, this.getParent());
            } else {
                diff = this.draggedY - this.pressedY;
                cnst.top().translatePixels(diff, false, this.getParent());
            }
            cnst.copyTo(ll.getOrCreateConstraint(this));
            SplitPane.this.clampInset();
        }

        protected Image getDragImage() {
            return null;
        }

        protected void drawDraggedImage(Graphics g, Image img, int x, int y) {
        }

        protected int getDragRegionStatus(int x, int y) {
            switch (SplitPane.this.orientation) {
                case 0: {
                    return 31;
                }
            }
            return 32;
        }
    }

    public static class Settings {
        private int orientation = 0;
        private String dividerUIID = null;
        private String expandButtonUIID = "Label";
        private String collapseButtonUIID = "Label";
        private String dragHandleUIID = "Label";
        private float dividerThicknessMM = 3.0f;
        private boolean showExpandCollapseButtons = true;
        private boolean showDragHandle = true;
        private String minInset = "0";
        private String preferredInset = "50%";
        private String maxInset = "100%";
        private char expandMaterialIcon;
        private char collapseMaterialIcon;
        private char dragHandleMaterialIcon;
        private Image expandIcon;
        private Image collapseIcon;
        private Image dragHandleIcon;

        public Settings() {
        }

        public Settings(int orientation, String minInset, String preferredInset, String maxInset) {
            this.orientation = orientation;
            this.minInset = minInset;
            this.preferredInset = preferredInset;
            this.maxInset = maxInset;
        }

        public Settings orientation(int orientation) {
            this.orientation = orientation;
            return this;
        }

        public Settings expandButtonUIID(String expandButtonUIID) {
            this.expandButtonUIID = expandButtonUIID;
            return this;
        }

        public Settings collapseButtonUIID(String collapseButtonUIID) {
            this.collapseButtonUIID = collapseButtonUIID;
            return this;
        }

        public Settings dragHandleUIID(String dragHandleUIID) {
            this.dragHandleUIID = dragHandleUIID;
            return this;
        }

        public Settings buttonUIIDs(String uiid) {
            this.dragHandleUIID = uiid;
            this.collapseButtonUIID = uiid;
            this.expandButtonUIID = uiid;
            return this;
        }

        public Settings collapseIcon(Image icon) {
            this.collapseIcon = icon;
            return this;
        }

        public Settings expandIcon(Image icon) {
            this.expandIcon = icon;
            return this;
        }

        public Settings dragHandleIcon(Image icon) {
            this.dragHandleIcon = icon;
            return this;
        }

        public Settings collapseMaterialIcon(char icon) {
            this.collapseMaterialIcon = icon;
            return this;
        }

        public Settings expandMaterialIcon(char icon) {
            this.expandMaterialIcon = icon;
            return this;
        }

        public Settings dragHandleMaterialIcon(char icon) {
            this.dragHandleMaterialIcon = icon;
            return this;
        }

        public Settings dividerThicknessMM(float dividerThicknessMM) {
            this.dividerThicknessMM = dividerThicknessMM;
            return this;
        }

        public Settings dividerUIID(String uiid) {
            this.dividerUIID = uiid;
            return this;
        }

        public Settings minInset(String minInset) {
            this.minInset = minInset;
            return this;
        }

        public Settings preferredInset(String preferredInset) {
            this.preferredInset = preferredInset;
            return this;
        }

        public Settings maxInset(String maxInset) {
            this.maxInset = maxInset;
            return this;
        }

        public Settings insets(String min, String preferred, String max) {
            this.minInset = min;
            this.preferredInset = preferred;
            this.maxInset = max;
            return this;
        }

        public Settings showExpandCollapseButtons(boolean show) {
            this.showExpandCollapseButtons = show;
            return this;
        }

        public Settings showDragHandle(boolean show) {
            this.showDragHandle = show;
            return this;
        }
    }
}

