/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.charts.models;

import com.codename1.charts.models.CategorySeries;
import com.codename1.charts.models.XYSeries;
import java.util.ArrayList;
import java.util.List;

public class RangeCategorySeries
extends CategorySeries {
    private List<Double> mMaxValues = new ArrayList<Double>();

    public RangeCategorySeries(String title) {
        super(title);
    }

    public synchronized void add(double minValue, double maxValue) {
        super.add(minValue);
        this.mMaxValues.add(maxValue);
    }

    public synchronized void add(String category, double minValue, double maxValue) {
        super.add(category, minValue);
        this.mMaxValues.add(maxValue);
    }

    public synchronized void remove(int index) {
        super.remove(index);
        this.mMaxValues.remove(index);
    }

    public synchronized void clear() {
        super.clear();
        this.mMaxValues.clear();
    }

    public double getMinimumValue(int index) {
        return this.getValue(index);
    }

    public double getMaximumValue(int index) {
        return this.mMaxValues.get(index);
    }

    public XYSeries toXYSeries() {
        XYSeries xySeries = new XYSeries(this.getTitle());
        int length = this.getItemCount();
        for (int k = 0; k < length; ++k) {
            xySeries.add(k + 1, this.getMinimumValue(k));
            xySeries.add((double)k + 1.000001, this.getMaximumValue(k));
        }
        return xySeries;
    }
}

