/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.system;

import com.codename1.io.Log;
import com.codename1.io.NetworkEvent;
import com.codename1.ui.CN;
import com.codename1.ui.Dialog;
import com.codename1.ui.Form;
import com.codename1.ui.Label;
import com.codename1.ui.Toolbar;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.util.Resources;

public class Lifecycle {
    private Form current;
    private Resources theme;

    public void init(Object context) {
        CN.updateNetworkThreadCount(this.getNetworkThreadCount());
        this.theme = UIManager.initFirstTheme(this.getThemeName());
        Toolbar.setGlobalToolbar(true);
        this.bindCrashProtection();
        CN.addNetworkErrorListener(new ActionListener<NetworkEvent>(){

            @Override
            public void actionPerformed(NetworkEvent err) {
                Lifecycle.this.handleNetworkError(err);
            }
        });
    }

    protected void bindCrashProtection() {
        Log.bindCrashProtection(true);
    }

    protected int getNetworkThreadCount() {
        return 2;
    }

    protected String getThemeName() {
        return "/theme";
    }

    public Resources getTheme() {
        return this.theme;
    }

    protected void handleNetworkError(NetworkEvent err) {
        err.consume();
        if (err.getError() != null) {
            Log.e(err.getError());
        }
        Log.sendLogAsync();
        Dialog.show("Connection Error", "There was a networking error in the connection to " + err.getConnectionRequest().getUrl(), "OK", null);
    }

    public void start() {
        if (this.current != null) {
            this.current.show();
            return;
        }
        this.runApp();
    }

    public void runApp() {
        Form hello = new Form("Hello", BoxLayout.y());
        hello.add(new Label("You should override runApp() with your code"));
        hello.show();
    }

    public void stop() {
        this.current = this.getCurrentForm();
        if (this.current instanceof Dialog) {
            ((Dialog)this.current).dispose();
            this.current = this.getCurrentForm();
        }
    }

    public void destroy() {
    }

    protected Form getCurrentForm() {
        return this.current;
    }

    protected void setCurrentForm(Form current) {
        this.current = current;
    }
}

