/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.maps.layers;

import com.codename1.maps.BoundingBox;
import com.codename1.maps.Coord;
import com.codename1.maps.Tile;
import com.codename1.maps.layers.Layer;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.geom.Point;

public class PointLayer
extends Coord
implements Layer {
    private final String name;
    private Image icon;
    private boolean displayName;

    public PointLayer(Coord position, String name, Image icon) {
        super(position);
        this.name = name;
        this.icon = icon;
    }

    public String getName() {
        return this.name;
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    public void setDisplayName(boolean displayName) {
        this.displayName = displayName;
    }

    public void paint(Graphics g, Tile tile) {
        Point pos = tile.pointPosition(this);
        int width = 6;
        int height = 6;
        if (this.icon != null) {
            width = this.icon.getWidth();
            height = this.icon.getHeight();
        }
        int x = pos.getX() - width / 2;
        int y = pos.getY() - height / 2;
        if (this.icon == null) {
            g.fillRect(x, y, width, height);
        } else {
            g.drawImage(this.icon, x, y);
        }
        if (this.name != null && this.displayName) {
            g.drawString(this.getName(), x + width + 1, pos.getY() - g.getFont().getHeight() / 2 - 1);
        }
    }

    public String toString() {
        return super.toString() + " " + this.name;
    }

    public BoundingBox boundingBox() {
        return null;
    }
}

