/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.ui.events.DataChangedListener;
import com.codename1.ui.events.SelectionListener;
import com.codename1.ui.list.ListModel;
import com.codename1.ui.util.EventDispatcher;

class SpinnerNumberModel
implements ListModel {
    private EventDispatcher dataListener = new EventDispatcher();
    private EventDispatcher selectionListener = new EventDispatcher();
    private double min;
    private double max;
    private double currentValue;
    private double step;
    boolean realValues;
    private boolean setSelectedIndexReentrantLock;

    void setValue(Object value) {
        int oldIndex = this.getSelectedIndex();
        this.currentValue = value instanceof Integer ? ((Integer)value).doubleValue() : ((Double)value).doubleValue();
        if (oldIndex != this.getSelectedIndex()) {
            this.selectionListener.fireSelectionEvent(oldIndex, this.getSelectedIndex());
        }
    }

    Object getValue() {
        if (this.realValues) {
            return new Double(this.currentValue);
        }
        return new Integer((int)this.currentValue);
    }

    public SpinnerNumberModel(int min, int max, int currentValue, int step) {
        this.max = max;
        this.min = min;
        this.currentValue = currentValue;
        this.step = step;
    }

    public SpinnerNumberModel(double min, double max, double currentValue, double step) {
        this.max = max;
        this.min = min;
        this.currentValue = currentValue;
        this.step = step;
        this.realValues = true;
    }

    public Object getItemAt(int index) {
        if (this.realValues) {
            return new Double(this.min + this.step * (double)index);
        }
        return new Integer((int)(this.min + this.step * (double)index));
    }

    public int getSize() {
        return (int)((this.max - this.min) / this.step) + 1;
    }

    public int getSelectedIndex() {
        return (int)((this.currentValue - this.min) / this.step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedIndex(int index) {
        if (this.setSelectedIndexReentrantLock) {
            return;
        }
        this.setSelectedIndexReentrantLock = true;
        try {
            int oldIndex = this.getSelectedIndex();
            this.currentValue = this.min + (double)index * this.step;
            int newIndex = this.getSelectedIndex();
            if (oldIndex != newIndex) {
                this.selectionListener.fireSelectionEvent(oldIndex, newIndex);
            }
            Object var5_4 = null;
            this.setSelectedIndexReentrantLock = false;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setSelectedIndexReentrantLock = false;
            throw throwable;
        }
    }

    public void addDataChangedListener(DataChangedListener l) {
        this.dataListener.addListener(l);
    }

    public void removeDataChangedListener(DataChangedListener l) {
        this.dataListener.removeListener(l);
    }

    public void addSelectionListener(SelectionListener l) {
        this.selectionListener.addListener(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.selectionListener.removeListener(l);
    }

    public void addItem(Object item) {
    }

    public void removeItem(int index) {
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

