/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.impl;

import com.codename1.capture.VideoCaptureConstraints;
import com.codename1.codescan.CodeScanner;
import com.codename1.components.AudioRecorderComponent;
import com.codename1.components.FileTree;
import com.codename1.components.FileTreeModel;
import com.codename1.contacts.Contact;
import com.codename1.db.Cursor;
import com.codename1.db.Database;
import com.codename1.impl.CodenameOneThread;
import com.codename1.io.ConnectionRequest;
import com.codename1.io.Cookie;
import com.codename1.io.File;
import com.codename1.io.FileSystemStorage;
import com.codename1.io.Log;
import com.codename1.io.Preferences;
import com.codename1.io.Storage;
import com.codename1.io.Util;
import com.codename1.io.tar.TarEntry;
import com.codename1.io.tar.TarInputStream;
import com.codename1.l10n.L10NManager;
import com.codename1.location.LocationManager;
import com.codename1.media.Media;
import com.codename1.media.MediaRecorderBuilder;
import com.codename1.messaging.Message;
import com.codename1.notifications.LocalNotification;
import com.codename1.payment.Purchase;
import com.codename1.payment.PurchaseCallback;
import com.codename1.push.PushCallback;
import com.codename1.ui.BrowserComponent;
import com.codename1.ui.BrowserWindow;
import com.codename1.ui.Button;
import com.codename1.ui.CN;
import com.codename1.ui.Command;
import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Dialog;
import com.codename1.ui.Display;
import com.codename1.ui.EncodedImage;
import com.codename1.ui.Font;
import com.codename1.ui.Form;
import com.codename1.ui.Graphics;
import com.codename1.ui.Image;
import com.codename1.ui.PeerComponent;
import com.codename1.ui.Sheet;
import com.codename1.ui.Stroke;
import com.codename1.ui.TextArea;
import com.codename1.ui.TextSelection;
import com.codename1.ui.Transform;
import com.codename1.ui.animations.Animation;
import com.codename1.ui.animations.Transition;
import com.codename1.ui.events.ActionEvent;
import com.codename1.ui.events.ActionListener;
import com.codename1.ui.events.MessageEvent;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.Rectangle;
import com.codename1.ui.geom.Shape;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.util.ImageIO;
import com.codename1.util.AsyncResource;
import com.codename1.util.FailureCallback;
import com.codename1.util.StringUtil;
import com.codename1.util.SuccessCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CodenameOneImplementation {
    private static final int RTL_RANGE_BEGIN = 1424;
    private static final int RTL_RANGE_END = 1983;
    private Object lightweightClipboard;
    private Hashtable linearGradientCache;
    private Hashtable radialGradientCache;
    private boolean builtinSoundEnabled = true;
    private boolean dragStarted = false;
    private int dragActivationCounter = 0;
    private int dragActivationX = 0;
    private int dragActivationY = 0;
    private int dragStartPercentage = 3;
    private Form currentForm;
    private static Object displayLock;
    private Animation[] paintQueue = new Animation[200];
    private Animation[] paintQueueTemp = new Animation[200];
    private int paintQueueFill = 0;
    private Graphics codenameOneGraphics;
    private static boolean bidi;
    private String packageName;
    private static int pollingMillis;
    private Component editingText;
    private String appArg;
    private int[] xPointerEvent = new int[1];
    private int[] yPointerEvent = new int[1];
    private int pointerPressedX;
    private int pointerPressedY;
    private Hashtable builtinSounds = new Hashtable();
    private Object storageData;
    private Hashtable cookies;
    private ActionListener logger;
    private static boolean pollingThreadRunning;
    private static PushCallback callback;
    private static PurchaseCallback purchaseCallback;
    private int commandBehavior = 1;
    private static Runnable onCurrentFormChange;
    private static Runnable onExit;
    private boolean useNativeCookieStore = true;
    private boolean initiailized = false;
    private Rectangle paintDirtyTmpRect = new Rectangle();
    private BrowserComponent sharedJavascriptContext;

    static void setOnCurrentFormChange(Runnable on) {
        onCurrentFormChange = on;
    }

    public static void setOnExit(Runnable on) {
        onExit = on;
    }

    public final void initImpl(Object m) {
        this.init(m);
        if (m != null) {
            String clsName = m.getClass().getName();
            this.packageName = clsName.substring(0, clsName.lastIndexOf(46));
        }
        this.initiailized = true;
    }

    public boolean isInitialized() {
        return this.initiailized;
    }

    protected void sendPushRegistrationError(String message, int errorCode) {
        if (callback != null) {
            callback.pushRegistrationError(message, errorCode);
        }
    }

    public static void setPushCallback(PushCallback push) {
        callback = push;
    }

    public static void setPurchaseCallback(PurchaseCallback pc) {
        purchaseCallback = pc;
    }

    public static PurchaseCallback getPurchaseCallback() {
        return purchaseCallback;
    }

    public abstract void init(Object var1);

    public void initEDT() {
    }

    public void deinitialize() {
        this.initiailized = false;
    }

    public void playDialogSound(int type) {
    }

    public void vibrate(int duration) {
    }

    public void flashBacklight(int duration) {
    }

    public abstract int getDisplayWidth();

    public abstract int getDisplayHeight();

    public int getActualDisplayHeight() {
        return this.getDisplayHeight();
    }

    public boolean handleEDTException(Throwable err) {
        return false;
    }

    public final void editStringImpl(Component cmp, int maxSize, int constraint, String text, int initiatingKeycode) {
        if (cmp instanceof TextArea) {
            ((TextArea)cmp).registerAsInputDevice();
        }
        this.editingText = cmp;
        this.editString(cmp, maxSize, constraint, text, initiatingKeycode);
        if (!this.isAsyncEditMode()) {
            this.editingText = null;
        }
    }

    public void setFocusedEditingText(Component cmp) {
        Form form;
        this.editingText = cmp;
        if (cmp != null && (form = cmp.getComponentForm()) != null) {
            form.setFocused(cmp);
        }
    }

    public void stopTextEditing() {
    }

    public void stopTextEditing(Runnable onFinish) {
        this.stopTextEditing();
        onFinish.run();
    }

    public boolean usesInvokeAndBlockForEditString() {
        return false;
    }

    public abstract void editString(Component var1, int var2, int var3, String var4, int var5);

    public boolean nativeEditorPaintsHint() {
        return true;
    }

    public boolean isEditingText() {
        return this.editingText != null;
    }

    public boolean platformUsesInputMode() {
        Display d = Display.getInstance();
        String platform = d.getPlatformName();
        return "me".equals(platform) || "rim".equals(platform);
    }

    public boolean isNativeEditorVisible(Component c) {
        return this.isNativeInputSupported() && this.isEditingText(c);
    }

    public void updateNativeEditorText(Component c, String text) {
    }

    public void hideTextEditor() {
        Component c = this.editingText;
        this.editingText = null;
        if (c != null) {
            c.repaint();
        }
    }

    public String getAppArg() {
        return this.appArg;
    }

    public void setAppArg(String arg) {
        this.appArg = arg;
    }

    protected final void repaintTextEditor(final boolean focus) {
        Display.getInstance().callSerially(new Runnable(){

            public void run() {
                if (CodenameOneImplementation.this.editingText != null) {
                    CodenameOneImplementation.this.editingText.repaint();
                    if (focus) {
                        CodenameOneImplementation.this.editingText.requestFocus();
                    }
                }
            }
        });
    }

    public boolean isEditingText(Component c) {
        return this.editingText == c;
    }

    public Component getEditingText() {
        return this.editingText;
    }

    public boolean isAsyncEditMode() {
        return false;
    }

    public int getInvisibleAreaUnderVKB() {
        return 0;
    }

    public void saveTextEditingState() {
    }

    public boolean hasPendingPaints() {
        return this.paintQueueFill != 0;
    }

    public int numAlphaLevels() {
        return 255;
    }

    public int numColors() {
        return 65536;
    }

    public Graphics getComponentScreenGraphics(Component cmp, Graphics currentContext) {
        return currentContext;
    }

    protected void paintOverlay(Graphics g) {
    }

    private void getPaintableBounds(Component c, Rectangle out) {
        int x = c.getAbsoluteX() + c.getScrollX();
        int y = c.getAbsoluteY() + c.getScrollY();
        int x2 = x + c.getWidth();
        int y2 = y + c.getHeight();
        Container parent = null;
        parent = c.getParent();
        if (parent != null) {
            this.getPaintableBounds(parent, out);
            x = Math.max(out.getX(), x);
            y = Math.max(out.getY(), y);
            x2 = Math.min(out.getX() + out.getWidth(), x2);
            y2 = Math.min(out.getY() + out.getHeight(), y2);
        }
        out.setBounds(x, y, x2 - x, y2 - y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDirty() {
        int size = 0;
        Object object = displayLock;
        synchronized (object) {
            size = this.paintQueueFill;
            Animation[] array = this.paintQueue;
            this.paintQueue = this.paintQueueTemp;
            this.paintQueueTemp = array;
            this.paintQueueFill = 0;
        }
        if (size > 0) {
            Graphics wrapper = this.getCodenameOneGraphics();
            int dwidth = this.getDisplayWidth();
            int dheight = this.getDisplayHeight();
            int topX = dwidth;
            int topY = dheight;
            int bottomX = 0;
            int bottomY = 0;
            for (int iter = 0; iter < size; ++iter) {
                Animation ani = this.paintQueueTemp[iter];
                if (ani == null) continue;
                this.paintQueueTemp[iter] = null;
                wrapper.translate(-wrapper.getTranslateX(), -wrapper.getTranslateY());
                wrapper.resetAffine();
                wrapper.setClip(0, 0, dwidth, dheight);
                if (ani instanceof Component) {
                    Component cmp = (Component)ani;
                    Rectangle dirty = cmp.getDirtyRegion();
                    if (dirty != null) {
                        Dimension d = dirty.getSize();
                        wrapper.setClip(dirty.getX(), dirty.getY(), d.getWidth(), d.getHeight());
                        cmp.setDirtyRegion(null);
                    }
                    cmp.paintComponent(wrapper);
                    this.getPaintableBounds(cmp, this.paintDirtyTmpRect);
                    int cmpAbsX = this.paintDirtyTmpRect.getX();
                    topX = Math.min(cmpAbsX, topX);
                    bottomX = Math.max(cmpAbsX + this.paintDirtyTmpRect.getWidth(), bottomX);
                    int cmpAbsY = this.paintDirtyTmpRect.getY();
                    topY = Math.min(cmpAbsY, topY);
                    bottomY = Math.max(cmpAbsY + this.paintDirtyTmpRect.getHeight(), bottomY);
                    continue;
                }
                bottomX = dwidth;
                bottomY = dheight;
                topX = 0;
                topY = 0;
                ani.paint(wrapper);
            }
            this.paintOverlay(wrapper);
            this.flushGraphics(topX, topY, bottomX - topX, bottomY - topY);
        }
    }

    public void edtIdle(boolean enter) {
    }

    public abstract void flushGraphics(int var1, int var2, int var3, int var4);

    public abstract void flushGraphics();

    protected Graphics getCodenameOneGraphics() {
        return this.codenameOneGraphics;
    }

    public void setCodenameOneGraphics(Graphics g) {
        this.codenameOneGraphics = g;
    }

    public boolean paintNativePeersBehind() {
        return false;
    }

    public void setDisplayLock(Object lock) {
        displayLock = lock;
    }

    public Object getDisplayLock() {
        return displayLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRepaint(Animation cmp) {
        Object object = displayLock;
        synchronized (object) {
            for (int iter = 0; iter < this.paintQueueFill; ++iter) {
                if (this.paintQueue[iter] != cmp) continue;
                this.paintQueue[iter] = null;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(Animation cmp) {
        Object object = displayLock;
        synchronized (object) {
            for (int iter = 0; iter < this.paintQueueFill; ++iter) {
                Animation ani = this.paintQueue[iter];
                if (ani == cmp) {
                    return;
                }
                if (!(ani instanceof Container) || !(cmp instanceof Component)) continue;
                for (Container parent = ((Component)cmp).getParent(); parent != null; parent = parent.getParent()) {
                    if (parent != ani) continue;
                    return;
                }
            }
            if (this.paintQueueFill >= this.paintQueue.length) {
                System.out.println("Warning paint queue size exceeded, please watch the amount of repaint calls");
                return;
            }
            this.paintQueue[this.paintQueueFill] = cmp;
            ++this.paintQueueFill;
            displayLock.notify();
        }
    }

    public abstract void getRGB(Object var1, int[] var2, int var3, int var4, int var5, int var6, int var7);

    public abstract Object createImage(int[] var1, int var2, int var3);

    public abstract Object createImage(String var1) throws IOException;

    public abstract Object createImage(InputStream var1) throws IOException;

    public abstract Object createMutableImage(int var1, int var2, int var3);

    public boolean isAlphaMutableImageSupported() {
        return false;
    }

    public abstract Object createImage(byte[] var1, int var2, int var3);

    public abstract int getImageWidth(Object var1);

    public abstract int getImageHeight(Object var1);

    public abstract Object scale(Object var1, int var2, int var3);

    private static int round(double d) {
        double f = Math.floor(d);
        double c = Math.ceil(d);
        if (c - d < d - f) {
            return (int)c;
        }
        return (int)f;
    }

    public Object rotate(Object image, int degrees) {
        int width = this.getImageWidth(image);
        int height = this.getImageHeight(image);
        int[] arr = new int[width * height];
        int[] dest = new int[arr.length];
        this.getRGB(image, arr, 0, 0, 0, width, height);
        int centerX = width / 2;
        int centerY = height / 2;
        double radians = Math.toRadians(-degrees);
        double cosDeg = Math.cos(radians);
        double sinDeg = Math.sin(radians);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int destOffset;
                int x2 = CodenameOneImplementation.round(cosDeg * (double)(x - centerX) - sinDeg * (double)(y - centerY) + (double)centerX);
                int y2 = CodenameOneImplementation.round(sinDeg * (double)(x - centerX) + cosDeg * (double)(y - centerY) + (double)centerY);
                if (x2 < 0 || y2 < 0 || x2 >= width || y2 >= height || (destOffset = x2 + y2 * width) < 0 || destOffset >= dest.length) continue;
                dest[x + y * width] = arr[destOffset];
            }
        }
        return this.createImage(dest, width, height);
    }

    public Image rotate90Degrees(Image image, boolean maintainOpacity) {
        int[] rgb = image.getRGB();
        int[] newRGB = new int[rgb.length];
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int destX = height - y - 1;
                newRGB[destX + x * height] = rgb[x + y * width];
            }
        }
        return EncodedImage.createFromRGB(newRGB, height, width, !maintainOpacity);
    }

    public Image rotate180Degrees(Image image, boolean maintainOpacity) {
        int[] rgb = image.getRGB();
        int[] newRGB = new int[rgb.length];
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int destX = width - x - 1;
                newRGB[destX + (height - y - 1) * width] = rgb[x + y * width];
            }
        }
        return EncodedImage.createFromRGB(newRGB, width, height, !maintainOpacity);
    }

    public Image rotate270Degrees(Image image, boolean maintainOpacity) {
        int[] rgb = image.getRGB();
        int[] newRGB = new int[rgb.length];
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                newRGB[y + x * height] = rgb[x + y * width];
            }
        }
        return EncodedImage.createFromRGB(newRGB, height, width, !maintainOpacity);
    }

    public Image flipImageHorizontally(Image image, boolean maintainOpacity) {
        int[] rgb = image.getRGB();
        int[] newRGB = new int[rgb.length];
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                newRGB[width - x - 1 + y * width] = rgb[x + y * width];
            }
        }
        return EncodedImage.createFromRGB(newRGB, width, height, !maintainOpacity);
    }

    public Image flipImageVertically(Image image, boolean maintainOpacity) {
        int[] rgb = image.getRGB();
        int[] newRGB = new int[rgb.length];
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                newRGB[x + (height - y - 1) * width] = rgb[x + y * width];
            }
        }
        return EncodedImage.createFromRGB(newRGB, width, height, !maintainOpacity);
    }

    public boolean supportsNativeImageCache() {
        return false;
    }

    public void downloadImageToCache(String url, SuccessCallback<Image> onSuccess, FailureCallback<Image> onFail) {
        FileSystemStorage fs = FileSystemStorage.getInstance();
        if (fs.hasCachesDir()) {
            String name = "cn1_image_cache[" + url + "]";
            name = StringUtil.replaceAll(name, "/", "_");
            name = StringUtil.replaceAll(name, "\\", "_");
            name = StringUtil.replaceAll(name, "%", "_");
            name = StringUtil.replaceAll(name, "?", "_");
            name = StringUtil.replaceAll(name, "*", "_");
            name = StringUtil.replaceAll(name, ":", "_");
            name = StringUtil.replaceAll(name, "=", "_");
            String filePath = fs.getCachesDir() + fs.getFileSystemSeparator() + name;
            Util.downloadImageToFileSystem(url, filePath, onSuccess, onFail);
        } else {
            Util.downloadImageToStorage(url, "cn1_image_cache[" + url + "]", onSuccess, onFail);
        }
    }

    public void downloadImageToStorage(String url, String fileName, SuccessCallback<Image> onSuccess, FailureCallback<Image> onFail) {
        ConnectionRequest cr = new ConnectionRequest();
        cr.setPost(false);
        cr.setFailSilently(true);
        cr.setReadResponseForErrors(false);
        cr.setDuplicateSupported(true);
        cr.setUrl(url);
        cr.downloadImageToStorage(fileName, onSuccess, onFail);
    }

    public void downloadImageToFileSystem(String url, String fileName, SuccessCallback<Image> onSuccess, FailureCallback<Image> onFail) {
        ConnectionRequest cr = new ConnectionRequest();
        cr.setPost(false);
        cr.setFailSilently(true);
        cr.setReadResponseForErrors(false);
        cr.setDuplicateSupported(true);
        cr.setUrl(url);
        cr.downloadImageToFileSystem(fileName, onSuccess, onFail);
    }

    public abstract int getSoftkeyCount();

    public abstract int[] getSoftkeyCode(int var1);

    public abstract int getClearKeyCode();

    public abstract int getBackspaceKeyCode();

    public abstract int getBackKeyCode();

    public abstract int getGameAction(int var1);

    public abstract int getKeyCode(int var1);

    public abstract boolean isTouchDevice();

    public void onShow(Form f) {
        if (onCurrentFormChange != null) {
            onCurrentFormChange.run();
        }
    }

    public void setCurrentForm(Form f) {
        this.currentForm = f;
    }

    public void confirmControlView() {
    }

    public Form getCurrentForm() {
        return this.currentForm;
    }

    public boolean isTranslationSupported() {
        return false;
    }

    public void translate(Object graphics, int x, int y) {
    }

    public int getTranslateX(Object graphics) {
        return 0;
    }

    public int getTranslateY(Object graphics) {
        return 0;
    }

    public abstract int getColor(Object var1);

    public abstract void setColor(Object var1, int var2);

    public abstract void setAlpha(Object var1, int var2);

    public final int concatenateAlpha(Object graphics, int alpha) {
        if (alpha == 255) {
            return this.getAlpha(graphics);
        }
        int oldAlpha = this.getAlpha(graphics);
        this.setAlpha(graphics, (int)((float)oldAlpha * ((float)alpha / 255.0f)));
        return oldAlpha;
    }

    public abstract int getAlpha(Object var1);

    public boolean isAlphaGlobal() {
        return false;
    }

    public boolean isAntiAliasingSupported() {
        return false;
    }

    public boolean isAntiAliasingSupported(Object graphics) {
        return this.isAntiAliasingSupported();
    }

    public boolean isAntiAliasedTextSupported() {
        return false;
    }

    public boolean isAntiAliasedTextSupported(Object graphics) {
        return this.isAntiAliasedTextSupported();
    }

    public void setAntiAliased(Object graphics, boolean a) {
    }

    public boolean isAntiAliased(Object graphics) {
        return false;
    }

    public void setAntiAliasedText(Object graphics, boolean a) {
    }

    public boolean isAntiAliasedText(Object graphics) {
        return false;
    }

    public abstract void setNativeFont(Object var1, Object var2);

    public Rectangle getClipRect(Object graphics) {
        return new Rectangle(this.getClipX(graphics), this.getClipY(graphics), new Dimension(this.getClipWidth(graphics), this.getClipHeight(graphics)));
    }

    public abstract int getClipX(Object var1);

    public abstract int getClipY(Object var1);

    public abstract int getClipWidth(Object var1);

    public abstract int getClipHeight(Object var1);

    public void setClipRect(Object graphics, Rectangle rect) {
        Dimension d = rect.getSize();
        this.setClip(graphics, rect.getX(), rect.getY(), d.getWidth(), d.getHeight());
    }

    public abstract void setClip(Object var1, int var2, int var3, int var4, int var5);

    public void setClip(Object graphics, Shape shape) {
        System.out.println("Shape clip is not supported");
    }

    public void clipRect(Object graphics, Rectangle rect) {
        Dimension d = rect.getSize();
        this.clipRect(graphics, rect.getX(), rect.getY(), d.getWidth(), d.getHeight());
    }

    public abstract void clipRect(Object var1, int var2, int var3, int var4, int var5);

    public void pushClip(Object graphics) {
    }

    public void disposeGraphics(Object graphics) {
    }

    public void popClip(Object graphics) {
    }

    public abstract void drawLine(Object var1, int var2, int var3, int var4, int var5);

    public abstract void fillRect(Object var1, int var2, int var3, int var4, int var5);

    public void clearRect(Object graphics, int x, int y, int width, int height) {
        System.out.println("clearRect() not implemented on this platform");
    }

    public abstract void drawRect(Object var1, int var2, int var3, int var4, int var5);

    public void drawRect(Object graphics, int x, int y, int width, int height, int thickness) {
        --width;
        --height;
        for (int iter = 0; iter < thickness; ++iter) {
            this.drawRect(graphics, x + iter, y + iter, width, height);
            width -= 2;
            height -= 2;
        }
    }

    public abstract void drawRoundRect(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void fillRoundRect(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void fillArc(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void drawArc(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void drawString(Object var1, String var2, int var3, int var4);

    public abstract void drawImage(Object var1, Object var2, int var3, int var4);

    public void drawImage(Object graphics, Object img, int x, int y, int w, int h) {
    }

    public Image createImage(Shape shape, Stroke stroke, int color) {
        return null;
    }

    public void drawShape(Object graphics, Shape shape, Stroke stroke) {
    }

    public void fillShape(Object graphics, Shape shape) {
    }

    public void drawShadow(Object graphics, Object image, int x, int y, int offsetX, int offsetY, int blurRadius, int spreadRadius, int color, float opacity) {
    }

    public boolean isDrawShadowSupported() {
        return false;
    }

    public boolean isDrawShadowFast() {
        return false;
    }

    public void setTransform(Object graphics, Transform transform) {
    }

    public Transform getTransform(Object graphics) {
        return Transform.makeIdentity();
    }

    public boolean isTransformSupported(Object graphics) {
        return false;
    }

    public boolean isPerspectiveTransformSupported(Object graphics) {
        return false;
    }

    public boolean isShapeSupported(Object graphics) {
        return false;
    }

    public boolean isShapeClipSupported(Object graphics) {
        return false;
    }

    public void tileImage(Object graphics, Object img, int x, int y, int w, int h) {
        int iW = this.getImageWidth(img);
        int iH = this.getImageHeight(img);
        int clipX = this.getClipX(graphics);
        int clipW = this.getClipWidth(graphics);
        int clipY = this.getClipY(graphics);
        int clipH = this.getClipHeight(graphics);
        this.clipRect(graphics, x, y, w, h);
        for (int xPos = 0; xPos <= w; xPos += iW) {
            for (int yPos = 0; yPos < h; yPos += iH) {
                int actualX = xPos + x;
                int actualY = yPos + y;
                if (actualX > clipX + clipW || actualX + iW < clipX || actualY > clipY + clipH || actualY + iH < clipY) continue;
                this.drawImage(graphics, img, actualX, actualY);
            }
        }
        this.setClip(graphics, clipX, clipY, clipW, clipH);
    }

    public boolean isNativeVideoPlayerControlsIncluded() {
        return false;
    }

    public boolean isScaledImageDrawingSupported() {
        return false;
    }

    public void drawImageArea(Object nativeGraphics, Object img, int x, int y, int imageX, int imageY, int imageWidth, int imageHeight) {
        int clipX = this.getClipX(nativeGraphics);
        int clipY = this.getClipY(nativeGraphics);
        int clipWidth = this.getClipWidth(nativeGraphics);
        int clipHeight = this.getClipHeight(nativeGraphics);
        this.clipRect(nativeGraphics, x, y, imageWidth, imageHeight);
        if (this.getClipWidth(nativeGraphics) > 0 && this.getClipHeight(nativeGraphics) > 0) {
            this.drawImage(nativeGraphics, img, x - imageX, y - imageY);
        }
        this.setClip(nativeGraphics, clipX, clipY, clipWidth, clipHeight);
    }

    public void drawImageRotated(Object graphics, Object img, int x, int y, int degrees) {
    }

    public boolean isRotationDrawingSupported() {
        return false;
    }

    public void fillTriangle(Object graphics, int x1, int y1, int x2, int y2, int x3, int y3) {
        this.fillPolygon(graphics, new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
    }

    public abstract void drawRGB(Object var1, int[] var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public abstract Object getNativeGraphics();

    public abstract Object getNativeGraphics(Object var1);

    public abstract int charsWidth(Object var1, char[] var2, int var3, int var4);

    public int getFontAscent(Object nativeFont) {
        return (int)((double)this.getHeight(nativeFont) * 0.7);
    }

    public int getFontDescent(Object nativeFont) {
        return this.getHeight(nativeFont) - this.getFontAscent(nativeFont);
    }

    public boolean isBaselineTextSupported() {
        return false;
    }

    public abstract int stringWidth(Object var1, String var2);

    public abstract int charWidth(Object var1, char var2);

    public abstract int getHeight(Object var1);

    public abstract Object getDefaultFont();

    public int getFace(Object nativeFont) {
        return 0;
    }

    public int getSize(Object nativeFont) {
        return 0;
    }

    public int getStyle(Object nativeFont) {
        return 0;
    }

    public abstract Object createFont(int var1, int var2, int var3);

    protected void keyPressed(int keyCode) {
        Display.getInstance().keyPressed(keyCode);
    }

    protected void keyReleased(int keyCode) {
        Display.getInstance().keyReleased(keyCode);
    }

    public boolean isRightMouseButtonDown() {
        return false;
    }

    public boolean isAltKeyDown() {
        return false;
    }

    public boolean isShiftKeyDown() {
        return false;
    }

    public boolean isAltGraphKeyDown() {
        return false;
    }

    public boolean isControlKeyDown() {
        return false;
    }

    public boolean isMetaKeyDown() {
        return false;
    }

    protected void pointerDragged(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.pointerDragged(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerPressed(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.pointerPressed(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerReleased(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.pointerReleased(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerHover(int[] x, int[] y) {
        Display.getInstance().pointerHover(x, y);
    }

    protected void pointerHoverReleased(int[] x, int[] y) {
        Display.getInstance().pointerHoverReleased(x, y);
    }

    protected void pointerHoverReleased(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.pointerHoverReleased(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerHoverPressed(int[] x, int[] y) {
        Display.getInstance().pointerHoverPressed(x, y);
    }

    protected void pointerHoverPressed(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.pointerHoverPressed(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerHover(int x, int y) {
        this.xPointerEvent[0] = x;
        this.yPointerEvent[0] = y;
        this.pointerHover(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerDragged(int[] x, int[] y) {
        boolean hasDragStartedXY = false;
        if (!this.dragStarted) {
            try {
                hasDragStartedXY = this.hasDragStarted(x, y);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.dragStarted || hasDragStartedXY) {
            this.dragStarted = true;
            Display.getInstance().pointerDragged(x, y);
        }
    }

    protected boolean hasDragStarted(int[] x, int[] y) {
        return this.hasDragStarted(x[0], y[0]);
    }

    protected boolean hasDragStarted(int x, int y) {
        float startX;
        if (this.getCurrentForm() == null) {
            return false;
        }
        if (this.dragActivationCounter == 0) {
            this.dragActivationX = x;
            this.dragActivationY = y;
            ++this.dragActivationCounter;
            return false;
        }
        int dragRegion = this.getCurrentForm().getDragRegionStatus(x, y);
        ++this.dragActivationCounter;
        float startY = startX = (float)this.getDragStartPercentage();
        switch (dragRegion) {
            case 1: {
                if (this.dragActivationCounter > this.getDragAutoActivationThreshold()) {
                    return true;
                }
                startY = startX = Math.max(5.0f, startX);
                break;
            }
            case 21: {
                startY = Math.max(5.0f, startY);
                startX = 0.9f;
                break;
            }
            case 22: {
                startX = Math.max(5.0f, startX);
                startY = 0.9f;
                break;
            }
            case 23: {
                startX = 0.9f;
                startY = 0.9f;
                break;
            }
            case 31: {
                startX = 0.0f;
                startY = Math.max(5.0f, startY);
                break;
            }
            case 32: {
                startY = 0.0f;
                startX = Math.max(5.0f, startX);
                break;
            }
            case 33: {
                startX = 0.0f;
                startY = 0.0f;
                break;
            }
            case 10: {
                startY = Math.max(5.0f, startY);
                startX = Math.min(startY, 2.0f);
                break;
            }
            case 11: {
                startX = Math.max(5.0f, startX);
                startY = Math.min(startY, 2.0f);
                break;
            }
            case 12: {
                startX = Math.min(startX, 2.0f);
                startY = Math.min(startY, 2.0f);
            }
        }
        if ((float)this.getDisplayWidth() / 100.0f * startX <= (float)Math.abs(this.dragActivationX - x)) {
            this.dragActivationCounter = this.getDragAutoActivationThreshold() + 1;
            return true;
        }
        if ((float)this.getDisplayHeight() / 100.0f * startY <= (float)Math.abs(this.dragActivationY - y)) {
            this.dragActivationCounter = this.getDragAutoActivationThreshold() + 1;
            return true;
        }
        return false;
    }

    public int getDragStartPercentage() {
        return this.dragStartPercentage;
    }

    public void setDragStartPercentage(int dragStartPercentage) {
        this.dragStartPercentage = dragStartPercentage;
    }

    protected int getDragAutoActivationThreshold() {
        return 7;
    }

    protected void pointerPressed(int[] x, int[] y) {
        this.pointerPressedX = x[0];
        this.pointerPressedY = y[0];
        Display.getInstance().pointerPressed(x, y);
    }

    protected void pointerReleased(int[] x, int[] y) {
        if (this.dragActivationCounter == 0 && x[0] != this.pointerPressedX && y[0] != this.pointerPressedY) {
            this.hasDragStarted(this.pointerPressedX, this.pointerPressedY);
            if (this.hasDragStarted(x, y)) {
                this.pointerDragged(this.pointerPressedX, this.pointerPressedY);
                this.pointerDragged(x, y);
            }
        }
        this.dragStarted = false;
        this.dragActivationCounter = 0;
        Display.getInstance().pointerReleased(x, y);
    }

    protected void sizeChanged(int w, int h) {
        Display.getInstance().sizeChanged(w, h);
    }

    protected void hideNotify() {
        Display.getInstance().hideNotify();
    }

    protected void showNotify() {
        Display.getInstance().showNotify();
    }

    private Object findCachedGradient(Hashtable cache, int startColor, int endColor, int x, int y, int width, int height, boolean horizontal, int centerX, int centerY, int size) {
        if (cache != null) {
            Enumeration e = cache.keys();
            while (e.hasMoreElements()) {
                int[] current = (int[])e.nextElement();
                Object currentRef = cache.get(current);
                if (currentRef == null) {
                    cache.remove(current);
                    e = cache.keys();
                    continue;
                }
                Object currentImage = this.extractHardRef(currentRef);
                if (currentImage == null) {
                    cache.remove(current);
                    e = cache.keys();
                    continue;
                }
                if (current[0] != startColor || current[1] != endColor || current[2] != x || current[3] != y || current[5] != centerX || current[6] != centerY || current[7] != size || this.getImageWidth(currentImage) != width || this.getImageHeight(currentImage) != height || (!horizontal || current[4] != 1) && (horizontal || current[4] != 0)) continue;
                return currentImage;
            }
        }
        return null;
    }

    private void storeCachedGradient(Object img, Hashtable cache, int startColor, int endColor, int x, int y, boolean horizontal, int centerX, int centerY, int size) {
        int[] key = horizontal ? new int[]{startColor, endColor, x, y, 1, centerX, centerY, size} : new int[]{startColor, endColor, x, y, 0, centerX, centerY, size};
        cache.put(key, this.createSoftWeakRef(img));
    }

    public void fillRectRadialGradient(Object graphics, int startColor, int endColor, int x, int y, int width, int height, float relativeX, float relativeY, float relativeSize) {
        int centerX = (int)((float)width * (1.0f - relativeX));
        int centerY = (int)((float)height * (1.0f - relativeY));
        int size = (int)((float)Math.min(width, height) * relativeSize);
        int x2 = (int)((float)(width / 2) - (float)size * relativeX);
        int y2 = (int)((float)(height / 2) - (float)size * relativeY);
        boolean aa = this.isAntiAliased(graphics);
        this.setAntiAliased(graphics, false);
        if (this.cacheRadialGradients()) {
            Object r = this.findCachedGradient(this.radialGradientCache, startColor, endColor, x, y, width, height, true, centerX, centerY, size);
            if (r != null) {
                this.drawImage(graphics, r, x, y);
            } else {
                r = this.createMutableImage(width, height, -1);
                Object imageGraphics = this.getNativeGraphics(r);
                this.setColor(imageGraphics, endColor);
                this.fillRect(imageGraphics, 0, 0, width, height);
                this.fillRadialGradientImpl(imageGraphics, startColor, endColor, x2, y2, size, size, 0, 360);
                this.drawImage(graphics, r, x, y);
                if (this.radialGradientCache == null) {
                    this.radialGradientCache = new Hashtable();
                }
                this.storeCachedGradient(r, this.radialGradientCache, startColor, endColor, x, y, true, centerX, centerY, size);
            }
        } else {
            this.setColor(graphics, endColor);
            this.fillRect(graphics, x, y, width, height);
            this.fillRadialGradientImpl(graphics, startColor, endColor, x + x2, y + y2, size, size, 0, 360);
        }
        if (aa) {
            this.setAntiAliased(graphics, true);
        }
    }

    public void fillRadialGradient(Object graphics, int startColor, int endColor, int x, int y, int width, int height) {
        this.fillRadialGradientImpl(graphics, startColor, endColor, x, y, width, height, 0, 360);
    }

    public void fillRadialGradient(Object graphics, int startColor, int endColor, int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fillRadialGradientImpl(graphics, startColor, endColor, x, y, width, height, startAngle, arcAngle);
    }

    private void fillRadialGradientImpl(Object graphics, int startColor, int endColor, int x, int y, int width, int height, int startAngle, int arcAngle) {
        boolean aa = this.isAntiAliased(graphics);
        this.setAntiAliased(graphics, false);
        int sourceR = startColor >> 16 & 0xFF;
        int sourceG = startColor >> 8 & 0xFF;
        int sourceB = startColor & 0xFF;
        int destR = endColor >> 16 & 0xFF;
        int destG = endColor >> 8 & 0xFF;
        int destB = endColor & 0xFF;
        int oldColor = this.getColor(graphics);
        int originalHeight = height;
        boolean outermost = true;
        while (width > 0 && height > 0) {
            if (outermost) {
                this.setAntiAliased(graphics, true);
            }
            this.updateGradientColor(graphics, sourceR, sourceG, sourceB, destR, destG, destB, originalHeight, height);
            this.fillArc(graphics, x, y, width, height, startAngle, arcAngle);
            ++x;
            ++y;
            width -= 2;
            height -= 2;
            if (!outermost) continue;
            outermost = false;
            this.setAntiAliased(graphics, false);
        }
        this.setColor(graphics, oldColor);
        if (aa) {
            this.setAntiAliased(graphics, true);
        }
    }

    private void updateGradientColor(Object nativeGraphics, int sourceR, int sourceG, int sourceB, int destR, int destG, int destB, int distance, int offset) {
        int r = this.calculateGraidentChannel(sourceR, destR, distance, offset);
        int g = this.calculateGraidentChannel(sourceG, destG, distance, offset);
        int b = this.calculateGraidentChannel(sourceB, destB, distance, offset);
        int color = r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
        this.setColor(nativeGraphics, color);
    }

    private int calculateGraidentChannel(int sourceChannel, int destChannel, int distance, int offset) {
        if (sourceChannel == destChannel) {
            return sourceChannel;
        }
        float ratio = (float)offset / (float)distance;
        int pos = (int)((float)Math.abs(sourceChannel - destChannel) * ratio);
        if (sourceChannel > destChannel) {
            return sourceChannel - pos;
        }
        return sourceChannel + pos;
    }

    public void fillLinearGradient(Object graphics, int startColor, int endColor, int x, int y, int width, int height, boolean horizontal) {
        if (width <= 0 || height <= 0) {
            return;
        }
        boolean aa = this.isAntiAliased(graphics);
        this.setAntiAliased(graphics, false);
        if (this.cacheLinearGradients()) {
            Object r = this.findCachedGradient(this.linearGradientCache, startColor, endColor, x, y, width, height, horizontal, 0, 0, 0);
            if (r != null) {
                this.drawImage(graphics, r, x, y);
            } else {
                r = this.createMutableImage(width, height, -1);
                this.fillLinearGradientImpl(this.getNativeGraphics(r), startColor, endColor, 0, 0, width, height, horizontal);
                this.drawImage(graphics, r, x, y);
                if (this.linearGradientCache == null) {
                    this.linearGradientCache = new Hashtable();
                }
                this.storeCachedGradient(r, this.linearGradientCache, startColor, endColor, x, y, horizontal, 0, 0, 0);
            }
        } else {
            this.fillLinearGradientImpl(graphics, startColor, endColor, x, y, width, height, horizontal);
        }
        if (aa) {
            this.setAntiAliased(graphics, true);
        }
    }

    private void fillLinearGradientImpl(Object graphics, int startColor, int endColor, int x, int y, int width, int height, boolean horizontal) {
        int sourceR = startColor >> 16 & 0xFF;
        int sourceG = startColor >> 8 & 0xFF;
        int sourceB = startColor & 0xFF;
        int destR = endColor >> 16 & 0xFF;
        int destG = endColor >> 8 & 0xFF;
        int destB = endColor & 0xFF;
        int oldColor = this.getColor(graphics);
        if (horizontal) {
            for (int iter = 0; iter < width; ++iter) {
                this.updateGradientColor(graphics, sourceR, sourceG, sourceB, destR, destG, destB, width, iter);
                this.drawLine(graphics, x + iter, y, x + iter, y + height);
            }
        } else {
            for (int iter = 0; iter < height; ++iter) {
                this.updateGradientColor(graphics, sourceR, sourceG, sourceB, destR, destG, destB, height, iter);
                this.drawLine(graphics, x, y + iter, x + width, y + iter);
            }
        }
        this.setColor(graphics, oldColor);
    }

    private boolean checkIntersection(Object g, int y0, int x1, int x2, int y1, int y2, int[] intersections, int intersectionsCount) {
        if (y0 > y1 && y0 < y2 || y0 > y2 && y0 < y1) {
            if (y1 == y2) {
                this.drawLine(g, x1, y0, x2, y0);
                return false;
            }
            intersections[intersectionsCount] = x1 + (y0 - y1) * (x2 - x1) / (y2 - y1);
            return true;
        }
        return false;
    }

    private int markIntersectionEdge(Object g, int idx, int[] yPoints, int[] xPoints, int nPoints, int[] intersections, int intersectionsCount) {
        intersections[intersectionsCount] = xPoints[idx];
        if ((yPoints[idx] - yPoints[(idx + 1) % nPoints]) * (yPoints[idx] - yPoints[(idx + nPoints - 1) % nPoints]) > 0) {
            intersections[intersectionsCount + 1] = xPoints[idx];
            return 2;
        }
        if (yPoints[idx] == yPoints[(idx + 1) % nPoints]) {
            this.drawLine(g, xPoints[idx], yPoints[idx], xPoints[(idx + 1) % nPoints], yPoints[(idx + 1) % nPoints]);
            if ((yPoints[(idx + 1) % nPoints] - yPoints[(idx + 2) % nPoints]) * (yPoints[idx] - yPoints[(idx + nPoints - 1) % nPoints]) > 0) {
                return 1;
            }
            intersections[intersectionsCount + 1] = xPoints[idx];
            return 2;
        }
        return 1;
    }

    public void fillPolygon(Object graphics, int[] xPoints, int[] yPoints, int nPoints) {
        int[] intersections = new int[nPoints];
        int intersectionsCount = 0;
        int yMax = yPoints[0];
        int yMin = yPoints[0];
        for (int i = 0; i < nPoints; ++i) {
            yMax = Math.max(yMax, yPoints[i]);
            yMin = Math.min(yMin, yPoints[i]);
        }
        for (int row = yMin; row <= yMax; ++row) {
            int i;
            intersectionsCount = 0;
            for (int i2 = 1; i2 < nPoints; ++i2) {
                if (!this.checkIntersection(graphics, row, xPoints[i2 - 1], xPoints[i2], yPoints[i2 - 1], yPoints[i2], intersections, intersectionsCount)) continue;
                ++intersectionsCount;
            }
            if (this.checkIntersection(graphics, row, xPoints[nPoints - 1], xPoints[0], yPoints[nPoints - 1], yPoints[0], intersections, intersectionsCount)) {
                ++intersectionsCount;
            }
            for (int j = 0; j < nPoints; ++j) {
                if (row != yPoints[j]) continue;
                intersectionsCount += this.markIntersectionEdge(graphics, j, yPoints, xPoints, nPoints, intersections, intersectionsCount);
            }
            int swap = 0;
            for (i = 0; i < intersectionsCount; ++i) {
                for (int j = i; j < intersectionsCount; ++j) {
                    if (intersections[j] >= intersections[i]) continue;
                    swap = intersections[i];
                    intersections[i] = intersections[j];
                    intersections[j] = swap;
                }
            }
            for (i = 1; i < intersectionsCount; i += 2) {
                this.drawLine(graphics, intersections[i - 1], row, intersections[i], row);
            }
        }
    }

    public void drawPolygon(Object graphics, int[] xPoints, int[] yPoints, int nPoints) {
        for (int i = 1; i < nPoints; ++i) {
            this.drawLine(graphics, xPoints[i - 1], yPoints[i - 1], xPoints[i], yPoints[i]);
        }
        this.drawLine(graphics, xPoints[nPoints - 1], yPoints[nPoints - 1], xPoints[0], yPoints[0]);
    }

    public int getKeyboardType() {
        return 0;
    }

    public boolean isNativeInputSupported() {
        return false;
    }

    public boolean isNativeInputImmediate() {
        return false;
    }

    public boolean isMultiTouch() {
        return false;
    }

    public boolean isClickTouchScreen() {
        return false;
    }

    public boolean isNativeIndexed() {
        return false;
    }

    public Object createNativeIndexed(Image image) {
        return null;
    }

    public boolean isOpaque(Image codenameOneImage, Object nativeImage) {
        int[] rgb = codenameOneImage.getRGBCached();
        int rlen = rgb.length;
        for (int iter = 0; iter < rlen; ++iter) {
            if ((rgb[iter] & 0xFF000000) == -16777216) continue;
            return false;
        }
        return true;
    }

    public boolean isAffineSupported() {
        return false;
    }

    public void resetAffine(Object nativeGraphics) {
        System.out.println("Affine unsupported");
    }

    public void scale(Object nativeGraphics, float x, float y) {
        System.out.println("Affine unsupported");
    }

    public void rotate(Object nativeGraphics, float angle) {
        this.rotate(nativeGraphics, angle, 0, 0);
    }

    public void rotate(Object nativeGraphics, float angle, int pivotX, int pivotY) {
        System.out.println("Affine unsupported");
    }

    public void shear(Object nativeGraphics, float x, float y) {
        System.out.println("Affine unsupported");
    }

    public boolean isSVGSupported() {
        return false;
    }

    public Object createSVGImage(String baseURL, byte[] data) throws IOException {
        throw new IOException("SVG is not supported by this implementation");
    }

    public Object getSVGDocument(Object svgImage) {
        throw new RuntimeException("SVG is not supported by this implementation");
    }

    public boolean animateImage(Object nativeImage, long lastFrame) {
        return false;
    }

    public String[] getFontPlatformNames() {
        return new String[]{"MIDP", "MIDP2"};
    }

    public Object loadTrueTypeFont(String fontName, String fileName) {
        return null;
    }

    public boolean isNativeFontSchemeSupported() {
        return false;
    }

    public Object deriveTrueTypeFont(Object font, float size, int weight) {
        throw new RuntimeException("Unsupported operation");
    }

    public boolean isTrueTypeSupported() {
        return false;
    }

    public Object loadNativeFont(String lookup) {
        return null;
    }

    public boolean isLookupFontSupported() {
        return false;
    }

    public boolean minimizeApplication() {
        return false;
    }

    public void restoreMinimizedApplication() {
    }

    public boolean isMinimized() {
        return false;
    }

    protected boolean cacheRadialGradients() {
        return true;
    }

    protected boolean cacheLinearGradients() {
        return true;
    }

    public boolean isThirdSoftButton() {
        return false;
    }

    public int getDragPathLength() {
        return 10;
    }

    public int getDragPathTime() {
        return 200;
    }

    public float getDragSpeed(float[] points, long[] dragPathTime, int dragPathOffset, int dragPathLength) {
        long now = System.currentTimeMillis();
        long tooold = now - (long)this.getDragPathTime();
        int offset = dragPathOffset - dragPathLength;
        if (offset < 0) {
            offset = this.getDragPathLength() + offset;
        }
        long old = 0L;
        float oldPoint = 0.0f;
        float speed = 0.0f;
        float f = dragPathLength;
        while (dragPathLength > 0) {
            if (dragPathTime[offset] > tooold) {
                if (old == 0L) {
                    old = dragPathTime[offset];
                    oldPoint = points[offset];
                }
                long timediff = now - old;
                float diff = points[offset] - oldPoint;
                if (timediff > 0L) {
                    float velocity = diff / (float)timediff * 1.5f;
                    speed += velocity;
                }
            }
            --dragPathLength;
            if (++offset < this.getDragPathLength()) continue;
            offset = 0;
        }
        f = Math.max(1.0f, f);
        return -speed / f;
    }

    public boolean isBidiAlgorithm() {
        return bidi;
    }

    public void setBidiAlgorithm(boolean activate) {
        bidi = activate;
    }

    public String convertBidiLogicalToVisual(String s) {
        if (bidi && s.length() >= 2) {
            char[] c = s.toCharArray();
            this.swapBidiChars(c, 0, s.length(), -1);
            return new String(c);
        }
        return s;
    }

    public int getCharLocation(String source, int index) {
        if (bidi) {
            return this.swapBidiChars(source.toCharArray(), 0, source.length(), index);
        }
        return index;
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\n' || c == '\r';
    }

    public boolean isRTLOrWhitespace(char c) {
        if (bidi) {
            return this.isRTL(c) || this.isWhitespace(c);
        }
        return false;
    }

    public boolean isRTL(char c) {
        return c >= '\u0590' && c <= '\u07bf';
    }

    private final int swapBidiChars(char[] chars, int ixStart, int len, int index) {
        int ix1;
        int destIndex = -1;
        int ixEnd = ixStart + len;
        int ix0 = ix1 = ixStart;
        boolean doSwap = false;
        for (int i1 = ixStart; i1 < ixEnd; ++i1) {
            if (!this.isRTL(chars[i1])) continue;
            doSwap = true;
            break;
        }
        if (doSwap) {
            while (ix0 < ixEnd && (ix1 = this.scanSecond(chars, ix0, ixEnd)) >= 0) {
                ix0 = ix1;
                ix1 = this.scanBackFirst(chars, ix0, ixEnd);
                int iy0 = ix0;
                for (int iy1 = ix1 - 1; iy0 < iy1; ++iy0, --iy1) {
                    char tmp = chars[iy0];
                    chars[iy0] = chars[iy1];
                    chars[iy1] = tmp;
                    if (index != iy1) continue;
                    destIndex = iy0;
                    index = iy0;
                }
                ix0 = ix1;
            }
        }
        if (doSwap) {
            ix0 = ixStart;
            for (ix1 = ixEnd - 1; ix0 <= ix1; ++ix0, --ix1) {
                char ch1;
                char ch0 = chars[ix0];
                chars[ix0] = ch1 = chars[ix1];
                chars[ix1] = ch0;
                if (index == ix0) {
                    destIndex = ix1;
                    continue;
                }
                if (index != ix1) continue;
                destIndex = ix0;
            }
        }
        return destIndex;
    }

    private boolean isRTLBreak(char ch1) {
        return ch1 == ')' || ch1 == ']' || ch1 == '}' || ch1 == '(' || ch1 == '[' || ch1 == '{';
    }

    private boolean isLTR(char c) {
        return !this.isRTL(c) && !this.isRTLBreak(c);
    }

    private final int scanSecond(char[] chars, int ixStart, int ixEnd) {
        int ixFound = -1;
        for (int ix = ixStart; ixFound < 0 && ix < ixEnd; ++ix) {
            if (this.isRTLOrWhitespace(chars[ix])) continue;
            ixFound = ix;
        }
        return ixFound;
    }

    private final int scanBackFirst(char[] chars, int ixStart, int ixEnd) {
        int ix;
        int ixFound = ixEnd;
        for (ix = ixStart + 1; ix < ixEnd; ++ix) {
            if (!this.isRTL(chars[ix]) && !this.isRTLBreak(chars[ix])) continue;
            ixFound = ix;
            break;
        }
        for (ix = ixFound - 1; ix >= ixStart; --ix) {
            if (!this.isLTR(chars[ix]) || this.isWhitespace(chars[ix])) continue;
            ixFound = ix + 1;
            break;
        }
        return ixFound;
    }

    public InputStream getResourceAsStream(Class cls, String resource) {
        if (cls != null) {
            return cls.getResourceAsStream(resource);
        }
        return this.getClass().getResourceAsStream(resource);
    }

    public boolean isAnimation(Object nativeImage) {
        return false;
    }

    public PeerComponent createNativePeer(Object nativeComponent) {
        throw new IllegalArgumentException(nativeComponent.getClass().getName());
    }

    public void showNativeScreen(Object nativeFullScreenPeer) {
    }

    public void setNativeCommands(Vector commands) {
    }

    public void exitApplication() {
    }

    public void exit() {
        if (onExit != null) {
            onExit.run();
        }
        this.exitApplication();
    }

    public String getProperty(String key, String defaultValue) {
        return defaultValue;
    }

    public Boolean canExecute(String url) {
        if (url.startsWith("http:") || url.startsWith("https:")) {
            return Boolean.TRUE;
        }
        return null;
    }

    public void execute(String url) {
    }

    public void execute(String url, ActionListener response) {
        this.execute(url);
    }

    public int getDeviceDensity() {
        int d = this.getActualDisplayHeight() * this.getDisplayWidth();
        if (this.isTablet()) {
            if (d >= 1036800) {
                return 40;
            }
            return 30;
        }
        if (d <= 38720) {
            return 10;
        }
        if (d <= 76800) {
            return 20;
        }
        if (d <= 172800) {
            return 30;
        }
        if (d <= 409920) {
            return 40;
        }
        if (d <= 1036800) {
            return 50;
        }
        return 60;
    }

    public Rectangle getDisplaySafeArea(Rectangle rect) {
        if (rect == null) {
            rect = new Rectangle();
        }
        rect.setBounds(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
        return rect;
    }

    public void playBuiltinSound(String soundIdentifier) {
        this.playUserSound(soundIdentifier);
    }

    protected boolean playUserSound(String soundIdentifier) {
        Object sound = this.builtinSounds.get(soundIdentifier);
        return sound != null;
    }

    protected void playNativeBuiltinSound(Object data) {
    }

    protected Object convertBuiltinSound(InputStream i) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int size = i.read(buffer);
        while (size > -1) {
            b.write(buffer, 0, size);
            size = i.read(buffer);
        }
        b.close();
        i.close();
        return b.toByteArray();
    }

    public void installBuiltinSound(String soundIdentifier, InputStream data) throws IOException {
        this.builtinSounds.put(soundIdentifier, this.convertBuiltinSound(data));
    }

    public boolean isBuiltinSoundAvailable(String soundIdentifier) {
        return this.builtinSounds.containsKey(soundIdentifier);
    }

    public void setBuiltinSoundsEnabled(boolean enabled) {
        this.builtinSoundEnabled = enabled;
    }

    public boolean isBuiltinSoundsEnabled() {
        return this.builtinSoundEnabled;
    }

    public Media createMedia(String uri, boolean isVideo, Runnable onCompletion) throws IOException {
        return null;
    }

    public AsyncResource<Media> createMediaAsync(final String uri, final boolean video, final Runnable onCompletion) {
        final AsyncResource<Media> out = new AsyncResource<Media>();
        CN.scheduleBackgroundTask(new Runnable(){

            public void run() {
                try {
                    out.complete(CodenameOneImplementation.this.createMedia(uri, video, onCompletion));
                }
                catch (IOException ex) {
                    out.error(ex);
                }
            }
        });
        return out;
    }

    public void addCompletionHandler(Media media, Runnable onCompletion) {
    }

    public void removeCompletionHandler(Media media, Runnable onCompletion) {
    }

    public Media createMedia(InputStream stream, String mimeType, Runnable onCompletion) throws IOException {
        return null;
    }

    public AsyncResource<Media> createMediaAsync(final InputStream stream, final String mimeType, final Runnable onCompletion) {
        final AsyncResource<Media> out = new AsyncResource<Media>();
        CN.scheduleBackgroundTask(new Runnable(){

            public void run() {
                try {
                    out.complete(CodenameOneImplementation.this.createMedia(stream, mimeType, onCompletion));
                }
                catch (Throwable t) {
                    out.error(t);
                }
            }
        });
        return out;
    }

    public Media createBackgroundMedia(String uri) throws IOException {
        if (uri.startsWith("jar://")) {
            if (!(uri = uri.substring(6)).startsWith("/")) {
                uri = "/" + uri;
            }
            InputStream is = this.getResourceAsStream(this.getClass(), uri);
            String mime = "";
            if (uri.endsWith(".mp3")) {
                mime = "audio/mp3";
            } else if (uri.endsWith(".wav")) {
                mime = "audio/x-wav";
            } else if (uri.endsWith(".amr")) {
                mime = "audio/amr";
            } else if (uri.endsWith(".3gp")) {
                mime = "audio/3gpp";
            }
            return this.createMedia(is, mime, null);
        }
        return this.createMedia(uri, false, null);
    }

    public AsyncResource<Media> createBackgroundMediaAsync(final String uri) {
        if (uri.startsWith("jar://")) {
            final AsyncResource<Media> out = new AsyncResource<Media>();
            CN.scheduleBackgroundTask(new Runnable(){

                public void run() {
                    try {
                        out.complete(CodenameOneImplementation.this.createBackgroundMedia(uri));
                    }
                    catch (IOException ex) {
                        out.error(ex);
                    }
                }
            });
            return out;
        }
        return this.createMediaAsync(uri, false, null);
    }

    public Object createSoftWeakRef(Object o) {
        return new WeakReference<Object>(o);
    }

    public Object extractHardRef(Object o) {
        WeakReference w = (WeakReference)o;
        if (w != null) {
            return w.get();
        }
        return null;
    }

    public void notifyCommandBehavior(int commandBehavior) {
    }

    public boolean hasNativeTheme() {
        return false;
    }

    public void installNativeTheme() {
        throw new RuntimeException();
    }

    public void copyToClipboard(Object obj) {
        this.lightweightClipboard = obj;
    }

    public Object getPasteDataFromClipboard() {
        return this.lightweightClipboard;
    }

    public boolean isPortrait() {
        return this.getDisplayWidth() < this.getActualDisplayHeight();
    }

    public boolean canForceOrientation() {
        return false;
    }

    public void lockOrientation(boolean portrait) {
    }

    public void unlockOrientation() {
    }

    public boolean isNativeBrowserComponentSupported() {
        return false;
    }

    public void setPinchToZoomEnabled(PeerComponent browserPeer, boolean e) {
    }

    public void setNativeBrowserScrollingEnabled(PeerComponent browserPeer, boolean e) {
    }

    public PeerComponent createBrowserComponent(Object browserComponent) {
        return null;
    }

    public boolean postMessage(Object browserComponent, String message, String targetOrigin) {
        return false;
    }

    public boolean installMessageListener(Object browserComponent) {
        return false;
    }

    public boolean uninstallMessageListener(Object browserComponent) {
        return false;
    }

    public Object createNativeOverlay(Component cmp) {
        return null;
    }

    public void hideNativeOverlay(Component cmp, Object nativeOverlay) {
    }

    public void updateNativeOverlay(Component cmp, Object nativeOverlay) {
    }

    public void setBrowserProperty(PeerComponent browserPeer, String key, Object value) {
    }

    public String getBrowserTitle(PeerComponent browserPeer) {
        return null;
    }

    public String getBrowserURL(PeerComponent browserPeer) {
        return null;
    }

    public AsyncResource<Image> captureBrowserScreenshot(PeerComponent browserPeer) {
        return null;
    }

    public void setBrowserPageInHierarchy(PeerComponent browserPeer, String url) throws IOException {
        this.installTar();
        FileSystemStorage fs = FileSystemStorage.getInstance();
        String tardir = fs.getAppHomePath() + "cn1html";
        if (tardir.startsWith("/")) {
            tardir = "file://" + tardir;
        }
        if (url.startsWith("/")) {
            this.setBrowserURL(browserPeer, tardir + url);
        } else {
            this.setBrowserURL(browserPeer, tardir + "/" + url);
        }
    }

    public void setBrowserURL(PeerComponent browserPeer, String url, Map<String, String> headers) {
        throw new RuntimeException();
    }

    public boolean isURLWithCustomHeadersSupported() {
        return false;
    }

    public void setBrowserURL(PeerComponent browserPeer, String url) {
        try {
            InputStream i = Display.getInstance().getResourceAsStream(this.getClass(), url.substring(6));
            if (i == null) {
                System.out.println("Local resource not found: " + url);
                return;
            }
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            int size = i.read(buffer);
            while (size > -1) {
                bo.write(buffer, 0, size);
                size = i.read(buffer);
            }
            i.close();
            bo.close();
            String htmlText = new String(bo.toByteArray(), "UTF-8");
            String baseUrl = url.substring(0, url.lastIndexOf(47));
            this.setBrowserPage(browserPeer, htmlText, baseUrl);
            return;
        }
        catch (IOException ex) {
            Log.e(ex);
            return;
        }
    }

    public void browserReload(PeerComponent browserPeer) {
    }

    public boolean browserHasBack(PeerComponent browserPeer) {
        return false;
    }

    public boolean browserHasForward(PeerComponent browserPeer) {
        return false;
    }

    public void browserBack(PeerComponent browserPeer) {
    }

    public void browserStop(PeerComponent browserPeer) {
    }

    public void browserDestroy(PeerComponent internal) {
    }

    public void browserForward(PeerComponent browserPeer) {
    }

    public void browserClearHistory(PeerComponent browserPeer) {
    }

    public void setBrowserPage(PeerComponent browserPeer, String html, String baseUrl) {
    }

    public void browserExecute(PeerComponent browserPeer, String javaScript) {
        this.setBrowserURL(browserPeer, "javascript:(function(){" + javaScript + "})()");
    }

    public String browserExecuteAndReturnString(PeerComponent internal, String javaScript) {
        this.browserExecute(internal, javaScript);
        return null;
    }

    public boolean supportsBrowserExecuteAndReturnString(PeerComponent internal) {
        return false;
    }

    public void browserExposeInJavaScript(PeerComponent browserPeer, Object o, String name) {
    }

    public int convertToPixels(int dipCount, boolean horizontal) {
        switch (this.getDeviceDensity()) {
            case 10: {
                return dipCount;
            }
            case 20: {
                return dipCount * 2;
            }
            case 30: {
                return dipCount * 5;
            }
            case 40: {
                return dipCount * 10;
            }
            case 50: {
                return dipCount * 14;
            }
            case 60: {
                return dipCount * 20;
            }
        }
        return dipCount;
    }

    public boolean isTablet() {
        return false;
    }

    public boolean isDesktop() {
        return false;
    }

    public boolean canDial() {
        return !this.isTablet() && !this.isDesktop();
    }

    public void setThreadPriority(Thread t, int p) {
        t.setPriority(p);
    }

    public void postInit() {
        this.initDefaultUserAgent();
    }

    protected void initDefaultUserAgent() {
        ConnectionRequest.setDefaultUserAgent(Display.getInstance().getProperty("User-Agent", "Mozilla/5.0 (SymbianOS/9.4; Series60/5.0 NokiaN97-1/20.0.019; Profile/MIDP-2.1 Configuration/CLDC-1.1) AppleWebKit/525 (KHTML, like Gecko) BrowserNG/7.1.18124"));
    }

    public void setImageName(Object nativeImage, String name) {
    }

    public boolean areMutableImagesFast() {
        return true;
    }

    private void purgeOldCookies(Map<String, Cookie> cookies) {
        long now = System.currentTimeMillis();
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, Cookie> e : cookies.entrySet()) {
            if (e.getValue().getExpires() == 0L || e.getValue().getExpires() >= now) continue;
            toRemove.add(e.getKey());
        }
        for (String key : toRemove) {
            cookies.remove(key);
        }
    }

    protected final void removeCookiesForDomain(String domain) {
        if (this.cookies == null || domain == null) {
            return;
        }
        Hashtable h = (Hashtable)this.cookies.get(domain);
        if (h == null) {
            return;
        }
        h.clear();
        if (Cookie.isAutoStored()) {
            if (Storage.getInstance().exists(Cookie.STORAGE_NAME)) {
                Storage.getInstance().deleteStorageFile(Cookie.STORAGE_NAME);
            }
            Storage.getInstance().writeObject(Cookie.STORAGE_NAME, this.cookies);
        }
    }

    public void addCookie(Cookie[] cookiesArray) {
        if (this.cookies == null) {
            this.cookies = new Hashtable();
        }
        for (Cookie cookie : cookiesArray) {
            Hashtable<String, Cookie> h = (Hashtable<String, Cookie>)this.cookies.get(cookie.getDomain());
            if (h == null) {
                h = new Hashtable<String, Cookie>();
                this.cookies.put(cookie.getDomain(), h);
            }
            this.purgeOldCookies((Map<String, Cookie>)h);
            if (cookie.getExpires() != 0L && cookie.getExpires() < System.currentTimeMillis()) {
                h.remove(cookie.getName());
                continue;
            }
            h.put(cookie.getName(), cookie);
        }
        if (Cookie.isAutoStored()) {
            if (Storage.getInstance().exists(Cookie.STORAGE_NAME)) {
                Storage.getInstance().deleteStorageFile(Cookie.STORAGE_NAME);
            }
            Storage.getInstance().writeObject(Cookie.STORAGE_NAME, this.cookies);
        }
    }

    public boolean isNativeCookieSharingSupported() {
        return false;
    }

    public void addCookie(Cookie c) {
        Hashtable<String, Cookie> h;
        if (this.cookies == null) {
            this.cookies = new Hashtable();
        }
        if ((h = (Hashtable<String, Cookie>)this.cookies.get(c.getDomain())) == null) {
            h = new Hashtable<String, Cookie>();
            this.cookies.put(c.getDomain(), h);
        }
        h.put(c.getName(), c);
        if (Cookie.isAutoStored()) {
            if (Storage.getInstance().exists(Cookie.STORAGE_NAME)) {
                Storage.getInstance().deleteStorageFile(Cookie.STORAGE_NAME);
            }
            Storage.getInstance().writeObject(Cookie.STORAGE_NAME, this.cookies);
        }
    }

    public String getURLDomain(String url) {
        String domain = url.substring(url.indexOf("//") + 2);
        int i = domain.indexOf(47);
        if (i > -1) {
            domain = domain.substring(0, i);
        }
        return domain;
    }

    public String getURLPath(String url) {
        String path = url.substring(url.indexOf("//") + 2);
        int i = path.indexOf(47);
        if (i > -1) {
            path = path.substring(i);
        }
        if ((i = path.indexOf(63)) > -1) {
            path = path.substring(0, i);
        }
        if ((i = path.indexOf(35)) > -1) {
            path = path.substring(0, i);
        }
        return path;
    }

    public Vector getCookiesForURL(String url) {
        Vector<Cookie> response = null;
        if (Cookie.isAutoStored()) {
            this.cookies = (Hashtable)Storage.getInstance().readObject(Cookie.STORAGE_NAME);
        }
        String protocol = "";
        int pos = -1;
        pos = url.indexOf(":");
        if (pos >= 0) {
            protocol = url.substring(0, pos);
        }
        boolean isHttp = "http".equals(protocol) || "https".equals(protocol);
        boolean isSecure = "https".equals(protocol);
        String path = this.getURLPath(url);
        if (this.cookies != null && this.cookies.size() > 0) {
            String domain = this.getURLDomain(url);
            Enumeration e = this.cookies.keys();
            while (e.hasMoreElements()) {
                Hashtable h;
                String domainKey = (String)e.nextElement();
                if (domain.indexOf(domainKey) <= -1 || (h = (Hashtable)this.cookies.get(domainKey)) == null) continue;
                Enumeration enumCookies = h.elements();
                if (response == null) {
                    response = new Vector<Cookie>();
                }
                while (enumCookies.hasMoreElements()) {
                    Cookie nex = (Cookie)enumCookies.nextElement();
                    if (nex.isHttpOnly() && !isHttp || nex.isSecure() && !isSecure || path.indexOf(nex.getPath()) != 0) continue;
                    response.addElement(nex);
                }
            }
        }
        return response;
    }

    public void clearNativeCookies() {
    }

    public abstract Object connect(String var1, boolean var2, boolean var3) throws IOException;

    public String[] getSSLCertificates(Object connection, String url) throws IOException {
        return new String[0];
    }

    public boolean canGetSSLCertificates() {
        return false;
    }

    public boolean checkSSLCertificatesRequiresCallbackFromNative() {
        return false;
    }

    public void setConnectionId(Object connection, int id) {
    }

    public void addConnectionToQueue(ConnectionRequest req) {
    }

    public Object connect(String url, boolean read, boolean write, int timeout) throws IOException {
        return this.connect(url, read, write);
    }

    public void setHttpMethod(Object connection, String method) throws IOException {
    }

    public abstract void setHeader(Object var1, String var2, String var3);

    public void setChunkedStreamingMode(Object connection, int bufferLen) {
    }

    public void cleanup(Object o) {
        try {
            if (o != null) {
                if (o instanceof InputStream) {
                    ((InputStream)o).close();
                    return;
                }
                if (o instanceof OutputStream) {
                    ((OutputStream)o).close();
                    return;
                }
                if (o instanceof Reader) {
                    ((Reader)o).close();
                    return;
                }
                if (o instanceof Writer) {
                    ((Writer)o).close();
                }
                if (o instanceof Database) {
                    ((Database)o).close();
                }
                if (o instanceof Cursor) {
                    ((Cursor)o).close();
                }
            }
        }
        catch (Throwable ex) {
            Log.e(ex);
        }
    }

    public boolean isSetCursorSupported() {
        return false;
    }

    public abstract int getContentLength(Object var1);

    public abstract OutputStream openOutputStream(Object var1) throws IOException;

    public abstract OutputStream openOutputStream(Object var1, int var2) throws IOException;

    public abstract InputStream openInputStream(Object var1) throws IOException;

    public OutputStream openFileOutputStream(String file) throws IOException {
        return this.openOutputStream(file);
    }

    public InputStream openFileInputStream(String file) throws IOException {
        return this.openInputStream(file);
    }

    public abstract void setPostRequest(Object var1, boolean var2);

    public abstract int getResponseCode(Object var1) throws IOException;

    public abstract String getResponseMessage(Object var1) throws IOException;

    public abstract String getHeaderField(String var1, Object var2) throws IOException;

    public abstract String[] getHeaderFieldNames(Object var1) throws IOException;

    public abstract String[] getHeaderFields(String var1, Object var2) throws IOException;

    public boolean isTimeoutSupported() {
        return false;
    }

    public void setTimeout(int t) {
    }

    public void flushStorageCache() {
    }

    public void setStorageData(Object storageData) {
        this.storageData = storageData;
    }

    public Object getStorageData() {
        return this.storageData;
    }

    public abstract void deleteStorageFile(String var1);

    public void clearStorage() {
        String[] l = this.listStorageEntries();
        int llen = l.length;
        for (int iter = 0; iter < llen; ++iter) {
            this.deleteStorageFile(l[iter]);
        }
    }

    public abstract OutputStream createStorageOutputStream(String var1) throws IOException;

    public abstract InputStream createStorageInputStream(String var1) throws IOException;

    public abstract boolean storageFileExists(String var1);

    public abstract String[] listStorageEntries();

    public int getStorageEntrySize(String name) {
        long size = -1L;
        try {
            InputStream i = this.createStorageInputStream(name);
            long val = i.skip(1000000L);
            if (val > -1L) {
                size = 0L;
                while (val > -1L) {
                    size += val;
                    val = i.skip(1000000L);
                }
            }
            Util.cleanup(i);
        }
        catch (IOException err) {
            Log.e(err);
        }
        return (int)size;
    }

    public abstract String[] listFilesystemRoots();

    public abstract String[] listFiles(String var1) throws IOException;

    public abstract long getRootSizeBytes(String var1);

    public abstract long getRootAvailableSpace(String var1);

    public abstract void mkdir(String var1);

    public abstract void deleteFile(String var1);

    public abstract boolean isHidden(String var1);

    public abstract void setHidden(String var1, boolean var2);

    public abstract long getFileLength(String var1);

    public long getFileLastModified(String file) {
        return -1L;
    }

    public abstract boolean isDirectory(String var1);

    public abstract boolean exists(String var1);

    public abstract void rename(String var1, String var2);

    public abstract char getFileSystemSeparator();

    public String getLineSeparator() {
        return "\n";
    }

    public boolean isAPSupported() {
        return false;
    }

    public String[] getAPIds() {
        return null;
    }

    public int getAPType(String id) {
        return 1;
    }

    public String getAPName(String id) {
        return null;
    }

    public String getCurrentAccessPoint() {
        return null;
    }

    public void setCurrentAccessPoint(String id) {
    }

    public boolean shouldWriteUTFAsGetBytes() {
        return false;
    }

    public void startThread(String name, Runnable r) {
        new CodenameOneThread(r, name).start();
    }

    public void closingOutput(OutputStream s) {
    }

    public void printStackTraceToStream(Throwable t, Writer o) {
    }

    public void setLogListener(ActionListener al) {
        this.logger = al;
    }

    protected boolean isLogged() {
        return this.logger != null;
    }

    protected void log(String content) {
        this.logger.actionPerformed(new ActionEvent((Object)content, ActionEvent.Type.Log));
    }

    public void systemOut(String content) {
        System.out.println(content);
    }

    public void logStreamCreate(String name, boolean isInput, int count) {
        if (this.isLogged()) {
            if (isInput) {
                this.log("Creating input stream " + name + " total streams: " + count);
            } else {
                this.log("Creating output stream " + name + " total streams: " + count);
            }
        }
    }

    public void logStreamClose(String name, boolean isInput, int count) {
        if (this.isLogged()) {
            if (isInput) {
                this.log("Closing input stream " + name + " remaining streams: " + count);
            } else {
                this.log("Closing output stream " + name + " remaining streams: " + count);
            }
        }
    }

    public void logStreamDoubleClose(String name, boolean isInput) {
        if (this.isLogged()) {
            if (isInput) {
                this.log("Double closing input stream " + name);
            } else {
                this.log("Double closing output stream " + name);
            }
        }
    }

    public int getRootType(String root) {
        root = root.toLowerCase();
        String sdCard = Display.getInstance().getProperty("sdcard", null);
        if (sdCard != null ? root.indexOf(sdCard) > -1 : root.indexOf("file:///f:") > -1 || root.indexOf("file:///e:") > -1 || root.indexOf("memorycard") > -1 || root.indexOf("mmc") > -1 || root.indexOf("sdcard") > -1 || root.indexOf("store") > -1) {
            return 2;
        }
        if (root.indexOf("c:") > -1 || root.indexOf("phone memory") > -1 || root.indexOf("store") > -1) {
            return 1;
        }
        return 3;
    }

    public LocationManager getLocationManager() {
        return null;
    }

    public void releaseImage(Object image) {
    }

    public void capturePhoto(ActionListener response) {
    }

    public Image captureScreen() {
        Form form = this.getCurrentForm();
        if (form != null) {
            return form.toImage();
        }
        return null;
    }

    public void captureAudio(ActionListener response) {
        this.captureAudio(new MediaRecorderBuilder().path(new File("tmpaudio.wav").getAbsolutePath()).mimeType("audio/wav"), response);
    }

    public final BrowserComponent getSharedJavscriptContext() {
        if (this.sharedJavascriptContext == null) {
            this.sharedJavascriptContext = this.createSharedJavascriptContext();
        }
        return this.sharedJavascriptContext;
    }

    protected BrowserComponent createSharedJavascriptContext() {
        BrowserComponent out = new BrowserComponent();
        out.setPage("<!doctype html><html><body></body></html>", null);
        return out;
    }

    public void captureAudio(MediaRecorderBuilder recordingOptions, final ActionListener response) {
        MediaRecorderBuilder builder;
        MediaRecorderBuilder mediaRecorderBuilder = builder = recordingOptions == null ? new MediaRecorderBuilder() : recordingOptions;
        if (!builder.isRedirectToAudioBuffer() && builder.getPath() == null) {
            builder.path(new File("tmpaudio.wav").getAbsolutePath());
        }
        if (!builder.isRedirectToAudioBuffer() && builder.getMimeType() == null) {
            builder.mimeType("audio/wav");
        }
        System.out.println("in captureAudio " + recordingOptions.isRedirectToAudioBuffer());
        final AudioRecorderComponent cmp = new AudioRecorderComponent(builder);
        final Sheet sheet = new Sheet(null, "Record Audio");
        sheet.getContentPane().setLayout(new BorderLayout());
        sheet.getContentPane().add((Object)"Center", cmp);
        cmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                switch (cmp.getState()) {
                    case Accepted: {
                        CN.getCurrentForm().getAnimationManager().flushAnimation(new Runnable(){

                            public void run() {
                                sheet.back();
                                sheet.addCloseListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent evt) {
                                        sheet.removeCloseListener(this);
                                        response.actionPerformed(new ActionEvent(builder.getPath()));
                                    }
                                });
                            }
                        });
                        break;
                    }
                    case Canceled: {
                        FileSystemStorage fs = FileSystemStorage.getInstance();
                        if (fs.exists(builder.getPath())) {
                            FileSystemStorage.getInstance().delete(builder.getPath());
                        }
                        CN.getCurrentForm().getAnimationManager().flushAnimation(new Runnable(){

                            public void run() {
                                sheet.back();
                                sheet.addCloseListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent evt) {
                                        sheet.removeCloseListener(this);
                                        response.actionPerformed(new ActionEvent(null));
                                    }
                                });
                            }
                        });
                    }
                }
            }
        });
        sheet.addCloseListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (cmp.getState() != AudioRecorderComponent.RecorderState.Accepted && cmp.getState() != AudioRecorderComponent.RecorderState.Canceled) {
                    FileSystemStorage fs = FileSystemStorage.getInstance();
                    if (fs.exists(builder.getPath())) {
                        FileSystemStorage.getInstance().delete(builder.getPath());
                    }
                    CN.getCurrentForm().getAnimationManager().flushAnimation(new Runnable(){

                        public void run() {
                            response.actionPerformed(new ActionEvent(null));
                        }
                    });
                }
            }
        });
        sheet.show();
    }

    public void captureVideo(ActionListener response) {
    }

    public void captureVideo(VideoCaptureConstraints constraints, ActionListener response) {
        this.captureVideo(response);
    }

    public boolean isGalleryTypeSupported(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void openGallery(final ActionListener response, int type) {
        if (!this.isGalleryTypeSupported(type)) {
            throw new IllegalArgumentException("Gallery type " + type + " not supported on this platform.");
        }
        final Dialog d = new Dialog("Select a picture");
        d.setLayout(new BorderLayout());
        FileTreeModel model = new FileTreeModel(true);
        if (type == 0) {
            model.addExtensionFilter("jpg");
            model.addExtensionFilter("png");
        } else if (type == 1) {
            model.addExtensionFilter("mp4");
            model.addExtensionFilter("3pg");
            model.addExtensionFilter("avi");
            model.addExtensionFilter("mov");
        } else if (type == 2) {
            model.addExtensionFilter("jpg");
            model.addExtensionFilter("png");
            model.addExtensionFilter("mp4");
            model.addExtensionFilter("3pg");
            model.addExtensionFilter("avi");
            model.addExtensionFilter("mov");
        }
        FileTree t = new FileTree(model){

            protected Button createNodeComponent(final Object node, int depth) {
                if (node == null || !this.getModel().isLeaf(node)) {
                    return super.createNodeComponent(node, depth);
                }
                Hashtable t = (Hashtable)Storage.getInstance().readObject("thumbnails");
                if (t == null) {
                    t = new Hashtable();
                }
                final Hashtable thumbs = t;
                final Button b = super.createNodeComponent(node, depth);
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        response.actionPerformed(new ActionEvent(node, ActionEvent.Type.Other));
                        d.dispose();
                    }
                });
                final ImageIO imageio = ImageIO.getImageIO();
                if (imageio != null) {
                    Display.getInstance().scheduleBackgroundTask(new Runnable(){

                        public void run() {
                            byte[] data = (byte[])thumbs.get(node);
                            if (data == null) {
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                try {
                                    imageio.save(FileSystemStorage.getInstance().openInputStream((String)node), (OutputStream)out, "jpeg", b.getIcon().getWidth(), b.getIcon().getHeight(), 1.0f);
                                    data = out.toByteArray();
                                    thumbs.put(node, data);
                                    Storage.getInstance().writeObject("thumbnails", thumbs);
                                }
                                catch (IOException ex) {
                                    Log.e(ex);
                                }
                            }
                            Image im = Image.createImage(data, 0, data.length);
                            b.setIcon(im);
                        }
                    });
                }
                return b;
            }
        };
        d.addComponent("Center", (Component)t);
        d.placeButtonCommands(new Command[]{new Command("Cancel")});
        Command c = d.showAtPosition(2, 2, 2, 2, true);
        if (c != null) {
            response.actionPerformed(null);
        }
    }

    public void openImageGallery(ActionListener response) {
        this.openGallery(response, 0);
    }

    public abstract String getPlatformName();

    public String[] getPlatformOverrides() {
        return new String[0];
    }

    public boolean shouldAutoDetectAccessPoint() {
        return false;
    }

    public void sendMessage(String[] recipients, String subject, Message msg) {
    }

    public void dial(String phoneNumber) {
    }

    public void sendSMS(String phoneNumber, String message, boolean interactive) throws IOException {
    }

    public int getSMSSupport() {
        return 2;
    }

    public Image getApplicationIconImage() {
        InputStream i = this.getResourceAsStream(this.getClass(), "/icon.png");
        if (i != null) {
            try {
                return EncodedImage.create(i);
            }
            catch (IOException ex) {
                Log.e(ex);
            }
        }
        return null;
    }

    public static Class getStringArrayClass() {
        try {
            return String[].class;
        }
        catch (Throwable t) {
            return new String[0].getClass();
        }
    }

    public static Class getStringArray2DClass() {
        try {
            return String[][].class;
        }
        catch (Throwable t) {
            return new String[1][].getClass();
        }
    }

    public static Class getImageArrayClass() {
        try {
            return Image[].class;
        }
        catch (Throwable t) {
            return new Image[0].getClass();
        }
    }

    public static Class getObjectArrayClass() {
        try {
            return Object[].class;
        }
        catch (Throwable t) {
            return new Object[0].getClass();
        }
    }

    public String[] getAllContacts(boolean withNumbers) {
        return null;
    }

    public String[] getLinkedContactIds(Contact c) {
        if (c == null || c.getId() == null) {
            return new String[0];
        }
        return new String[]{c.getId()};
    }

    public Contact getContactById(String id) {
        return null;
    }

    public Contact[] getAllContacts(boolean withNumbers, boolean includesFullName, boolean includesPicture, boolean includesNumbers, boolean includesEmail, boolean includeAddress) {
        String[] arr = this.getAllContacts(withNumbers);
        if (arr == null) {
            return null;
        }
        Contact[] retVal = new Contact[arr.length];
        int alen = arr.length;
        for (int iter = 0; iter < alen; ++iter) {
            retVal[iter] = this.getContactById(arr[iter], includesFullName, includesPicture, includesNumbers, includesEmail, includeAddress);
        }
        return retVal;
    }

    public boolean isGetAllContactsFast() {
        return false;
    }

    public Contact getContactById(String id, boolean includesFullName, boolean includesPicture, boolean includesNumbers, boolean includesEmail, boolean includeAddress) {
        return null;
    }

    public String createContact(String firstName, String surname, String officePhone, String homePhone, String cellPhone, String email) {
        return null;
    }

    public boolean isContactsPermissionGranted() {
        return true;
    }

    public boolean deleteContact(String id) {
        return false;
    }

    public boolean isNativeShareSupported() {
        return false;
    }

    public void share(String text, String image, String mimeType) {
        this.share(text, image, mimeType, null);
    }

    public void share(String text, String image, String mimeType, Rectangle sourceRect) {
    }

    public void beforeComponentPaint(Component c, Graphics g) {
    }

    public void afterComponentPaint(Component c, Graphics g) {
    }

    public void nothingWithinComponentPaint(Component c) {
    }

    public void componentRemoved(Component c) {
    }

    public abstract L10NManager getLocalizationManager();

    protected String getPackageName() {
        if (this.packageName == null) {
            return Display.getInstance().getProperty("package_name", null);
        }
        return this.packageName;
    }

    public boolean isTransformSupported() {
        return false;
    }

    public boolean isPerspectiveTransformSupported() {
        return false;
    }

    public boolean transformEqualsImpl(Transform t1, Transform t2) {
        Object o1 = null;
        if (t1 != null) {
            o1 = t1.getNativeTransform();
        }
        Object o2 = null;
        if (t2 != null) {
            o2 = t2.getNativeTransform();
        }
        return this.transformNativeEqualsImpl(o1, o2);
    }

    public boolean transformNativeEqualsImpl(Object t1, Object t2) {
        throw new RuntimeException("Transforms not supported");
    }

    public Object makeTransformTranslation(float translateX, float translateY, float translateZ) {
        throw new RuntimeException("Transforms not supported");
    }

    public void setTransformTranslation(Object nativeTransform, float translateX, float translateY, float translateZ) {
        this.setTransformIdentity(nativeTransform);
        this.transformTranslate(nativeTransform, translateX, translateY, translateZ);
    }

    public Object makeTransformScale(float scaleX, float scaleY, float scaleZ) {
        throw new RuntimeException("Transforms not supported");
    }

    public Object makeTransformAffine(double m00, double m10, double m01, double m11, double m02, double m12) {
        throw new RuntimeException("Transforms not supported");
    }

    public void setTransformAffine(Object nativeTransform, double m00, double m10, double m01, double m11, double m02, double m12) {
        throw new RuntimeException("Transforms not supported");
    }

    public void setTransformScale(Object nativeTransform, float scaleX, float scaleY, float scaleZ) {
        this.setTransformIdentity(nativeTransform);
        this.transformScale(nativeTransform, scaleX, scaleY, scaleZ);
    }

    public Object makeTransformRotation(float angle, float x, float y, float z) {
        throw new RuntimeException("Transforms not supported");
    }

    public void setTransformRotation(Object nativeTransform, float angle, float x, float y, float z) {
        this.setTransformIdentity(nativeTransform);
        this.transformRotate(nativeTransform, angle, x, y, z);
    }

    public Object makeTransformPerspective(float fovy, float aspect, float zNear, float zFar) {
        throw new RuntimeException("Transforms not supported");
    }

    public void setTransformPerspective(Object nativeTransform, float fovy, float aspect, float zNear, float zFar) {
        Object persp = this.makeTransformPerspective(fovy, aspect, zNear, zFar);
        this.copyTransform(persp, nativeTransform);
    }

    public Object makeTransformOrtho(float left, float right, float bottom, float top, float near, float far) {
        throw new RuntimeException("Transforms not supported");
    }

    public void setTransformOrtho(Object nativeTransform, float left, float right, float bottom, float top, float near, float far) {
        Object ortho = this.makeTransformOrtho(left, right, bottom, top, near, far);
        this.copyTransform(ortho, nativeTransform);
    }

    public Object makeTransformCamera(float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        throw new RuntimeException("Transforms not supported");
    }

    public void setTransformCamera(Object nativeTransform, float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        Object cam = this.makeTransformCamera(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
        this.copyTransform(cam, nativeTransform);
    }

    public void transformRotate(Object nativeTransform, float angle, float x, float y, float z) {
        Object rot = this.makeTransformRotation(angle, x, y, z);
        this.concatenateTransform(nativeTransform, rot);
    }

    public void transformTranslate(Object nativeTransform, float x, float y, float z) {
        Object tr = this.makeTransformTranslation(x, y, z);
        this.concatenateTransform(nativeTransform, tr);
    }

    public void transformScale(Object nativeTransform, float x, float y, float z) {
        Object scale = this.makeTransformScale(x, y, z);
        this.concatenateTransform(nativeTransform, scale);
    }

    public Object makeTransformInverse(Object nativeTransform) {
        throw new RuntimeException("Transforms not supported");
    }

    public void setTransformInverse(Object nativeTransform) throws Transform.NotInvertibleException {
        this.copyTransform(this.makeTransformInverse(nativeTransform), nativeTransform);
    }

    public Object makeTransformIdentity() {
        throw new RuntimeException("Transforms not supported");
    }

    public void setTransformIdentity(Object transform) {
        this.copyTransform(this.makeTransformIdentity(), transform);
    }

    public void copyTransform(Object src, Object dest) {
        throw new RuntimeException("Transforms not supported");
    }

    public void concatenateTransform(Object t1, Object t2) {
        throw new RuntimeException("Transforms not supported");
    }

    public void transformPoint(Object nativeTransform, float[] in, float[] out) {
        throw new RuntimeException("Transforms not supported");
    }

    public void transformPoints(Object nativeTransform, int pointSize, float[] in, int srcPos, float[] out, int destPos, int numPoints) {
        float[] bufIn = new float[pointSize];
        float[] bufOut = new float[pointSize];
        int len = numPoints * pointSize;
        for (int i = 0; i < len; i += pointSize) {
            System.arraycopy(in, srcPos + i, bufIn, 0, pointSize);
            this.transformPoint(nativeTransform, bufIn, bufOut);
            System.arraycopy(bufOut, 0, out, destPos + i, pointSize);
        }
    }

    public void translatePoints(int pointSize, float tX, float tY, float tZ, float[] in, int srcPos, float[] out, int destPos, int numPoints) {
        int len = numPoints * pointSize;
        for (int i = 0; i < len; i += pointSize) {
            int d0 = destPos + i;
            int s0 = srcPos + i;
            out[d0++] = in[s0++] + tX;
            out[d0++] = in[s0++] + tY;
            if (pointSize <= 2) continue;
            out[d0] = in[s0] + tZ;
        }
    }

    public void scalePoints(int pointSize, float sX, float sY, float sZ, float[] in, int srcPos, float[] out, int destPos, int numPoints) {
        int len = numPoints * pointSize;
        for (int i = 0; i < len; i += pointSize) {
            int d0 = destPos + i;
            int s0 = srcPos + i;
            out[d0++] = in[s0++] * sX;
            out[d0++] = in[s0++] * sY;
            if (pointSize <= 2) continue;
            out[d0] = in[s0] * sZ;
        }
    }

    public void refreshContacts() {
    }

    public void getTransform(Object nativeGraphics, Transform t) {
        t.setIdentity();
    }

    public boolean isScrollWheeling() {
        return false;
    }

    public void blockCopyPaste(boolean blockCopyPaste) {
    }

    public boolean isDatabaseCustomPathSupported() {
        return false;
    }

    public boolean requestFullScreen() {
        return false;
    }

    public boolean exitFullScreen() {
        return false;
    }

    public boolean isInFullScreenMode() {
        return false;
    }

    public boolean isFullScreenSupported() {
        return false;
    }

    public void initializeTextSelection(TextSelection aThis) {
    }

    public void deinitializeTextSelection(TextSelection aThis) {
    }

    public Object createHeavyButton(Button aThis) {
        return null;
    }

    public void addHeavyActionListener(Object peer, ActionListener l) {
    }

    public void removeHeavyActionListener(Object peer, ActionListener l) {
    }

    public void updateHeavyButtonBounds(Object peer, int x, int y, int width, int height) {
    }

    public void initHeavyButton(Object peer) {
    }

    public void deinitializeHeavyButton(Object peer) {
    }

    public boolean requiresHeavyButtonForCopyToClipboard() {
        return false;
    }

    public void copySelectionToClipboard(TextSelection sel) {
        this.copyToClipboard(sel.getSelectionAsText());
    }

    public void setRenderingHints(Object nativeGraphics, int hints) {
    }

    public int getRenderingHints(Object nativeGraphics) {
        return 0;
    }

    public void startRemoteControl() {
    }

    public void stopRemoteControl() {
    }

    public void setReadTimeout(Object connection, int readTimeout) {
    }

    public void setInsecure(Object connection, boolean insecure) {
    }

    public boolean isReadTimeoutSupported() {
        return false;
    }

    public Object createNativeBrowserWindow(String startURL) {
        return null;
    }

    public void addNativeBrowserWindowOnLoadListener(Object window, ActionListener l) {
    }

    public void removeNativeBrowserWindowOnLoadListener(Object window, ActionListener l) {
    }

    public void nativeBrowserWindowSetSize(Object window, int width, int height) {
    }

    public void nativeBrowserWindowSetTitle(Object window, String title) {
    }

    public void nativeBrowserWindowShow(Object window) {
    }

    public void nativeBrowserWindowHide(Object window) {
    }

    public void nativeBrowserWindowCleanup(Object window) {
    }

    public void nativeBrowserWindowEval(Object window, BrowserWindow.EvalRequest req) {
        if (!req.isDone()) {
            req.error(new RuntimeException("Not implemented"));
        }
    }

    public void nativeBrowserWindowAddCloseListener(Object window, ActionListener l) {
    }

    public void nativeBrowserWindowRemoveCloseListener(Object window, ActionListener l) {
    }

    public void registerPush(Hashtable metaData, boolean noFallback) {
        if (!noFallback) {
            Preferences.set("PollingPush", true);
            CodenameOneImplementation.registerPushOnServer(this.getPackageName(), CodenameOneImplementation.getApplicationKey(), (byte)10, "", this.getPackageName());
            Display.getInstance().callSerially(new RPush());
            CodenameOneImplementation.registerPollingFallback();
        }
    }

    public void deregisterPush() {
        Preferences.delete("PollingPush");
        CodenameOneImplementation.stopPolling();
    }

    public Media createMediaRecorder(String path, String mimeType) throws IOException {
        return null;
    }

    public Media createMediaRecorder(MediaRecorderBuilder builder) throws IOException {
        return this.createMediaRecorder(builder.getPath(), builder.getMimeType());
    }

    protected static void stopPolling() {
        pollingThreadRunning = false;
    }

    protected static String getApplicationKey() {
        Display d = Display.getInstance();
        return d.getProperty("built_by_user", "Unknown Build Key") + '/' + d.getProperty("package_name", "Unknown Build Key");
    }

    public static boolean registerServerPush(String id, String applicationKey, byte pushType, String udid, String packageName) {
        Preferences.set("push_key", id);
        return true;
    }

    public static void registerPushOnServer(String id, String applicationKey, byte pushType, String udid, String packageName) {
        CodenameOneImplementation.registerServerPush(id, applicationKey, pushType, udid, packageName);
    }

    protected final void sendRegisteredForPush(String id) {
        if (callback != null) {
            callback.registeredForPush(id);
        }
    }

    protected final void pushReceived(String data) {
        if (callback != null) {
            callback.push(data);
        }
    }

    public static void deregisterPushFromServer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPollingFrequency(int freq) {
        pollingMillis = freq;
        if (callback != null && pollingThreadRunning) {
            PushCallback pushCallback = callback;
            synchronized (pushCallback) {
                callback.notify();
            }
        }
    }

    protected static void registerPollingFallback() {
    }

    public ImageIO getImageIO() {
        return null;
    }

    public boolean instanceofObjArray(Object o) {
        return o instanceof Object[];
    }

    public boolean instanceofByteArray(Object o) {
        return o instanceof byte[];
    }

    public boolean instanceofShortArray(Object o) {
        return o instanceof short[];
    }

    public boolean instanceofLongArray(Object o) {
        return o instanceof long[];
    }

    public boolean instanceofIntArray(Object o) {
        return o instanceof int[];
    }

    public boolean instanceofFloatArray(Object o) {
        return o instanceof float[];
    }

    public boolean instanceofDoubleArray(Object o) {
        return o instanceof double[];
    }

    public String[] getAvailableRecordingMimeTypes() {
        return new String[]{"audio/amr", "audio/aac"};
    }

    public Database openOrCreateDB(String databaseName) throws IOException {
        return null;
    }

    public void deleteDB(String databaseName) throws IOException {
    }

    public boolean existsDB(String databaseName) {
        return false;
    }

    public String getDatabasePath(String databaseName) {
        return null;
    }

    public boolean isNativeTitle() {
        return false;
    }

    public void refreshNativeTitle() {
    }

    public int getCommandBehavior() {
        return this.commandBehavior;
    }

    public void setCommandBehavior(int commandBehavior) {
        if (!this.isTouchDevice() && commandBehavior == 4) {
            commandBehavior = 2;
        }
        this.commandBehavior = commandBehavior;
        this.notifyCommandBehavior(commandBehavior);
    }

    public Object notifyStatusBar(String tickerText, String contentTitle, String contentBody, boolean vibrate, boolean flashLights, Hashtable args) {
        return null;
    }

    public boolean isNotificationSupported() {
        return false;
    }

    public void dismissNotification(Object o) {
    }

    public boolean isBadgingSupported() {
        return false;
    }

    public void setBadgeNumber(int number) {
    }

    public boolean isOpenNativeNavigationAppSupported() {
        return false;
    }

    public void openNativeNavigationApp(double latitude, double longitude) {
    }

    public void openNativeNavigationApp(String location) {
        this.execute("http://maps.google.com/?q=" + Util.encodeUrl(location));
    }

    public String getUdid() {
        return this.getProperty("UDID", null);
    }

    public String getMsisdn() {
        return this.getProperty("MSISDN", null);
    }

    public Purchase getInAppPurchase() {
        return null;
    }

    public CodeScanner getCodeScanner() {
        return null;
    }

    public String toNativePath(String path) {
        return path;
    }

    public String getAppHomePath() {
        String home = this.listFilesystemRoots()[0];
        String name = this.getProperty("AppName", this.packageName);
        if (!home.endsWith("" + this.getFileSystemSeparator())) {
            home = home + this.getFileSystemSeparator();
        }
        if (!this.exists(home = home + name + this.getFileSystemSeparator())) {
            this.mkdir(home);
        }
        return home;
    }

    public boolean hasCachesDir() {
        return false;
    }

    public String getCachesDir() {
        return null;
    }

    public boolean isUseNativeCookieStore() {
        return this.useNativeCookieStore;
    }

    public void setUseNativeCookieStore(boolean useNativeCookieStore) {
        this.useNativeCookieStore = useNativeCookieStore;
    }

    public boolean shouldPaintBackground() {
        return true;
    }

    public Transition getNativeTransition(Transition t) {
        return t;
    }

    public boolean isScreenLockSupported() {
        return false;
    }

    public void lockScreen() {
    }

    public void unlockScreen() {
    }

    public boolean hasCamera() {
        return true;
    }

    public int getEDTThreadPriority() {
        return 6;
    }

    public void drawingEncodedImage(EncodedImage img) {
    }

    public boolean isNativePickerTypeSupported(int pickerType) {
        return false;
    }

    public Object showNativePicker(int type, Component source, Object currentValue, Object data) {
        return null;
    }

    public Object connectSocket(String host, int port) {
        return this.connectSocket(host, port, 0);
    }

    public Object connectSocket(String host, int port, int connectTimeout) {
        throw new RuntimeException("Not supported");
    }

    public Object listenSocket(int port) {
        throw new RuntimeException("Not supported");
    }

    public String getHostOrIP() {
        return null;
    }

    public void disconnectSocket(Object socket) {
    }

    public boolean isSocketConnected(Object socket) {
        return false;
    }

    public boolean isServerSocketAvailable() {
        return false;
    }

    public boolean isSocketAvailable() {
        return false;
    }

    public String getSocketErrorMessage(Object socket) {
        return null;
    }

    public int getSocketErrorCode(Object socket) {
        return -1;
    }

    public int getSocketAvailableInput(Object socket) {
        return 0;
    }

    public byte[] readFromSocketStream(Object socket) {
        return null;
    }

    public void writeToSocketStream(Object socket, byte[] data) {
    }

    private void mkdirs(FileSystemStorage fs, String path) {
        int lastPos = path.lastIndexOf(47);
        if (lastPos >= 0) {
            this.mkdirs(fs, path.substring(0, lastPos));
        }
        if (!fs.exists(path)) {
            this.mkdir(path);
        }
    }

    public void installTar() throws IOException {
        String p = Preferences.get("cn1$InstallKey", null);
        String buildKey = Display.getInstance().getProperty("build_key", null);
        if (p == null || !p.equals(buildKey)) {
            FileSystemStorage fs = FileSystemStorage.getInstance();
            String tardir = fs.getAppHomePath() + "cn1html/";
            fs.mkdir(tardir);
            TarInputStream is = new TarInputStream(Display.getInstance().getResourceAsStream(this.getClass(), "/html.tar"));
            TarEntry t = is.getNextEntry();
            byte[] data = new byte[8192];
            while (t != null) {
                String name = t.getName();
                if (t.isDirectory()) {
                    fs.mkdir(tardir + name);
                } else {
                    int count;
                    String path = tardir + name;
                    String dir = path.substring(0, path.lastIndexOf(47));
                    if (!fs.exists(dir)) {
                        this.mkdirs(fs, dir);
                    }
                    OutputStream os = fs.openOutputStream(tardir + name);
                    while ((count = is.read(data)) != -1) {
                        os.write(data, 0, count);
                    }
                    os.close();
                }
                t = is.getNextEntry();
            }
            Util.cleanup(is);
            Preferences.set("cn1$InstallKey", buildKey);
        }
    }

    public void splitString(String source, char separator, ArrayList<String> out) {
        int len = source.length();
        boolean lastSeparator = false;
        StringBuilder buf = new StringBuilder();
        for (int iter = 0; iter < len; ++iter) {
            char current = source.charAt(iter);
            if (current == separator) {
                if (lastSeparator) {
                    lastSeparator = false;
                    continue;
                }
                lastSeparator = true;
                if (buf.length() <= 0) continue;
                out.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            lastSeparator = false;
            buf.append(current);
        }
        if (buf.length() > 0) {
            out.add(buf.toString());
        }
    }

    public boolean isSimulator() {
        return false;
    }

    public void paintComponentBackground(Object nativeGraphics, int x, int y, int width, int height, Style s) {
        if (width <= 0 || height <= 0) {
            return;
        }
        Image bgImageOrig = s.getBgImage();
        if (bgImageOrig == null) {
            if (s.getBackgroundType() >= 6) {
                this.drawGradientBackground(s, nativeGraphics, x, y, width, height);
                return;
            }
            this.setColor(nativeGraphics, s.getBgColor());
            this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
        } else {
            int iW = bgImageOrig.getWidth();
            int iH = bgImageOrig.getHeight();
            Object bgImage = bgImageOrig.getImage();
            switch (s.getBackgroundType()) {
                case 0: {
                    if (s.getBgTransparency() != 0) {
                        this.setColor(nativeGraphics, s.getBgColor());
                        this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    }
                    return;
                }
                case 1: {
                    if (this.isScaledImageDrawingSupported()) {
                        this.drawImage(nativeGraphics, bgImage, x, y, width, height);
                    } else {
                        if (iW != width || iH != height) {
                            bgImageOrig = bgImageOrig.scaled(width, height);
                            s.setBgImage(bgImageOrig, true);
                            bgImage = bgImageOrig.getImage();
                        }
                        this.drawImage(nativeGraphics, bgImage, x, y);
                    }
                    return;
                }
                case 33: {
                    float r = Math.max((float)width / (float)iW, (float)height / (float)iH);
                    int bwidth = (int)((float)iW * r);
                    int bheight = (int)((float)iH * r);
                    if (this.isScaledImageDrawingSupported()) {
                        this.drawImage(nativeGraphics, bgImage, x + (width - bwidth) / 2, y + (height - bheight) / 2, bwidth, bheight);
                    } else {
                        if (iW != bwidth || iH != bheight) {
                            bgImageOrig = bgImageOrig.scaled(bwidth, bheight);
                            s.setBgImage(bgImageOrig, true);
                            bgImage = bgImageOrig.getImage();
                        }
                        this.drawImage(nativeGraphics, bgImage, x + (width - bwidth) / 2, y + (height - bheight) / 2);
                    }
                    return;
                }
                case 34: {
                    if (s.getBgTransparency() != 0) {
                        this.setColor(nativeGraphics, s.getBgColor());
                        this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    }
                    float r2 = Math.min((float)width / (float)iW, (float)height / (float)iH);
                    int awidth = (int)((float)iW * r2);
                    int aheight = (int)((float)iH * r2);
                    if (this.isScaledImageDrawingSupported()) {
                        this.drawImage(nativeGraphics, bgImage, x + (width - awidth) / 2, y + (height - aheight) / 2, awidth, aheight);
                    } else {
                        if (iW != awidth || iH != aheight) {
                            bgImageOrig = bgImageOrig.scaled(awidth, aheight);
                            s.setBgImage(bgImageOrig, true);
                            bgImage = bgImageOrig.getImage();
                        }
                        this.drawImage(nativeGraphics, bgImage, x + (width - awidth) / 2, y + (height - aheight) / 2, awidth, aheight);
                    }
                    return;
                }
                case 2: {
                    this.tileImage(nativeGraphics, bgImage, x, y, width, height);
                    return;
                }
                case 4: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.tileImage(nativeGraphics, bgImage, x, y, width, iH);
                    return;
                }
                case 29: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.tileImage(nativeGraphics, bgImage, x, y + (height / 2 - iH / 2), width, iH);
                    return;
                }
                case 30: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.tileImage(nativeGraphics, bgImage, x, y + (height - iH), width, iH);
                    return;
                }
                case 3: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    for (int yPos = 0; yPos <= height; yPos += iH) {
                        this.drawImage(nativeGraphics, bgImage, x, y + yPos);
                    }
                    return;
                }
                case 31: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    for (int yPos = 0; yPos <= height; yPos += iH) {
                        this.drawImage(nativeGraphics, bgImage, x + (width / 2 - iW / 2), y + yPos);
                    }
                    return;
                }
                case 32: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    for (int yPos = 0; yPos <= height; yPos += iH) {
                        this.drawImage(nativeGraphics, bgImage, x + width - iW, y + yPos);
                    }
                    return;
                }
                case 20: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.drawImage(nativeGraphics, bgImage, x + (width / 2 - iW / 2), y);
                    return;
                }
                case 21: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.drawImage(nativeGraphics, bgImage, x + (width / 2 - iW / 2), y + (height - iH));
                    return;
                }
                case 22: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.drawImage(nativeGraphics, bgImage, x, y + (height / 2 - iH / 2));
                    return;
                }
                case 23: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.drawImage(nativeGraphics, bgImage, x + width - iW, y + (height / 2 - iH / 2));
                    return;
                }
                case 24: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.drawImage(nativeGraphics, bgImage, x + (width / 2 - iW / 2), y + (height / 2 - iH / 2));
                    return;
                }
                case 25: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.drawImage(nativeGraphics, bgImage, x, y);
                    return;
                }
                case 26: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.drawImage(nativeGraphics, bgImage, x + width - iW, y);
                    return;
                }
                case 27: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.drawImage(nativeGraphics, bgImage, x, y + (height - iH));
                    return;
                }
                case 28: {
                    this.setColor(nativeGraphics, s.getBgColor());
                    this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
                    this.drawImage(nativeGraphics, bgImage, x + width - iW, y + (height - iH));
                    return;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.drawGradientBackground(s, nativeGraphics, x, y, width, height);
                    return;
                }
            }
        }
    }

    private void drawGradientBackground(Style s, Object nativeGraphics, int x, int y, int width, int height) {
        switch (s.getBackgroundType()) {
            case 7: {
                this.fillLinearGradient(nativeGraphics, s.getBackgroundGradientStartColor(), s.getBackgroundGradientEndColor(), x, y, width, height, true);
                return;
            }
            case 6: {
                this.fillLinearGradient(nativeGraphics, s.getBackgroundGradientStartColor(), s.getBackgroundGradientEndColor(), x, y, width, height, false);
                return;
            }
            case 8: {
                this.fillRectRadialGradient(nativeGraphics, s.getBackgroundGradientStartColor(), s.getBackgroundGradientEndColor(), x, y, width, height, s.getBackgroundGradientRelativeX(), s.getBackgroundGradientRelativeY(), s.getBackgroundGradientRelativeSize());
                return;
            }
        }
        this.setColor(nativeGraphics, s.getBgColor());
        this.fillRect(nativeGraphics, x, y, width, height, s.getBgTransparency());
    }

    public void fillRect(Object nativeGraphics, int x, int y, int w, int h, byte alpha) {
        if (alpha != 0) {
            int oldAlpha = this.getAlpha(nativeGraphics);
            this.setAlpha(nativeGraphics, alpha & 0xFF);
            this.fillRect(nativeGraphics, x, y, w, h);
            this.setAlpha(nativeGraphics, oldAlpha);
        }
    }

    public void drawLabelComponent(Object nativeGraphics, int cmpX, int cmpY, int cmpHeight, int cmpWidth, Style style, String text, Object icon, Object stateIcon, int preserveSpaceForState, int gap, boolean rtl, boolean isOppositeSide, int textPosition, int stringWidth, boolean isTickerRunning, int tickerShiftText, boolean endsWith3Points, int valign) {
        Font font = style.getFont();
        Object nativeFont = font.getNativeFont();
        this.setNativeFont(nativeGraphics, nativeFont);
        this.setColor(nativeGraphics, style.getFgColor());
        int alpha = this.concatenateAlpha(nativeGraphics, style.getFgAlpha());
        int iconWidth = 0;
        int iconHeight = 0;
        if (icon != null) {
            iconWidth = this.getImageWidth(icon);
            iconHeight = this.getImageHeight(icon);
        }
        int textDecoration = style.getTextDecoration();
        int stateIconSize = 0;
        int stateIconYPosition = 0;
        int leftPadding = style.getPaddingLeft(rtl);
        int rightPadding = style.getPaddingRight(rtl);
        int topPadding = style.getPaddingTop();
        int bottomPadding = style.getPaddingBottom();
        int fontHeight = 0;
        if (text == null) {
            text = "";
        }
        if (text.length() > 0) {
            fontHeight = font.getHeight();
        }
        if (stateIcon != null) {
            stateIconSize = this.getImageWidth(stateIcon);
            stateIconYPosition = cmpY + topPadding + (cmpHeight - topPadding - bottomPadding) / 2 - stateIconSize / 2;
            int tX = cmpX;
            if (isOppositeSide) {
                tX = rtl ? (tX += leftPadding) : tX + cmpWidth - leftPadding - stateIconSize;
                cmpWidth -= leftPadding - stateIconSize;
            } else {
                preserveSpaceForState = stateIconSize + gap;
                tX = rtl ? tX + cmpWidth - leftPadding - stateIconSize : (tX += leftPadding);
            }
            this.drawImage(nativeGraphics, stateIcon, tX, stateIconYPosition);
        }
        int x = cmpX + leftPadding + preserveSpaceForState;
        int y = cmpY + topPadding;
        int align = this.reverseAlignForBidi(rtl, style.getAlignment());
        int textPos = this.reverseAlignForBidi(rtl, textPosition);
        switch (align) {
            case 1: {
                switch (textPos) {
                    case 1: 
                    case 3: {
                        y += (cmpHeight - (topPadding + bottomPadding + Math.max(icon != null ? iconHeight : 0, fontHeight))) / 2;
                        break;
                    }
                    case 0: 
                    case 2: {
                        y += (cmpHeight - (topPadding + bottomPadding + (icon != null ? iconHeight + gap : 0) + fontHeight)) / 2;
                    }
                }
                break;
            }
            case 4: {
                switch (textPos) {
                    case 1: 
                    case 3: {
                        x += (cmpWidth - (preserveSpaceForState + leftPadding + rightPadding + (icon != null ? iconWidth + gap : 0) + stringWidth)) / 2;
                        x = Math.max(x, cmpX + leftPadding + preserveSpaceForState);
                        y += (cmpHeight - (topPadding + bottomPadding + Math.max(icon != null ? iconHeight : 0, fontHeight))) / 2;
                        break;
                    }
                    case 0: 
                    case 2: {
                        x += (cmpWidth - (preserveSpaceForState + leftPadding + rightPadding + Math.max(icon != null ? iconWidth + gap : 0, stringWidth))) / 2;
                        x = Math.max(x, cmpX + leftPadding + preserveSpaceForState);
                        y += (cmpHeight - (topPadding + bottomPadding + (icon != null ? iconHeight + gap : 0) + fontHeight)) / 2;
                    }
                }
                break;
            }
            case 3: {
                switch (textPos) {
                    case 1: 
                    case 3: {
                        x = cmpX + cmpWidth - rightPadding - ((icon != null ? iconWidth + gap : 0) + stringWidth);
                        x = rtl ? Math.max(x - preserveSpaceForState, cmpX + leftPadding) : Math.max(x, cmpX + leftPadding + preserveSpaceForState);
                        y += (cmpHeight - (topPadding + bottomPadding + Math.max(icon != null ? iconHeight : 0, fontHeight))) / 2;
                        break;
                    }
                    case 0: 
                    case 2: {
                        x = cmpX + cmpWidth - rightPadding - Math.max(icon != null ? iconWidth : 0, stringWidth);
                        x = Math.max(x, cmpX + leftPadding + preserveSpaceForState);
                        y += (cmpHeight - (topPadding + bottomPadding + (icon != null ? iconHeight + gap : 0) + fontHeight)) / 2;
                    }
                }
                break;
            }
        }
        int textSpaceW = cmpWidth - rightPadding - leftPadding;
        if (icon != null && (textPos == 3 || textPos == 1)) {
            textSpaceW -= iconWidth;
        }
        textSpaceW = stateIcon != null ? (textSpaceW -= stateIconSize) : (textSpaceW -= preserveSpaceForState);
        if (icon == null) {
            this.drawLabelString(nativeGraphics, nativeFont, text, x, y, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, stringWidth, fontHeight);
        } else {
            int strWidth = stringWidth;
            switch (textPos) {
                case 1: {
                    if (iconHeight > fontHeight) {
                        int iconStringHGap = (iconHeight - fontHeight) / 2;
                        strWidth = this.drawLabelStringValign(nativeGraphics, nativeFont, text, x, y, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, strWidth, iconStringHGap, iconHeight, fontHeight, valign);
                        this.drawImage(nativeGraphics, icon, x + strWidth + gap, y);
                        break;
                    }
                    int iconStringHGap = (fontHeight - iconHeight) / 2;
                    strWidth = this.drawLabelString(nativeGraphics, nativeFont, text, x, y, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, strWidth, fontHeight);
                    this.drawImage(nativeGraphics, icon, x + strWidth + gap, y + iconStringHGap);
                    break;
                }
                case 3: {
                    if (iconHeight > fontHeight) {
                        int iconStringHGap = (iconHeight - fontHeight) / 2;
                        this.drawImage(nativeGraphics, icon, x, y);
                        this.drawLabelStringValign(nativeGraphics, nativeFont, text, x + iconWidth + gap, y, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, stringWidth, iconStringHGap, iconHeight, fontHeight, valign);
                        break;
                    }
                    int iconStringHGap = (fontHeight - iconHeight) / 2;
                    this.drawImage(nativeGraphics, icon, x, y + iconStringHGap);
                    this.drawLabelString(nativeGraphics, nativeFont, text, x + iconWidth + gap, y, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, stringWidth, fontHeight);
                    break;
                }
                case 2: {
                    if (iconWidth > strWidth) {
                        int iconStringWGap = (iconWidth - strWidth) / 2;
                        this.drawImage(nativeGraphics, icon, x, y);
                        this.drawLabelString(nativeGraphics, nativeFont, text, x + iconStringWGap, y + iconHeight + gap, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, stringWidth, fontHeight);
                        break;
                    }
                    int iconStringWGap = (Math.min(strWidth, textSpaceW) - iconWidth) / 2;
                    this.drawImage(nativeGraphics, icon, x + iconStringWGap, y);
                    this.drawLabelString(nativeGraphics, nativeFont, text, x, y + iconHeight + gap, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, stringWidth, fontHeight);
                    break;
                }
                case 0: {
                    if (iconWidth > strWidth) {
                        int iconStringWGap = (iconWidth - strWidth) / 2;
                        this.drawLabelString(nativeGraphics, nativeFont, text, x + iconStringWGap, y, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, stringWidth, fontHeight);
                        this.drawImage(nativeGraphics, icon, x, y + fontHeight + gap);
                        break;
                    }
                    int iconStringWGap = (Math.min(strWidth, textSpaceW) - iconWidth) / 2;
                    this.drawLabelString(nativeGraphics, nativeFont, text, x, y, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, stringWidth, fontHeight);
                    this.drawImage(nativeGraphics, icon, x + iconStringWGap, y + fontHeight + gap);
                }
            }
        }
        this.setAlpha(nativeGraphics, alpha);
    }

    private int drawLabelStringValign(Object nativeGraphics, Object nativeFont, String str, int x, int y, int textSpaceW, boolean isTickerRunning, int tickerShiftText, int textDecoration, boolean rtl, boolean endsWith3Points, int textWidth, int iconStringHGap, int iconHeight, int fontHeight, int valign) {
        switch (valign) {
            case 0: {
                return this.drawLabelString(nativeGraphics, nativeFont, str, x, y, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, textWidth, fontHeight);
            }
            case 4: {
                return this.drawLabelString(nativeGraphics, nativeFont, str, x, y + iconHeight / 2 - fontHeight / 2, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, textWidth, fontHeight);
            }
        }
        return this.drawLabelString(nativeGraphics, nativeFont, str, x, y + iconStringHGap, textSpaceW, isTickerRunning, tickerShiftText, textDecoration, rtl, endsWith3Points, textWidth, fontHeight);
    }

    private int drawLabelString(Object nativeGraphics, Object nativeFont, String text, int x, int y, int textSpaceW, boolean isTickerRunning, int tickerShiftText, int textDecoration, boolean rtl, boolean endsWith3Points, int textWidth, int fontHeight) {
        int cx = this.getClipX(nativeGraphics);
        int cy = this.getClipY(nativeGraphics);
        int cw = this.getClipWidth(nativeGraphics);
        int ch = this.getClipHeight(nativeGraphics);
        this.clipRect(nativeGraphics, x, cy, textSpaceW, ch);
        int drawnW = this.drawLabelText(nativeGraphics, textDecoration, rtl, isTickerRunning, endsWith3Points, nativeFont, textWidth, textSpaceW, tickerShiftText, text, x, y, fontHeight);
        this.setClip(nativeGraphics, cx, cy, cw, ch);
        return drawnW;
    }

    private boolean fastCharWidthCheck(String s, int length, int width, int charWidth, Object f) {
        if (length * charWidth < width) {
            return true;
        }
        length = Math.min(s.length(), length);
        return this.stringWidth(f, s.substring(0, length)) < width;
    }

    protected int drawLabelText(Object nativeGraphics, int textDecoration, boolean rtl, boolean isTickerRunning, boolean endsWith3Points, Object nativeFont, int txtW, int textSpaceW, int shiftText, String text, int x, int y, int fontHeight) {
        if ((!isTickerRunning || rtl) && txtW > textSpaceW && textSpaceW > 0) {
            if (rtl) {
                if (!isTickerRunning && endsWith3Points) {
                    String points = "...";
                    int pointsW = this.stringWidth(nativeFont, points);
                    this.drawString(nativeGraphics, nativeFont, points, shiftText + x, y, textDecoration, fontHeight);
                    this.clipRect(nativeGraphics, pointsW + shiftText + x, y, textSpaceW - pointsW, fontHeight);
                }
                x = x - txtW + textSpaceW;
            } else if (endsWith3Points) {
                int index;
                String points = "...";
                int widest = this.charWidth(nativeFont, 'W');
                int pointsW = this.stringWidth(nativeFont, points);
                int textLen = text.length();
                for (index = 1; this.fastCharWidthCheck(text, index, textSpaceW - pointsW, widest, nativeFont) && index < textLen; ++index) {
                }
                text = text.substring(0, Math.min(textLen, Math.max(1, index - 1))) + points;
                txtW = this.stringWidth(nativeFont, text);
            }
        }
        this.drawString(nativeGraphics, nativeFont, text, shiftText + x, y, textDecoration, fontHeight);
        return Math.min(txtW, textSpaceW);
    }

    public void drawString(Object nativeGraphics, Object nativeFont, String str, int x, int y, int textDecoration) {
        this.drawString(nativeGraphics, nativeFont, str, x, y, textDecoration, this.getHeight(nativeFont));
    }

    private void drawString(Object nativeGraphics, Object nativeFont, String str, int x, int y, int textDecoration, int fontHeight) {
        if (str.length() == 0) {
            return;
        }
        if (textDecoration != 0) {
            boolean north;
            boolean raised = (textDecoration & 8) != 0;
            boolean lowerd = (textDecoration & 0x10) != 0;
            boolean bl = north = (textDecoration & 0x20) != 0;
            if (raised || lowerd || north) {
                textDecoration = textDecoration & 0xFFFFFFF7 & 0xFFFFFFEF & 0xFFFFFFDF;
                int c = this.getColor(nativeGraphics);
                int a = this.getAlpha(nativeGraphics);
                int newColor = 0;
                int offset = -2;
                if (lowerd) {
                    offset = 2;
                    newColor = 0xFFFFFF;
                } else if (north) {
                    offset = 2;
                }
                this.setColor(nativeGraphics, newColor);
                this.concatenateAlpha(nativeGraphics, 140);
                this.drawString(nativeGraphics, nativeFont, str, x, y + offset, textDecoration, fontHeight);
                this.setAlpha(nativeGraphics, a);
                this.setColor(nativeGraphics, c);
                this.drawString(nativeGraphics, nativeFont, str, x, y, textDecoration, fontHeight);
                return;
            }
            this.drawString(nativeGraphics, str, x, y);
            if ((textDecoration & 1) != 0) {
                this.drawLine(nativeGraphics, x, y + fontHeight - 1, x + this.stringWidth(nativeFont, str), y + fontHeight - 1);
            }
            if ((textDecoration & 2) != 0) {
                this.drawLine(nativeGraphics, x, y + fontHeight / 2, x + this.stringWidth(nativeFont, str), y + fontHeight / 2);
            }
            if ((textDecoration & 4) != 0) {
                this.drawLine(nativeGraphics, x, y, x + this.stringWidth(nativeFont, str), y);
            }
        } else {
            this.drawString(nativeGraphics, str, x, y);
        }
    }

    private int reverseAlignForBidi(boolean rtl, int align) {
        if (rtl) {
            switch (align) {
                case 3: {
                    return 1;
                }
                case 1: {
                    return 3;
                }
            }
        }
        return align;
    }

    public void setPlatformHint(String key, String value) {
    }

    public void scheduleLocalNotification(LocalNotification notif, long firstTime, int repeat) {
    }

    public void cancelLocalNotification(String notificationId) {
    }

    public void setPreferredBackgroundFetchInterval(int seconds) {
        if (this.isBackgroundFetchSupported()) {
            Preferences.set("$$CN1_BACKGROUND_FETCH_INTERVAL", seconds);
        }
    }

    public int getPreferredBackgroundFetchInterval() {
        if (this.isBackgroundFetchSupported()) {
            return Preferences.get("$$CN1_BACKGROUND_FETCH_INTERVAL", 3600);
        }
        return -1;
    }

    public boolean isBackgroundFetchSupported() {
        return false;
    }

    public Image gaussianBlurImage(Image image, float radius) {
        return image;
    }

    public boolean isGaussianBlurSupported() {
        return false;
    }

    public boolean isJailbrokenDevice() {
        return false;
    }

    public Map<String, String> getProjectBuildHints() {
        return null;
    }

    public void setProjectBuildHint(String key, String value) {
        throw new RuntimeException();
    }

    public boolean canInstallOnHomescreen() {
        return false;
    }

    public boolean promptInstallOnHomescreen() {
        return false;
    }

    public void onCanInstallOnHomescreen(Runnable r) {
    }

    public boolean supportsNativeTextAreaVerticalAlignment() {
        return false;
    }

    public void postMessage(MessageEvent message) {
    }

    public Boolean isDarkMode() {
        return null;
    }

    static {
        pollingMillis = 10800000;
    }

    class RPush
    implements Runnable {
        RPush() {
        }

        public void run() {
            long pushId = Preferences.get("push_id", -1L);
            if (pushId > -1L && callback != null) {
                callback.registeredForPush("" + pushId);
            }
        }
    }
}

