/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui;

import com.codename1.ui.Component;
import com.codename1.ui.Container;
import com.codename1.ui.Display;
import com.codename1.ui.Form;

class LeadUtil {
    LeadUtil() {
    }

    public static Component leadParentImpl(Component cmp) {
        Container out;
        if (cmp == null) {
            return null;
        }
        if (cmp.hasLead && (out = cmp instanceof Container ? ((Container)cmp).getLeadParent() : cmp.getParent().getLeadParent()) != null) {
            return out;
        }
        return cmp;
    }

    public static Component leadComponentImpl(Component cmp) {
        Component out;
        if (cmp == null) {
            return null;
        }
        if (cmp.isDraggable() || cmp.scrollableXFlag() || cmp.scrollableYFlag()) {
            // empty if block
        }
        if (cmp.hasLead && (out = cmp.getLeadComponent()) != null) {
            return out;
        }
        return cmp;
    }

    public static void pointerPressed(Component cmp, int x, int y) {
        if (cmp == null) {
            return;
        }
        Component lead = LeadUtil.leadComponentImpl(cmp);
        lead.pointerPressed(x, y);
        Form f = cmp.getComponentForm();
        Component leadParent = LeadUtil.leadParentImpl(cmp);
        if (f != null && !Display.impl.isScrollWheeling() && leadParent.isFocusable() && leadParent.isEnabled()) {
            f.setFocused(leadParent);
        }
        if (cmp != lead) {
            leadParent.repaint();
        }
    }

    public static void pointerDragged(Component cmp, int x, int y) {
        if (cmp == null) {
            return;
        }
        Component lead = LeadUtil.leadComponentImpl(cmp);
        lead.pointerDragged(x, y);
        if (cmp != lead) {
            LeadUtil.leadParentImpl(cmp).repaint();
        }
    }

    public static void pointerDragged(Component cmp, int[] x, int[] y) {
        if (cmp == null) {
            return;
        }
        Component lead = LeadUtil.leadComponentImpl(cmp);
        lead.pointerDragged(x, y);
        if (cmp != lead) {
            LeadUtil.leadParentImpl(cmp).repaint();
        }
    }

    public static void pointerReleased(Component cmp, int x, int y) {
        if (cmp == null) {
            return;
        }
        Component lead = LeadUtil.leadComponentImpl(cmp);
        lead.pointerReleased(x, y);
        if (lead != cmp) {
            LeadUtil.leadParentImpl(cmp).repaint();
        }
    }

    public static void pointerHoverReleased(Component cmp, int[] x, int[] y) {
        if (cmp == null) {
            return;
        }
        LeadUtil.leadComponentImpl(cmp).pointerHoverReleased(x, y);
        if (LeadUtil.leadParentImpl(cmp) != cmp) {
            LeadUtil.leadParentImpl(cmp).repaint();
        }
    }

    public static void pointerHoverPressed(Component cmp, int[] x, int[] y) {
        if (cmp == null) {
            return;
        }
        Component lead = LeadUtil.leadComponentImpl(cmp);
        lead.pointerHoverPressed(x, y);
        if (lead != cmp) {
            LeadUtil.leadParentImpl(cmp).repaint();
        }
    }

    public static void pointerHover(Component cmp, int[] x, int[] y) {
        if (cmp == null) {
            return;
        }
        Component lead = LeadUtil.leadComponentImpl(cmp);
        lead.pointerHover(x, y);
        if (lead != cmp) {
            LeadUtil.leadParentImpl(cmp).repaint();
        }
    }

    public static void dragFinished(Component cmp, int x, int y) {
        if (cmp == null) {
            return;
        }
        Component lead = LeadUtil.leadComponentImpl(cmp);
        lead.dragFinishedImpl(x, y);
        if (lead != cmp) {
            LeadUtil.leadParentImpl(cmp).repaint();
        }
    }

    public static void longPointerPress(Component cmp, int x, int y) {
        if (cmp == null) {
            return;
        }
        Component lead = LeadUtil.leadComponentImpl(cmp);
        lead.longPointerPress(x, y);
        if (cmp != lead) {
            LeadUtil.leadParentImpl(cmp).repaint();
        }
    }

    public static void dragInitiated(Component cmp) {
        Component fc;
        if (cmp == null) {
            return;
        }
        Form f = cmp.getComponentForm();
        if (f != null && (fc = f.getFocused()) != null) {
            fc.dragInitiated();
        }
    }
}

