/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.geom;

import com.codename1.ui.Transform;
import com.codename1.ui.geom.Dimension;
import com.codename1.ui.geom.GeneralPath;
import com.codename1.ui.geom.PathIterator;
import com.codename1.ui.geom.Shape;
import java.util.ArrayList;

public class Rectangle
implements Shape {
    private int x;
    private int y;
    private final Dimension size;
    private GeneralPath path;
    private static final int MAX_POOL_SIZE = 20;
    private static ArrayList<Rectangle> pool;

    public static synchronized Rectangle createFromPool(int x, int y, int w, int h) {
        if (pool == null) {
            pool = new ArrayList();
        }
        if (pool.isEmpty()) {
            return new Rectangle(x, y, w, h);
        }
        Rectangle r = pool.remove(pool.size() - 1);
        r.setBounds(x, y, w, h);
        return r;
    }

    public static synchronized void recycle(Rectangle r) {
        if (pool.size() >= 20 || r == null) {
            return;
        }
        pool.add(r);
    }

    public Rectangle() {
        this.size = new Dimension();
    }

    public Rectangle(int x, int y, Dimension size) {
        this.x = x;
        this.y = y;
        this.size = size;
    }

    public Rectangle(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.size = new Dimension(w, h);
    }

    public Rectangle(Rectangle rect) {
        this(rect.getX(), rect.getY(), rect.getSize().getWidth(), rect.getSize().getHeight());
    }

    public void setBounds(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.size.setWidth(w);
        this.size.setHeight(h);
        this.path = null;
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.size.getWidth(), bounds.size.getHeight());
    }

    public int getWidth() {
        return this.size.getWidth();
    }

    public void setWidth(int w) {
        this.size.setWidth(w);
        this.path = null;
    }

    public void setHeight(int h) {
        this.size.setHeight(h);
        this.path = null;
    }

    public int getHeight() {
        return this.size.getHeight();
    }

    public Dimension getSize() {
        return this.size;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String toString() {
        return "x = " + this.x + " y = " + this.y + " size = " + this.size;
    }

    public void setX(int x) {
        this.x = x;
        this.path = null;
    }

    public void setY(int y) {
        this.y = y;
        this.path = null;
    }

    public boolean contains(Rectangle rect) {
        return this.contains(rect.x, rect.y, rect.size.getWidth(), rect.size.getHeight());
    }

    public boolean contains(int rX, int rY, int rWidth, int rHeight) {
        return this.x <= rX && this.y <= rY && this.x + this.size.getWidth() >= rX + rWidth && this.y + this.size.getHeight() >= rY + rHeight;
    }

    public static boolean contains(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x1 <= x2 && y1 <= y2 && x1 + w1 >= x2 + w2 && y1 + h1 >= y2 + h2;
    }

    public boolean contains(int rX, int rY) {
        return this.x <= rX && this.y <= rY && this.x + this.size.getWidth() >= rX && this.y + this.size.getHeight() >= rY;
    }

    public Rectangle intersection(int rX, int rY, int rW, int rH) {
        int tx1 = this.x;
        int ty1 = this.y;
        int rx1 = rX;
        int ry1 = rY;
        int tx2 = tx1;
        tx2 += this.size.getWidth();
        int ty2 = ty1;
        ty2 += this.size.getHeight();
        int rx2 = rx1;
        rx2 += rW;
        int ry2 = ry1;
        ry2 += rH;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= ty1;
        if ((tx2 -= tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        return new Rectangle(tx1, ty1, tx2, ty2);
    }

    public void intersection(Rectangle input, Rectangle output) {
        int tx1 = this.x;
        int ty1 = this.y;
        int rx1 = input.getX();
        int ry1 = input.getY();
        int tx2 = tx1;
        tx2 += this.size.getWidth();
        int ty2 = ty1;
        ty2 += this.size.getHeight();
        int rx2 = rx1;
        rx2 += input.getWidth();
        int ry2 = ry1;
        ry2 += input.getHeight();
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= ty1;
        if ((tx2 -= tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        tx2 = Math.max(0, tx2);
        ty2 = Math.max(0, ty2);
        output.setBounds(tx1, ty1, tx2, ty2);
    }

    public static void intersection(int rrX, int rrY, int rrW, int rrH, int rtx1, int rty1, int rtw2, int rth2, Rectangle dest) {
        int tx1 = rtx1;
        int ty1 = rty1;
        int rx1 = rrX;
        int ry1 = rrY;
        int tx2 = tx1;
        tx2 += rtw2;
        int ty2 = ty1;
        ty2 += rth2;
        int rx2 = rx1;
        rx2 += rrW;
        int ry2 = ry1;
        ry2 += rrH;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= ty1;
        if ((tx2 -= tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        dest.x = tx1;
        dest.y = ty1;
        dest.size.setWidth(tx2);
        dest.size.setHeight(ty2);
    }

    public Rectangle intersection(Rectangle r) {
        return this.intersection(r.x, r.y, r.size.getWidth(), r.size.getHeight());
    }

    public boolean intersects(int x, int y, int width, int height) {
        int tw = this.size.getWidth();
        int th = this.size.getHeight();
        return Rectangle.intersects(this.x, this.y, tw, th, x, y, width, height);
    }

    public boolean intersects(Rectangle rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getSize().getWidth(), rect.getSize().getHeight());
    }

    public static boolean intersects(int tx, int ty, int tw, int th, int x, int y, int width, int height) {
        int rw = width;
        int rh = height;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int rx = x;
        int ry = y;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    public PathIterator getPathIterator(Transform m) {
        if (this.path == null) {
            this.path = new GeneralPath();
            int w = this.size.getWidth();
            int h = this.size.getHeight();
            this.path.moveTo(this.x, this.y);
            this.path.lineTo(this.x + w, this.y);
            this.path.lineTo(this.x + w, this.y + h);
            this.path.lineTo(this.x, this.y + h);
            this.path.closePath();
        }
        return this.path.getPathIterator(m);
    }

    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    public Rectangle getBounds() {
        return this;
    }

    public float[] getBounds2D() {
        return new float[]{this.getX(), this.getY(), this.getWidth(), this.getHeight()};
    }

    public boolean isRectangle() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            Rectangle r = (Rectangle)obj;
            return r.x == this.x && r.y == this.y && r.size.equals(this.size);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + this.x;
        hash = 83 * hash + this.y;
        hash = 83 * hash + this.size.getWidth();
        hash = 83 * hash + this.size.getHeight();
        return hash;
    }
}

