/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.ui.Component;
import com.codename1.ui.List;
import com.codename1.ui.spinner.BaseSpinner;
import com.codename1.ui.spinner.DateTimeRenderer;
import com.codename1.ui.spinner.Spinner;
import com.codename1.ui.spinner.SpinnerNumberModel;
import com.codename1.ui.spinner.SpinnerRenderer;
import java.util.Calendar;
import java.util.Map;

public class DateSpinner
extends BaseSpinner {
    private Spinner month;
    private Spinner day;
    private Spinner year;
    private int startYear = 1970;
    private int endYear = 2100;
    private int currentYear;
    private int currentDay;
    private int currentMonth;
    private boolean monthDayYear = true;
    private boolean numericMonths = false;
    private String monthRenderingPrototype = "WWW";

    public DateSpinner() {
        Calendar c = Calendar.getInstance();
        this.currentDay = c.get(5);
        this.currentMonth = c.get(2) + 1;
        this.currentYear = c.get(1);
    }

    void initSpinner() {
        if (this.month == null) {
            this.day = Spinner.create(1, 32, this.currentDay, 1);
            this.month = Spinner.create(1, 13, this.currentMonth, 1);
            SpinnerRenderer<Object> render = new SpinnerRenderer<Object>(){

                @Override
                public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
                    if (value != null && value instanceof Integer) {
                        int d = (Integer)value;
                        if (DateSpinner.this.numericMonths) {
                            value = "" + d;
                        } else {
                            String o;
                            Map<String, String> t = this.getUIManager().getBundle();
                            String text = DateTimeRenderer.MONTHS[d - 1];
                            if (t != null && (o = t.get("Calendar." + text)) != null) {
                                text = o;
                            }
                            value = text;
                        }
                    }
                    return super.getListCellRendererComponent(list, value, index, isSelected);
                }
            };
            this.month.setRenderer(render);
            this.month.initSpinnerRenderer();
            this.month.setRenderingPrototype(this.monthRenderingPrototype);
            this.year = Spinner.create(this.startYear, this.endYear, this.currentYear, 1);
            this.addComponents();
        }
    }

    private void addComponents() {
        if (this.year != null) {
            if (this.monthDayYear) {
                this.addComponent(this.month);
                this.addComponent(this.createSeparator());
                this.addComponent(this.day);
                this.addComponent(this.createSeparator());
                this.addComponent(this.year);
            } else {
                this.addComponent(this.day);
                this.addComponent(this.createSeparator());
                this.addComponent(this.month);
                this.addComponent(this.createSeparator());
                this.addComponent(this.year);
            }
        }
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
        if (this.year != null) {
            this.year.setModel(new SpinnerNumberModel(startYear, this.endYear, this.currentYear, 1));
        }
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
        if (this.year != null) {
            this.year.setModel(new SpinnerNumberModel(this.startYear, endYear, this.currentYear, 1));
        }
    }

    public int getCurrentYear() {
        if (this.year != null) {
            return (Integer)this.year.getValue();
        }
        return this.currentYear;
    }

    public void setCurrentYear(int currentYear) {
        this.currentYear = currentYear;
        if (this.year != null) {
            this.year.setModel(new SpinnerNumberModel(this.startYear, this.endYear, currentYear, 1));
        }
    }

    public int getCurrentDay() {
        return (Integer)this.day.getValue();
    }

    public void setCurrentDay(int currentDay) {
        this.currentDay = currentDay;
        if (this.day != null) {
            this.day.setModel(new SpinnerNumberModel(1, 32, currentDay, 1));
        }
    }

    public int getCurrentMonth() {
        if (this.month != null) {
            return (Integer)this.month.getValue();
        }
        return this.currentMonth;
    }

    public void setCurrentMonth(int currentMonth) {
        this.currentMonth = currentMonth;
        if (this.month != null) {
            this.month.setModel(new SpinnerNumberModel(1, 13, currentMonth, 1));
        }
    }

    public boolean isMonthDayYear() {
        return this.monthDayYear;
    }

    public void setMonthDayYear(boolean monthDayYear) {
        this.monthDayYear = monthDayYear;
        this.removeAll();
        this.addComponents();
    }

    public boolean isNumericMonths() {
        return this.numericMonths;
    }

    public void setNumericMonths(boolean numericMonths) {
        this.numericMonths = numericMonths;
        if (this.month != null) {
            this.month.repaint();
        }
    }

    public String[] getPropertyNames() {
        return new String[]{"startYear", "endYear", "currentYear", "currentDay", "currentMonth", "monthDayYear", "numericMonths"};
    }

    public Class[] getPropertyTypes() {
        return new Class[]{Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class};
    }

    public Object getPropertyValue(String name) {
        if (name.equals("startYear")) {
            return new Integer(this.startYear);
        }
        if (name.equals("endYear")) {
            return new Integer(this.endYear);
        }
        if (name.equals("currentYear")) {
            return new Integer(this.currentYear);
        }
        if (name.equals("currentDay")) {
            return new Integer(this.currentDay);
        }
        if (name.equals("currentMonth")) {
            return new Integer(this.currentMonth);
        }
        if (name.equals("monthDayYear")) {
            return new Boolean(this.monthDayYear);
        }
        if (name.equals("numericMonths")) {
            return new Boolean(this.numericMonths);
        }
        return null;
    }

    public String setPropertyValue(String name, Object value) {
        if (name.equals("startYear")) {
            this.setStartYear(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("endYear")) {
            this.setEndYear(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("currentYear")) {
            this.setCurrentYear(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("currentDay")) {
            this.setCurrentDay(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("currentMonth")) {
            this.setCurrentMonth(Integer.parseInt(value.toString()));
            return null;
        }
        if (name.equals("monthDayYear")) {
            this.setMonthDayYear((Boolean)value);
            return null;
        }
        if (name.equals("numericMonths")) {
            this.setNumericMonths((Boolean)value);
            return null;
        }
        return super.setPropertyValue(name, value);
    }

    public void setMonthRenderingPrototype(String monthPrototype) {
        this.monthRenderingPrototype = monthPrototype;
    }
}

