/*
 * Decompiled with CFR 0.152.
 */
package com.codename1.ui.spinner;

import com.codename1.ui.Container;
import com.codename1.ui.Label;
import com.codename1.ui.layouts.BorderLayout;
import com.codename1.ui.layouts.BoxLayout;
import com.codename1.ui.layouts.LayeredLayout;
import com.codename1.ui.plaf.Style;
import com.codename1.ui.plaf.UIManager;
import com.codename1.ui.spinner.InternalPickerWidget;
import com.codename1.ui.spinner.Spinner3D;

class DurationSpinner3D
extends Container
implements InternalPickerWidget {
    public static final int FIELD_YEAR = 0;
    public static final int FIELD_MONTH = 1;
    public static final int FIELD_DAY = 2;
    public static final int FIELD_HOUR = 4;
    public static final int FIELD_MINUTE = 8;
    public static final int FIELD_SECOND = 16;
    public static final int FIELD_MILLISECOND = 32;
    private Spinner3D days;
    private Spinner3D hours;
    private Spinner3D minutes;
    private Spinner3D seconds;
    private Spinner3D milliseconds;
    private final boolean includeDays;
    private final boolean includeHours;
    private final boolean includeMinutes;
    private final boolean includeSeconds;
    private final boolean includeMilliseconds;

    public DurationSpinner3D(int fields) {
        this.includeDays = (fields & 2) != 0;
        this.includeHours = (fields & 4) != 0;
        this.includeMinutes = (fields & 8) != 0;
        this.includeSeconds = (fields & 0x10) != 0;
        this.includeMilliseconds = (fields & 0x20) != 0;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        Container wrapper = new Container(new LayeredLayout());
        Container box = new Container(BoxLayout.x());
        UIManager uim = UIManager.getInstance();
        Style s = null;
        if (this.includeDays) {
            this.days = Spinner3D.create(0, 1000, 0, 1);
            this.days.setPreferredW(new Label("000", "Spinner3DRow").getPreferredW());
            s = Style.createProxyStyle(this.days.getRowStyle(), this.days.getSelectedRowStyle());
            s.setAlignment(3);
            box.add(this.days);
            box.add(new Label(uim.localize("day", "day")));
        }
        if (this.includeHours) {
            this.hours = Spinner3D.create(0, this.includeDays ? 24 : 1000, 0, 1);
            this.hours.setPreferredW(new Label("000", "Spinner3DRow").getPreferredW());
            s = Style.createProxyStyle(this.hours.getRowStyle(), this.hours.getSelectedRowStyle());
            s.setAlignment(3);
            box.add(this.hours);
            box.add(new Label(uim.localize("hour", "hour")));
        }
        if (this.includeMinutes) {
            this.minutes = Spinner3D.create(0, this.includeHours ? 59 : 1000, 0, 1);
            this.minutes.setPreferredW(new Label("000", "Spinner3DRow").getPreferredW());
            s = Style.createProxyStyle(this.minutes.getRowStyle(), this.minutes.getSelectedRowStyle());
            s.setAlignment(3);
            box.add(this.minutes);
            box.add(new Label(uim.localize("min", "min")));
        }
        if (this.includeSeconds) {
            this.seconds = Spinner3D.create(0, this.includeMinutes ? 59 : 1000, 0, 1);
            this.seconds.setPreferredW(new Label("0000", "Spinner3DRow").getPreferredW());
            s = Style.createProxyStyle(this.seconds.getRowStyle(), this.seconds.getSelectedRowStyle());
            s.setAlignment(3);
            box.add(this.seconds);
            box.add(new Label(uim.localize("sec", "sec")));
        }
        if (this.includeMilliseconds) {
            this.milliseconds = Spinner3D.create(0, 1000, 0, 1);
            this.milliseconds.setPreferredW(new Label("0000", "Spinner3DRow").getPreferredW());
            s = Style.createProxyStyle(this.milliseconds.getRowStyle(), this.milliseconds.getSelectedRowStyle());
            s.setAlignment(3);
            box.add(this.milliseconds);
            box.add(new Label("ms", "ms"));
        }
        wrapper.add(box);
        LayeredLayout ll = (LayeredLayout)wrapper.getLayout();
        ll.setInsets(box, "0 auto 0 auto");
        this.add((Object)"Center", wrapper);
    }

    public void setValue(Object value) {
        long l = (Long)value;
        if (this.days != null) {
            long DAY = 86400000L;
            long numDays = l / DAY;
            this.days.setValue((int)numDays);
            l -= DAY * numDays;
        }
        if (this.hours != null) {
            long HOUR = 3600000L;
            long numHours = l / HOUR;
            this.hours.setValue((int)numHours);
            l -= HOUR * numHours;
        }
        if (this.minutes != null) {
            long MINUTE = 60000L;
            long numMinutes = l / MINUTE;
            this.minutes.setValue((int)numMinutes);
            l -= MINUTE * numMinutes;
        }
        if (this.seconds != null) {
            long SECOND = 1000L;
            long numSeconds = l / SECOND;
            this.seconds.setValue((int)numSeconds);
            l -= SECOND * numSeconds;
        }
        if (this.milliseconds != null) {
            this.milliseconds.setValue((int)l);
        }
    }

    public Object getValue() {
        long l = 0L;
        if (this.days != null) {
            long DAY = 86400000L;
            long numDays = ((Integer)this.days.getValue()).intValue();
            l += DAY * numDays;
        }
        if (this.hours != null) {
            long HOUR = 3600000L;
            long numHours = ((Integer)this.hours.getValue()).intValue();
            l += HOUR * numHours;
        }
        if (this.minutes != null) {
            long MINUTE = 60000L;
            long numMinutes = ((Integer)this.minutes.getValue()).intValue();
            l += MINUTE * numMinutes;
        }
        if (this.seconds != null) {
            long SECOND = 1000L;
            long numSeconds = ((Integer)this.seconds.getValue()).intValue();
            l += SECOND * numSeconds;
        }
        if (this.milliseconds != null) {
            l += (long)((Integer)this.milliseconds.getValue()).intValue();
        }
        return l;
    }
}

