/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.actions;

import com.consol.citrus.TestAction;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.ws.message.SoapFault;
import com.consol.citrus.ws.validation.SimpleSoapFaultValidator;
import com.consol.citrus.ws.validation.SoapFaultValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.client.SoapFaultClientException;

public class AssertSoapFault
extends AbstractActionContainer {
    private TestAction action;
    private String faultString = null;
    private String faultCode = null;
    private String faultActor = null;
    private List<String> faultDetails = new ArrayList<String>();
    private List<String> faultDetailResourcePaths = new ArrayList<String>();
    private SoapFaultValidator validator = new SimpleSoapFaultValidator();
    private ValidationContext validationContext;
    private static Logger log = LoggerFactory.getLogger(AssertSoapFault.class);

    public AssertSoapFault() {
        this.setName("soap-fault");
    }

    public void doExecute(TestContext context) {
        log.info("Asserting SOAP fault ...");
        try {
            this.action.execute(context);
        }
        catch (SoapFaultClientException soapFaultException) {
            log.info("Validating SOAP fault ...");
            SoapFault controlFault = this.constructControlFault(context);
            this.validator.validateSoapFault(SoapFault.from(soapFaultException.getSoapFault()), controlFault, context, this.validationContext);
            log.info("SOAP fault as expected: " + soapFaultException.getFaultCode() + ": " + soapFaultException.getFaultStringOrReason());
            log.info("SOAP fault validation successful");
            return;
        }
        catch (RuntimeException e) {
            throw new ValidationException("SOAP fault validation failed for asserted exception type - expected: '" + SoapFaultClientException.class + "' but was: '" + e.getClass().getName() + "'", (Throwable)e);
        }
        catch (Exception e) {
            throw new ValidationException("SOAP fault validation failed for asserted exception type - expected: '" + SoapFaultClientException.class + "' but was: '" + e.getClass().getName() + "'", (Throwable)e);
        }
        throw new ValidationException("SOAP fault validation failed! Missing asserted SOAP fault exception");
    }

    private SoapFault constructControlFault(TestContext context) {
        SoapFault controlFault = new SoapFault();
        if (StringUtils.hasText((String)this.faultActor)) {
            controlFault.faultActor(context.replaceDynamicContentInString(this.faultActor));
        }
        controlFault.faultCode(context.replaceDynamicContentInString(this.faultCode));
        controlFault.faultString(context.replaceDynamicContentInString(this.faultString));
        for (String faultDetail : this.faultDetails) {
            controlFault.addFaultDetail(context.replaceDynamicContentInString(faultDetail));
        }
        try {
            for (String faultDetailPath : this.faultDetailResourcePaths) {
                String resourcePath = context.replaceDynamicContentInString(faultDetailPath);
                controlFault.addFaultDetail(context.replaceDynamicContentInString(FileUtils.readToString((Resource)FileUtils.getFileResource((String)resourcePath, (TestContext)context))));
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create SOAP fault detail from file resource", (Throwable)e);
        }
        return controlFault;
    }

    public AssertSoapFault setAction(TestAction action) {
        this.addTestAction(action);
        return this;
    }

    public AssertSoapFault setFaultCode(String faultCode) {
        this.faultCode = faultCode;
        return this;
    }

    public AssertSoapFault setFaultString(String faultString) {
        this.faultString = faultString;
        return this;
    }

    public AssertSoapFault setValidator(SoapFaultValidator validator) {
        this.validator = validator;
        return this;
    }

    public AssertSoapFault addTestAction(TestAction action) {
        this.action = action;
        super.addTestAction(action);
        return this;
    }

    public TestAction getTestAction(int index) {
        if (index == 0) {
            return this.action;
        }
        throw new IndexOutOfBoundsException("Illegal index in action list:" + index);
    }

    public AssertSoapFault setActions(List<TestAction> actions) {
        if (actions.size() > 1) {
            throw new CitrusRuntimeException("Invalid number of nested test actions - only one single nested action is allowed");
        }
        this.action = actions.get(0);
        super.setActions(actions);
        return this;
    }

    public TestAction getAction() {
        return this.action;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public List<String> getFaultDetails() {
        return this.faultDetails;
    }

    public AssertSoapFault setFaultDetails(List<String> faultDetails) {
        this.faultDetails = faultDetails;
        return this;
    }

    public List<String> getFaultDetailResourcePaths() {
        return this.faultDetailResourcePaths;
    }

    public AssertSoapFault setFaultDetailResourcePaths(List<String> faultDetailResourcePaths) {
        this.faultDetailResourcePaths = faultDetailResourcePaths;
        return this;
    }

    public SoapFaultValidator getValidator() {
        return this.validator;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public AssertSoapFault setFaultActor(String faultActor) {
        this.faultActor = faultActor;
        return this;
    }

    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    public AssertSoapFault setValidationContext(ValidationContext validationContext) {
        this.validationContext = validationContext;
        return this;
    }
}

