/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.actions;

import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.message.SoapMessage;
import com.consol.citrus.ws.validation.SimpleSoapAttachmentValidator;
import com.consol.citrus.ws.validation.SoapAttachmentValidator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ReceiveSoapMessageAction
extends ReceiveMessageAction {
    private List<SoapAttachment> attachments = new ArrayList<SoapAttachment>();
    private SoapAttachmentValidator attachmentValidator = new SimpleSoapAttachmentValidator();

    public ReceiveSoapMessageAction() {
        this.setName("receive");
    }

    protected void validateMessage(Message receivedMessage, TestContext context) {
        try {
            super.validateMessage(receivedMessage, context);
            if (!this.attachments.isEmpty() && !(receivedMessage instanceof SoapMessage)) {
                throw new CitrusRuntimeException(String.format("Unable to perform SOAP attachment validation on message type '%s'", receivedMessage.getClass()));
            }
            for (SoapAttachment attachment : this.attachments) {
                attachment.resolveDynamicContent(context);
            }
            if (!this.attachments.isEmpty()) {
                this.attachmentValidator.validateAttachment((SoapMessage)receivedMessage, this.attachments);
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    public List<SoapAttachment> getAttachments() {
        return this.attachments;
    }

    public ReceiveSoapMessageAction setAttachments(List<SoapAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public ReceiveSoapMessageAction setAttachmentValidator(SoapAttachmentValidator attachmentValidator) {
        this.attachmentValidator = attachmentValidator;
        return this;
    }

    public SoapAttachmentValidator getAttachmentValidator() {
        return this.attachmentValidator;
    }
}

