/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.actions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.ws.actions.SendSoapMessageAction;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.message.SoapFault;
import com.consol.citrus.ws.message.SoapMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class SendSoapFaultAction
extends SendSoapMessageAction {
    private String faultCode;
    private String faultString;
    private String faultActor;
    private List<String> faultDetails = new ArrayList<String>();
    private List<String> faultDetailResourcePaths = new ArrayList<String>();

    @Override
    protected SoapMessage createMessage(TestContext context, String messageType) {
        SoapMessage soapMessage = super.createMessage(context, messageType);
        SoapFault soapFault = new SoapFault();
        soapFault.setPayload(soapMessage.getPayload());
        if (!StringUtils.hasText((String)this.faultCode)) {
            throw new CitrusRuntimeException("Missing fault code definition for SOAP fault generation. Please specify a proper SOAP fault code!");
        }
        soapFault.faultCode(context.replaceDynamicContentInString(this.faultCode));
        for (Map.Entry header : soapMessage.copyHeaders().entrySet()) {
            if (((String)header.getKey()).equals("citrus_message_id")) continue;
            soapFault.setHeader((String)header.getKey(), header.getValue());
        }
        for (String headerData : soapMessage.getHeaderData()) {
            soapFault.addHeaderData(headerData);
        }
        for (SoapAttachment soapAttachment : soapMessage.getAttachments()) {
            soapFault.addAttachment(soapAttachment);
        }
        if (StringUtils.hasText((String)this.faultActor)) {
            soapFault.faultActor(context.replaceDynamicContentInString(this.faultActor));
        }
        if (this.faultString != null) {
            soapFault.faultString(context.replaceDynamicContentInString(this.faultString));
        }
        for (String faultDetail : this.faultDetails) {
            soapFault.addFaultDetail(context.replaceDynamicContentInString(faultDetail));
        }
        try {
            for (String faultDetailPath : this.faultDetailResourcePaths) {
                String resourcePath = context.replaceDynamicContentInString(faultDetailPath);
                soapFault.addFaultDetail(context.replaceDynamicContentInString(FileUtils.readToString((Resource)FileUtils.getFileResource((String)resourcePath, (TestContext)context))));
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create SOAP fault detail from file resource", (Throwable)e);
        }
        return soapFault;
    }

    public SendSoapFaultAction setFaultCode(String faultCode) {
        this.faultCode = faultCode;
        return this;
    }

    public SendSoapFaultAction setFaultString(String faultString) {
        this.faultString = faultString;
        return this;
    }

    public SendSoapFaultAction setFaultActor(String faultActor) {
        this.faultActor = faultActor;
        return this;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public List<String> getFaultDetails() {
        return this.faultDetails;
    }

    public SendSoapFaultAction setFaultDetails(List<String> faultDetails) {
        this.faultDetails = faultDetails;
        return this;
    }

    public List<String> getFaultDetailResourcePaths() {
        return this.faultDetailResourcePaths;
    }

    public SendSoapFaultAction setFaultDetailResourcePaths(List<String> faultDetailResourcePaths) {
        this.faultDetailResourcePaths = faultDetailResourcePaths;
        return this;
    }
}

