/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.AbstractEndpointParser;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.message.ErrorHandlingStrategy;
import com.consol.citrus.ws.client.WebServiceClient;
import com.consol.citrus.ws.client.WebServiceEndpointConfiguration;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class WebServiceClientParser
extends AbstractEndpointParser {
    public static final String MESSAGE_SENDER_ATTRIBUTE = "message-sender";
    public static final String MESSAGE_SENDERS_ATTRIBUTE = "message-senders";
    public static final String REQUEST_URL_ATTRIBUTE = "request-url";

    protected void parseEndpointConfiguration(BeanDefinitionBuilder endpointConfiguration, Element element, ParserContext parserContext) {
        super.parseEndpointConfiguration(endpointConfiguration, element, parserContext);
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute(REQUEST_URL_ATTRIBUTE), (String)"defaultUri");
        if (element.hasAttribute("web-service-template") && (element.hasAttribute("message-factory") || element.hasAttribute(MESSAGE_SENDER_ATTRIBUTE) || element.hasAttribute(MESSAGE_SENDERS_ATTRIBUTE))) {
            parserContext.getReaderContext().error("When providing a 'web-service-template' reference, none of 'message-factory', 'message-sender', or 'message-senders' should be set.", (Object)element);
        }
        if (!element.hasAttribute(REQUEST_URL_ATTRIBUTE) && !element.hasAttribute("endpoint-resolver")) {
            parserContext.getReaderContext().error(String.format("One of the properties '%s' or '%s' is required!", REQUEST_URL_ATTRIBUTE, "endpoint-resolver"), (Object)element);
        }
        if (element.hasAttribute(MESSAGE_SENDER_ATTRIBUTE) && element.hasAttribute(MESSAGE_SENDERS_ATTRIBUTE)) {
            parserContext.getReaderContext().error(String.format("When '%s' is set, no '%s' attribute should be provided.", MESSAGE_SENDER_ATTRIBUTE, MESSAGE_SENDERS_ATTRIBUTE), (Object)element);
        }
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("web-service-template"), (String)"webServiceTemplate");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("message-factory"), (String)"messageFactory", (String)"messageFactory");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute(MESSAGE_SENDER_ATTRIBUTE), (String)"messageSender");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute(MESSAGE_SENDERS_ATTRIBUTE), (String)"messageSenders");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("message-converter"), (String)"messageConverter");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("interceptors"), (String)"interceptors");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("interceptor"), (String)"interceptor");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("message-correlator"), (String)"correlator");
        BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("endpoint-resolver"), (String)"endpointResolver");
        if (element.hasAttribute("fault-strategy")) {
            endpointConfiguration.addPropertyValue("errorHandlingStrategy", (Object)ErrorHandlingStrategy.fromName((String)element.getAttribute("fault-strategy")));
        }
        BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)endpointConfiguration, (String)element.getAttribute("polling-interval"), (String)"pollingInterval");
    }

    protected Class<? extends Endpoint> getEndpointClass() {
        return WebServiceClient.class;
    }

    protected Class<? extends EndpointConfiguration> getEndpointConfigurationClass() {
        return WebServiceEndpointConfiguration.class;
    }
}

