/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.springframework.ws.mime.Attachment;

public class SoapAttachment
implements Attachment,
Serializable {
    private static final long serialVersionUID = 6277464458242523954L;
    public static final String ENCODING_BASE64_BINARY = "base64Binary";
    public static final String ENCODING_HEX_BINARY = "hexBinary";
    private String content = null;
    private String contentResourcePath;
    private String contentType = "text/plain";
    private String contentId = null;
    private String charsetName = "UTF-8";
    private boolean mtomInline = false;
    private DataHandler dataHandler = null;
    private String encodingType = "base64Binary";

    public SoapAttachment() {
    }

    public static SoapAttachment from(Attachment attachment) {
        SoapAttachment soapAttachment = new SoapAttachment();
        soapAttachment.setContentId(attachment.getContentId());
        soapAttachment.setContentType(attachment.getContentType());
        if (attachment.getContentType().startsWith("text")) {
            try {
                soapAttachment.setContent(FileUtils.readToString((InputStream)attachment.getInputStream()).trim());
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read SOAP attachment content", (Throwable)e);
            }
        } else {
            soapAttachment.setDataHandler(attachment.getDataHandler());
        }
        soapAttachment.setCharsetName(System.getProperty("citrus.file.encoding", Charset.defaultCharset().displayName()));
        return soapAttachment;
    }

    public SoapAttachment(String content) {
        this.content = content;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public DataHandler getDataHandler() {
        if (this.dataHandler == null) {
            this.dataHandler = StringUtils.hasText((String)this.contentResourcePath) ? new DataHandler((DataSource)new FileResourceDataSource()) : new DataHandler((DataSource)new ContentDataSource());
        }
        return this.dataHandler;
    }

    public void setDataHandler(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    public InputStream getInputStream() throws IOException {
        return this.getDataHandler().getInputStream();
    }

    public long getSize() {
        try {
            if (this.content != null) {
                return this.content.getBytes(this.charsetName).length;
            }
            return SoapAttachment.getSizeOfContent(this.getDataHandler().getInputStream());
        }
        catch (UnsupportedEncodingException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        catch (IOException ioe) {
            throw new CitrusRuntimeException((Throwable)ioe);
        }
    }

    public String toString() {
        return String.format("%s [contentId: %s, contentType: %s, content: %s]", this.getClass().getSimpleName().toUpperCase(), this.contentId, this.contentType, this.getContent());
    }

    public String getContent() {
        if (StringUtils.hasText((String)this.content)) {
            return this.content;
        }
        if (StringUtils.hasText((String)this.contentResourcePath) && this.contentType.startsWith("text")) {
            try {
                return FileUtils.readToString((InputStream)new PathMatchingResourcePatternResolver().getResource(this.contentResourcePath).getInputStream(), (Charset)Charset.forName(this.charsetName));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read SOAP attachment file resource", (Throwable)e);
            }
        }
        try {
            byte[] binaryData = FileUtils.readToString((InputStream)this.getDataHandler().getInputStream(), (Charset)Charset.forName(this.charsetName)).getBytes(Charset.forName(this.charsetName));
            if (this.encodingType.equals(ENCODING_BASE64_BINARY)) {
                return Base64.encodeBase64String((byte[])binaryData);
            }
            if (this.encodingType.equals(ENCODING_HEX_BINARY)) {
                return Hex.encodeHexString((byte[])binaryData).toUpperCase();
            }
            throw new CitrusRuntimeException(String.format("Unsupported encoding type '%s' for SOAP attachment - choose one of %s or %s", this.encodingType, ENCODING_BASE64_BINARY, ENCODING_HEX_BINARY));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read SOAP attachment data input stream", (Throwable)e);
        }
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentResourcePath() {
        return this.contentResourcePath;
    }

    public void setContentResourcePath(String path) {
        this.contentResourcePath = path;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setMtomInline(boolean inline) {
        this.mtomInline = inline;
    }

    public boolean isMtomInline() {
        return this.mtomInline;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public void resolveDynamicContent(TestContext context) {
        if (this.contentId != null) {
            this.contentId = context.replaceDynamicContentInString(this.contentId);
        }
        if (this.contentType != null) {
            this.contentType = context.replaceDynamicContentInString(this.contentType);
        }
        if (StringUtils.hasText((String)this.content)) {
            this.content = context.replaceDynamicContentInString(this.content);
        } else if (this.contentResourcePath != null) {
            this.contentResourcePath = context.replaceDynamicContentInString(this.contentResourcePath);
            if (this.contentType.startsWith("text")) {
                try {
                    this.content = context.replaceDynamicContentInString(FileUtils.readToString((InputStream)new PathMatchingResourcePatternResolver().getResource(this.contentResourcePath).getInputStream(), (Charset)Charset.forName(this.charsetName)));
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to read SOAP attachment file resource", (Throwable)e);
                }
            }
        }
    }

    private static long getSizeOfContent(InputStream is) throws IOException {
        long size = 0L;
        while (is.read() != -1) {
            ++size;
        }
        return size;
    }

    private class FileResourceDataSource
    implements DataSource {
        private FileResourceDataSource() {
        }

        public InputStream getInputStream() throws IOException {
            return this.getFileResource().getInputStream();
        }

        public String getContentType() {
            return SoapAttachment.this.contentType;
        }

        public String getName() {
            return this.getFileResource().getFilename();
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        private Resource getFileResource() {
            return new PathMatchingResourcePatternResolver().getResource(SoapAttachment.this.contentResourcePath);
        }
    }

    private class ContentDataSource
    implements DataSource {
        private ContentDataSource() {
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(SoapAttachment.this.content.getBytes(SoapAttachment.this.charsetName));
        }

        public String getContentType() {
            return SoapAttachment.this.contentType;
        }

        public String getName() {
            return SoapAttachment.this.contentId;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

