/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.message.converter;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageHeaderUtils;
import com.consol.citrus.ws.client.WebServiceEndpointConfiguration;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.message.SoapMessage;
import com.consol.citrus.ws.message.converter.WebServiceMessageConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamSource;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.mime.Attachment;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.axiom.AxiomSoapMessage;
import org.springframework.ws.soap.saaj.SaajSoapMessage;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.context.TransportContext;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.ws.transport.http.HttpServletConnection;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SoapMessageConverter
implements WebServiceMessageConverter {
    private static Logger log = LoggerFactory.getLogger(SoapMessageConverter.class);

    public WebServiceMessage convertOutbound(Message internalMessage, WebServiceEndpointConfiguration endpointConfiguration) {
        WebServiceMessage message = endpointConfiguration.getMessageFactory().createWebServiceMessage();
        this.convertOutbound(message, internalMessage, endpointConfiguration);
        return message;
    }

    public void convertOutbound(WebServiceMessage webServiceMessage, Message message, WebServiceEndpointConfiguration endpointConfiguration) {
        org.springframework.ws.soap.SoapMessage soapRequest = (org.springframework.ws.soap.SoapMessage)webServiceMessage;
        SoapMessage soapMessage = message instanceof SoapMessage ? (SoapMessage)message : new SoapMessage(message);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform((Source)new StringSource((String)soapMessage.getPayload(String.class)), soapRequest.getSoapBody().getPayloadResult());
        }
        catch (TransformerException e) {
            throw new CitrusRuntimeException("Failed to write SOAP body payload", (Throwable)e);
        }
        for (Map.Entry entry : soapMessage.copyHeaders().entrySet()) {
            if (MessageHeaderUtils.isSpringInternalHeader((String)((String)entry.getKey()))) continue;
            if (((String)entry.getKey()).equalsIgnoreCase("citrus_soap_action")) {
                soapRequest.setSoapAction(entry.getValue().toString());
                continue;
            }
            if (((String)entry.getKey()).toLowerCase().startsWith("citrus_http_")) {
                this.handleOutboundMimeMessageHeader(soapRequest, ((String)entry.getKey()).substring("citrus_http_".length()), entry.getValue(), endpointConfiguration.isHandleMimeHeaders());
                continue;
            }
            if (((String)entry.getKey()).startsWith("citrus_")) continue;
            SoapHeaderElement headerElement = QNameUtils.validateQName((String)((String)entry.getKey())) ? soapRequest.getSoapHeader().addHeaderElement(QNameUtils.parseQNameString((String)((String)entry.getKey()))) : soapRequest.getSoapHeader().addHeaderElement(QNameUtils.createQName((String)"", (String)((String)entry.getKey()), (String)""));
            headerElement.setText(entry.getValue().toString());
        }
        for (String string : soapMessage.getHeaderData()) {
            try {
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform((Source)new StringSource(string), soapRequest.getSoapHeader().getResult());
            }
            catch (TransformerException e) {
                throw new CitrusRuntimeException("Failed to write SOAP header content", (Throwable)e);
            }
        }
        if (soapMessage.isMtomEnabled() && soapMessage.getAttachments().size() > 0) {
            log.debug("Converting SOAP request to XOP package");
            soapRequest.convertToXopPackage();
        }
        for (final Attachment attachment : soapMessage.getAttachments()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Adding attachment to SOAP message: '%s' ('%s')", attachment.getContentId(), attachment.getContentType()));
            }
            soapRequest.addAttachment(attachment.getContentId(), new InputStreamSource(){

                public InputStream getInputStream() throws IOException {
                    return attachment.getInputStream();
                }
            }, attachment.getContentType());
        }
    }

    public SoapMessage convertInbound(WebServiceMessage message, WebServiceEndpointConfiguration endpointConfiguration) {
        return this.convertInbound(message, null, endpointConfiguration);
    }

    public SoapMessage convertInbound(WebServiceMessage webServiceMessage, MessageContext messageContext, WebServiceEndpointConfiguration endpointConfiguration) {
        try {
            String payload = "";
            if (endpointConfiguration.isKeepSoapEnvelope()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                webServiceMessage.writeTo((OutputStream)bos);
                payload = bos.toString();
            } else if (webServiceMessage.getPayloadSource() != null) {
                StringResult payloadResult = new StringResult();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.transform(webServiceMessage.getPayloadSource(), (Result)payloadResult);
                payload = payloadResult.toString();
            }
            SoapMessage message = new SoapMessage(payload);
            this.handleInboundMessageProperties(messageContext, message);
            if (webServiceMessage instanceof org.springframework.ws.soap.SoapMessage) {
                this.handleInboundSoapMessage((org.springframework.ws.soap.SoapMessage)webServiceMessage, message, endpointConfiguration);
            }
            this.handleInboundHttpHeaders(message);
            return message;
        }
        catch (TransformerException e) {
            throw new CitrusRuntimeException("Failed to read web service message payload source", (Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read web service message", (Throwable)e);
        }
    }

    protected void handleInboundSoapMessage(org.springframework.ws.soap.SoapMessage soapMessage, SoapMessage message, WebServiceEndpointConfiguration endpointConfiguration) {
        this.handleInboundNamespaces(soapMessage, message);
        this.handleInboundSoapHeaders(soapMessage, message);
        this.handleInboundAttachments(soapMessage, message);
        if (endpointConfiguration.isHandleMimeHeaders()) {
            this.handleInboundMimeHeaders(soapMessage, message);
        }
    }

    private void handleInboundNamespaces(org.springframework.ws.soap.SoapMessage soapMessage, SoapMessage message) {
        Source envelopeSource = soapMessage.getEnvelope().getSource();
        if (envelopeSource != null && envelopeSource instanceof DOMSource) {
            Node envelopeNode = ((DOMSource)envelopeSource).getNode();
            NamedNodeMap attributes = envelopeNode.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String namespace;
                int xmlProcessingInstruction;
                int rootElementEnd;
                String messagePayload;
                Node attribute = attributes.item(i);
                if (!StringUtils.hasText((String)attribute.getNamespaceURI()) || !attribute.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/") || !StringUtils.hasText((String)attribute.getNodeValue()) || attribute.getNodeValue().equals(envelopeNode.getNamespaceURI()) || !StringUtils.hasText((String)(messagePayload = (String)message.getPayload(String.class))) || (rootElementEnd = messagePayload.indexOf(62, xmlProcessingInstruction = (xmlProcessingInstruction = messagePayload.indexOf("?>")) > 0 ? xmlProcessingInstruction + 2 : 0)) <= 0) continue;
                if (messagePayload.charAt(rootElementEnd - 1) == '/') {
                    --rootElementEnd;
                }
                if (messagePayload.contains(namespace = attribute.getNodeName() + "=\"" + attribute.getNodeValue() + "\"")) continue;
                message.setPayload(messagePayload.substring(0, rootElementEnd) + " " + namespace + messagePayload.substring(rootElementEnd));
            }
        }
    }

    protected void handleInboundHttpHeaders(SoapMessage message) {
        TransportContext transportContext = TransportContextHolder.getTransportContext();
        if (transportContext == null) {
            log.warn("Unable to get complete set of http request headers - no transport context available");
            return;
        }
        WebServiceConnection connection = transportContext.getConnection();
        if (connection instanceof HttpServletConnection) {
            UrlPathHelper pathHelper = new UrlPathHelper();
            HttpServletConnection servletConnection = (HttpServletConnection)connection;
            message.setHeader("citrus_http_request_uri", pathHelper.getRequestUri(servletConnection.getHttpServletRequest()));
            message.setHeader("citrus_http_context_path", pathHelper.getContextPath(servletConnection.getHttpServletRequest()));
            String queryParams = pathHelper.getOriginatingQueryString(servletConnection.getHttpServletRequest());
            message.setHeader("citrus_http_query_params", queryParams != null ? queryParams : "");
            message.setHeader("citrus_http_method", servletConnection.getHttpServletRequest().getMethod().toString());
        } else {
            log.warn("Unable to get complete set of http request headers");
            try {
                message.setHeader("citrus_http_request_uri", connection.getUri());
            }
            catch (URISyntaxException e) {
                log.warn("Unable to get http request uri from http connection", (Throwable)e);
            }
        }
    }

    protected void handleInboundSoapHeaders(org.springframework.ws.soap.SoapMessage soapMessage, SoapMessage message) {
        try {
            SoapHeader soapHeader = soapMessage.getSoapHeader();
            if (soapHeader != null) {
                Iterator iter = soapHeader.examineAllHeaderElements();
                while (iter.hasNext()) {
                    SoapHeaderElement headerEntry = (SoapHeaderElement)iter.next();
                    MessageHeaderUtils.setHeader((Message)message, (String)headerEntry.getName().getLocalPart(), (String)headerEntry.getText());
                }
                if (soapHeader.getSource() != null) {
                    StringResult headerData = new StringResult();
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.transform(soapHeader.getSource(), (Result)headerData);
                    message.addHeaderData(headerData.toString());
                }
            }
            if (StringUtils.hasText((String)soapMessage.getSoapAction())) {
                if (soapMessage.getSoapAction().equals("\"\"")) {
                    message.setHeader("citrus_soap_action", "");
                } else if (soapMessage.getSoapAction().startsWith("\"") && soapMessage.getSoapAction().endsWith("\"")) {
                    message.setHeader("citrus_soap_action", soapMessage.getSoapAction().substring(1, soapMessage.getSoapAction().length() - 1));
                } else {
                    message.setHeader("citrus_soap_action", soapMessage.getSoapAction());
                }
            }
        }
        catch (TransformerException e) {
            throw new CitrusRuntimeException("Failed to read SOAP header source", (Throwable)e);
        }
    }

    private void handleOutboundMimeMessageHeader(org.springframework.ws.soap.SoapMessage message, String name, Object value, boolean handleMimeHeaders) {
        if (!handleMimeHeaders) {
            return;
        }
        if (message instanceof SaajSoapMessage) {
            SaajSoapMessage soapMsg = (SaajSoapMessage)message;
            MimeHeaders headers = soapMsg.getSaajMessage().getMimeHeaders();
            headers.setHeader(name, value.toString());
        } else if (message instanceof AxiomSoapMessage) {
            log.warn("Unable to set mime message header '" + name + "' on AxiomSoapMessage - unsupported");
        } else {
            log.warn("Unsupported SOAP message implementation - unable to set mime message header '" + name + "'");
        }
    }

    protected void handleInboundMimeHeaders(org.springframework.ws.soap.SoapMessage soapMessage, SoapMessage message) {
        HashMap<String, String> mimeHeaders = new HashMap<String, String>();
        MimeHeaders messageMimeHeaders = null;
        if (soapMessage instanceof SaajSoapMessage) {
            messageMimeHeaders = ((SaajSoapMessage)soapMessage).getSaajMessage().getMimeHeaders();
        } else if (soapMessage instanceof AxiomSoapMessage) {
            log.warn("Skip mime headers for AxiomSoapMessage - unsupported");
        } else {
            log.warn("Unsupported SOAP message implementation - skipping mime headers");
        }
        if (messageMimeHeaders != null) {
            Iterator mimeHeaderIterator = messageMimeHeaders.getAllHeaders();
            while (mimeHeaderIterator.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)mimeHeaderIterator.next();
                if (mimeHeaders.containsKey(mimeHeader.getName())) {
                    String value = (String)mimeHeaders.get(mimeHeader.getName());
                    value = value + ", " + mimeHeader.getValue();
                    mimeHeaders.put(mimeHeader.getName(), value);
                    continue;
                }
                mimeHeaders.put(mimeHeader.getName(), mimeHeader.getValue());
            }
            for (Map.Entry httpHeaderEntry : mimeHeaders.entrySet()) {
                message.setHeader((String)httpHeaderEntry.getKey(), httpHeaderEntry.getValue());
            }
        }
    }

    protected void handleInboundMessageProperties(MessageContext messageContext, SoapMessage message) {
        if (messageContext == null) {
            return;
        }
        String[] propertyNames = messageContext.getPropertyNames();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                message.setHeader(propertyName, messageContext.getProperty(propertyName));
            }
        }
    }

    protected void handleInboundAttachments(org.springframework.ws.soap.SoapMessage soapMessage, SoapMessage message) {
        Iterator attachments = soapMessage.getAttachments();
        while (attachments.hasNext()) {
            Attachment attachment = (Attachment)attachments.next();
            SoapAttachment soapAttachment = SoapAttachment.from(attachment);
            if (log.isDebugEnabled()) {
                log.debug(String.format("SOAP message contains attachment with contentId '%s'", attachment.getContentId()));
            }
            message.addAttachment(soapAttachment);
        }
    }
}

