/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.message.converter;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.ws.addressing.WsAddressingHeaders;
import com.consol.citrus.ws.addressing.WsAddressingVersion;
import com.consol.citrus.ws.client.WebServiceEndpointConfiguration;
import com.consol.citrus.ws.message.converter.SoapMessageConverter;
import java.net.URI;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.addressing.core.MessageAddressingProperties;
import org.springframework.ws.soap.addressing.messageid.MessageIdStrategy;
import org.springframework.ws.soap.addressing.messageid.UuidMessageIdStrategy;
import org.springframework.ws.soap.addressing.version.Addressing10;
import org.springframework.ws.soap.addressing.version.Addressing200408;

public class WsAddressingMessageConverter
extends SoapMessageConverter {
    private final WsAddressingHeaders addressingHeaders;
    private MessageIdStrategy messageIdStrategy = new UuidMessageIdStrategy();

    public WsAddressingMessageConverter(WsAddressingHeaders addressingHeaders) {
        this.addressingHeaders = addressingHeaders;
    }

    @Override
    public void convertOutbound(WebServiceMessage webServiceMessage, Message message, WebServiceEndpointConfiguration endpointConfiguration) {
        Addressing10 version;
        super.convertOutbound(webServiceMessage, message, endpointConfiguration);
        SoapMessage soapMessage = (SoapMessage)webServiceMessage;
        URI messageId = this.addressingHeaders.getMessageId() != null ? this.addressingHeaders.getMessageId() : this.messageIdStrategy.newMessageId(soapMessage);
        MessageAddressingProperties map = new MessageAddressingProperties(this.addressingHeaders.getTo(), this.addressingHeaders.getFrom(), this.addressingHeaders.getReplyTo(), this.addressingHeaders.getFaultTo(), this.addressingHeaders.getAction(), messageId);
        if (WsAddressingVersion.VERSION10.equals((Object)this.addressingHeaders.getVersion())) {
            version = new Addressing10();
        } else if (WsAddressingVersion.VERSION200408.equals((Object)this.addressingHeaders.getVersion())) {
            version = new Addressing200408();
        } else {
            throw new CitrusRuntimeException("Unsupported ws addressing version '" + (Object)((Object)this.addressingHeaders.getVersion()) + "'");
        }
        version.addAddressingHeaders(soapMessage, map);
    }

    public MessageIdStrategy getMessageIdStrategy() {
        return this.messageIdStrategy;
    }

    public void setMessageIdStrategy(MessageIdStrategy messageIdStrategy) {
        this.messageIdStrategy = messageIdStrategy;
    }

    public WsAddressingHeaders getAddressingHeaders() {
        return this.addressingHeaders;
    }
}

