/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.validation;

import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.message.SoapMessage;
import com.consol.citrus.ws.validation.SoapAttachmentValidator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.mime.Attachment;

public abstract class AbstractSoapAttachmentValidator
implements SoapAttachmentValidator {
    private static Logger log = LoggerFactory.getLogger(AbstractSoapAttachmentValidator.class);

    @Override
    public void validateAttachment(SoapMessage soapMessage, List<SoapAttachment> controlAttachments) {
        log.info("Validating SOAP attachments ...");
        for (SoapAttachment controlAttachment : controlAttachments) {
            SoapAttachment attachment = this.findAttachment(soapMessage, controlAttachment);
            if (log.isDebugEnabled()) {
                log.debug("Found attachment with contentId '" + controlAttachment.getContentId() + "'");
            }
            this.validateAttachmentContentId(attachment, controlAttachment);
            this.validateAttachmentContentType(attachment, controlAttachment);
            this.validateAttachmentContent(attachment, controlAttachment);
            log.info("Validation of SOAP attachment finished successfully: All values OK");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SoapAttachment findAttachment(SoapMessage soapMessage, SoapAttachment controlAttachment) {
        List<SoapAttachment> attachments = soapMessage.getAttachments();
        Attachment matching = null;
        if (controlAttachment.getContentId() == null) {
            if (attachments.size() != 1) throw new ValidationException("Found more than one SOAP attachment - need control attachment content id for validation!");
            matching = attachments.get(0);
        } else {
            for (Attachment attachment : attachments) {
                if (controlAttachment.getContentId() == null || !controlAttachment.getContentId().equals(attachment.getContentId())) continue;
                matching = attachment;
            }
        }
        if (matching == null) throw new ValidationException(String.format("Unable to find SOAP attachment with content id '%s'", controlAttachment.getContentId()));
        return SoapAttachment.from(matching);
    }

    protected void validateAttachmentContentId(SoapAttachment receivedAttachment, SoapAttachment controlAttachment) {
        if (!StringUtils.hasText((String)controlAttachment.getContentId())) {
            return;
        }
        if (receivedAttachment.getContentId() != null) {
            Assert.isTrue((controlAttachment.getContentId() != null ? 1 : 0) != 0, (String)this.buildValidationErrorMessage("Values not equal for attachment contentId", null, receivedAttachment.getContentId()));
            Assert.isTrue((boolean)receivedAttachment.getContentId().equals(controlAttachment.getContentId()), (String)this.buildValidationErrorMessage("Values not equal for attachment contentId", controlAttachment.getContentId(), receivedAttachment.getContentId()));
        } else {
            Assert.isTrue((controlAttachment.getContentId() == null || controlAttachment.getContentId().length() == 0 ? 1 : 0) != 0, (String)this.buildValidationErrorMessage("Values not equal for attachment contentId", controlAttachment.getContentId(), null));
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating attachment contentId: " + receivedAttachment.getContentId() + "='" + controlAttachment.getContentId() + "': OK.");
        }
    }

    protected void validateAttachmentContentType(SoapAttachment receivedAttachment, SoapAttachment controlAttachment) {
        if (!StringUtils.hasText((String)controlAttachment.getContentType())) {
            return;
        }
        if (receivedAttachment.getContentType() != null) {
            Assert.isTrue((controlAttachment.getContentType() != null ? 1 : 0) != 0, (String)this.buildValidationErrorMessage("Values not equal for attachment contentType", null, receivedAttachment.getContentType()));
            Assert.isTrue((boolean)receivedAttachment.getContentType().equals(controlAttachment.getContentType()), (String)this.buildValidationErrorMessage("Values not equal for attachment contentType", controlAttachment.getContentType(), receivedAttachment.getContentType()));
        } else {
            Assert.isTrue((controlAttachment.getContentType() == null || controlAttachment.getContentType().length() == 0 ? 1 : 0) != 0, (String)this.buildValidationErrorMessage("Values not equal for attachment contentType", controlAttachment.getContentType(), null));
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating attachment contentType: " + receivedAttachment.getContentType() + "='" + controlAttachment.getContentType() + "': OK.");
        }
    }

    private String buildValidationErrorMessage(String message, Object expectedValue, Object actualValue) {
        return message + ", expected '" + expectedValue + "' but was '" + actualValue + "'";
    }

    protected abstract void validateAttachmentContent(SoapAttachment var1, SoapAttachment var2);
}

