/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.validation;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.validation.AbstractSoapAttachmentValidator;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class BinarySoapAttachmentValidator
extends AbstractSoapAttachmentValidator {
    private static Logger log = LoggerFactory.getLogger(BinarySoapAttachmentValidator.class);

    @Override
    protected void validateAttachmentContent(SoapAttachment receivedAttachment, SoapAttachment controlAttachment) {
        if (log.isDebugEnabled()) {
            log.debug("Validating binary SOAP attachment content ...");
        }
        try {
            Assert.isTrue((boolean)IOUtils.contentEquals((InputStream)receivedAttachment.getInputStream(), (InputStream)controlAttachment.getInputStream()), (String)("Values not equal for binary attachment content '" + controlAttachment.getContentId() + "'"));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Binary SOAP attachment validation failed", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating binary SOAP attachment content: OK");
        }
    }
}

