/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.validation;

import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.xml.DomXmlMessageValidator;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import com.consol.citrus.ws.validation.SimpleSoapAttachmentValidator;
import com.consol.citrus.ws.validation.XmlSoapFaultValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class XmlSoapAttachmentValidator
extends SimpleSoapAttachmentValidator
implements InitializingBean,
ApplicationContextAware {
    private static Logger log = LoggerFactory.getLogger(XmlSoapFaultValidator.class);
    @Autowired
    private MessageValidatorRegistry messageValidatorRegistry;
    @Autowired
    private TestContextFactory testContextFactory;
    private DomXmlMessageValidator messageValidator;
    private ApplicationContext applicationContext;

    @Override
    protected void validateAttachmentContentData(String receivedContent, String controlContent, String controlContentId) {
        this.messageValidator.validateMessage((Message)new DefaultMessage((Object)receivedContent), (Message)new DefaultMessage((Object)controlContent), this.testContextFactory.getObject(), (ValidationContext)new XmlMessageValidationContext());
    }

    public void afterPropertiesSet() throws Exception {
        for (MessageValidator validator : this.messageValidatorRegistry.getMessageValidators()) {
            if (!(validator instanceof DomXmlMessageValidator) || !validator.supportsMessageType(MessageType.XML.name(), (Message)new DefaultMessage((Object)""))) continue;
            this.messageValidator = (DomXmlMessageValidator)validator;
        }
        if (this.messageValidator == null) {
            log.warn("No XML message validator found in Spring bean context - setting default validator");
            this.messageValidator = new DomXmlMessageValidator();
            this.messageValidator.setApplicationContext(this.applicationContext);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

