/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.actions;

import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.message.SoapMessage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendSoapMessageAction
extends SendMessageAction {
    private static Logger log = LoggerFactory.getLogger(SendSoapMessageAction.class);
    private List<SoapAttachment> attachments = new ArrayList<SoapAttachment>();
    private boolean mtomEnabled = false;
    public static final String CID_MARKER = "cid:";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SoapMessage createMessage(TestContext context, String messageType) {
        Message message = super.createMessage(context, this.getMessageType());
        SoapMessage soapMessage = new SoapMessage(message).mtomEnabled(this.mtomEnabled);
        try {
            for (SoapAttachment attachment : this.attachments) {
                attachment.setTestContext(context);
                if (this.mtomEnabled) {
                    String messagePayload = (String)soapMessage.getPayload(String.class);
                    String cid = CID_MARKER + attachment.getContentId();
                    if (attachment.isMtomInline() && messagePayload.contains(cid)) {
                        byte[] attachmentBinaryData = FileUtils.readToString((InputStream)attachment.getInputStream(), (Charset)Charset.forName(attachment.getCharsetName())).getBytes(Charset.forName(attachment.getCharsetName()));
                        if (attachment.getEncodingType().equals("base64Binary")) {
                            if (log.isDebugEnabled()) {
                                log.debug("Adding inline base64Binary data for attachment: %s", (Object)cid);
                            }
                            messagePayload = messagePayload.replaceAll(cid, Base64.encodeBase64String((byte[])attachmentBinaryData));
                        } else {
                            if (!attachment.getEncodingType().equals("hexBinary")) throw new CitrusRuntimeException(String.format("Unsupported encoding type '%s' for SOAP attachment: %s - choose one of %s or %s", attachment.getEncodingType(), cid, "base64Binary", "hexBinary"));
                            if (log.isDebugEnabled()) {
                                log.debug("Adding inline hexBinary data for attachment: %s", (Object)cid);
                            }
                            messagePayload = messagePayload.replaceAll(cid, Hex.encodeHexString((byte[])attachmentBinaryData).toUpperCase());
                        }
                    } else {
                        messagePayload = messagePayload.replaceAll(cid, String.format("<xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"%s\"/>", cid));
                        soapMessage.addAttachment(attachment);
                    }
                    soapMessage.setPayload(messagePayload);
                    continue;
                }
                soapMessage.addAttachment(attachment);
            }
            return soapMessage;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    public List<SoapAttachment> getAttachments() {
        return this.attachments;
    }

    public SendSoapMessageAction setAttachments(List<SoapAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public SendSoapMessageAction setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
        return this;
    }

    public boolean getMtomEnabled() {
        return this.mtomEnabled;
    }
}

