/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.client;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.endpoint.PollableEndpointConfiguration;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.ErrorHandlingStrategy;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.correlation.CorrelationManager;
import com.consol.citrus.message.correlation.PollingCorrelationManager;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.messaging.ReplyConsumer;
import com.consol.citrus.messaging.SelectiveConsumer;
import com.consol.citrus.ws.client.WebServiceEndpointConfiguration;
import com.consol.citrus.ws.interceptor.LoggingClientInterceptor;
import com.consol.citrus.ws.message.callback.SoapRequestMessageCallback;
import com.consol.citrus.ws.message.callback.SoapResponseMessageCallback;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.FaultMessageResolver;
import org.springframework.ws.client.core.SimpleFaultMessageResolver;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.client.core.SoapFaultMessageResolver;
import org.springframework.xml.transform.StringResult;

public class WebServiceClient
extends AbstractEndpoint
implements Producer,
ReplyConsumer {
    private static Logger log = LoggerFactory.getLogger(WebServiceClient.class);
    private CorrelationManager<Message> correlationManager;

    public WebServiceClient() {
        this(new WebServiceEndpointConfiguration());
    }

    public WebServiceClient(WebServiceEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply message did not arrive yet");
    }

    public WebServiceEndpointConfiguration getEndpointConfiguration() {
        return (WebServiceEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void send(Message message, TestContext context) {
        Assert.notNull((Object)message, (String)"Message is empty - unable to send empty message");
        if (CollectionUtils.isEmpty(this.getEndpointConfiguration().getInterceptors()) && this.getEndpointConfiguration().getInterceptor() == null) {
            LoggingClientInterceptor loggingClientInterceptor = new LoggingClientInterceptor();
            loggingClientInterceptor.setMessageListener(context.getMessageListeners());
            this.getEndpointConfiguration().setInterceptor(loggingClientInterceptor);
        }
        com.consol.citrus.ws.message.SoapMessage soapMessage = message instanceof com.consol.citrus.ws.message.SoapMessage ? (com.consol.citrus.ws.message.SoapMessage)message : new com.consol.citrus.ws.message.SoapMessage(message);
        String correlationKeyName = this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.getEndpointConfiguration().getCorrelator().getCorrelationKey((Message)soapMessage);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        String endpointUri = this.getEndpointConfiguration().getEndpointResolver() != null ? this.getEndpointConfiguration().getEndpointResolver().resolveEndpointUri((Message)soapMessage, this.getEndpointConfiguration().getDefaultUri()) : this.getEndpointConfiguration().getDefaultUri();
        if (log.isDebugEnabled()) {
            log.debug("Sending SOAP message to endpoint: '" + endpointUri + "'");
            log.debug("Message to send is:\n" + soapMessage.toString());
        }
        if (!(soapMessage.getPayload() instanceof String)) {
            throw new CitrusRuntimeException("Unsupported payload type '" + soapMessage.getPayload().getClass() + "' Currently only 'java.lang.String' is supported as payload type.");
        }
        SoapRequestMessageCallback requestCallback = new SoapRequestMessageCallback((Message)soapMessage, this.getEndpointConfiguration(), context);
        SoapResponseMessageCallback responseCallback = new SoapResponseMessageCallback(this.getEndpointConfiguration(), context);
        this.getEndpointConfiguration().getWebServiceTemplate().setFaultMessageResolver((FaultMessageResolver)new InternalFaultMessageResolver(correlationKey, endpointUri, context));
        boolean result = this.getEndpointConfiguration().getEndpointResolver() != null ? this.getEndpointConfiguration().getWebServiceTemplate().sendAndReceive(endpointUri, (WebServiceMessageCallback)requestCallback, (WebServiceMessageCallback)responseCallback) : this.getEndpointConfiguration().getWebServiceTemplate().sendAndReceive((WebServiceMessageCallback)requestCallback, (WebServiceMessageCallback)responseCallback);
        log.info("SOAP message was sent to endpoint: '" + endpointUri + "'");
        if (result) {
            log.info("Received SOAP response on endpoint: '" + endpointUri + "'");
            this.correlationManager.store(correlationKey, (Object)responseCallback.getResponse());
        } else {
            log.info("Received no SOAP response from endpoint: '" + endpointUri + "'");
        }
    }

    public Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context);
    }

    public Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.getEndpointConfiguration().getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.getEndpointConfiguration().getCorrelator().getCorrelationKeyName(this.getName()), context), context, timeout);
    }

    public Message receive(String selector, TestContext context, long timeout) {
        Message message = (Message)this.correlationManager.find(selector, timeout);
        if (message == null) {
            throw new ActionTimeoutException("Action timeout while receiving synchronous reply message from soap web server");
        }
        return message;
    }

    public Producer createProducer() {
        return this;
    }

    public SelectiveConsumer createConsumer() {
        return this;
    }

    public void setCorrelationManager(CorrelationManager<Message> correlationManager) {
        this.correlationManager = correlationManager;
    }

    private class InternalFaultMessageResolver
    implements FaultMessageResolver {
        private String correlationKey;
        private String endpointUri;
        private TestContext context;

        public InternalFaultMessageResolver(String correlationKey, String endpointUri, TestContext context) {
            this.correlationKey = correlationKey;
            this.endpointUri = endpointUri;
            this.context = context;
        }

        public void resolveFault(WebServiceMessage webServiceResponse) throws IOException {
            if (WebServiceClient.this.getEndpointConfiguration().getErrorHandlingStrategy().equals((Object)ErrorHandlingStrategy.PROPAGATE)) {
                SoapResponseMessageCallback callback = new SoapResponseMessageCallback(WebServiceClient.this.getEndpointConfiguration(), this.context);
                try {
                    callback.doWithMessage(webServiceResponse);
                    Message responseMessage = callback.getResponse();
                    if (webServiceResponse instanceof SoapMessage) {
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        Transformer transformer = transformerFactory.newTransformer();
                        StringResult faultPayload = new StringResult();
                        transformer.transform(((SoapMessage)webServiceResponse).getSoapBody().getFault().getSource(), (Result)faultPayload);
                        responseMessage.setPayload((Object)faultPayload.toString());
                    }
                    log.info("Received SOAP fault response on endpoint: '" + this.endpointUri + "'");
                    WebServiceClient.this.correlationManager.store(this.correlationKey, (Object)responseMessage);
                }
                catch (TransformerException e) {
                    throw new CitrusRuntimeException("Failed to handle fault response message", (Throwable)e);
                }
            } else if (WebServiceClient.this.getEndpointConfiguration().getErrorHandlingStrategy().equals((Object)ErrorHandlingStrategy.THROWS_EXCEPTION)) {
                if (webServiceResponse instanceof SoapMessage) {
                    new SoapFaultMessageResolver().resolveFault(webServiceResponse);
                } else {
                    new SimpleFaultMessageResolver().resolveFault(webServiceResponse);
                }
            } else {
                throw new CitrusRuntimeException("Unsupported error strategy: " + WebServiceClient.this.getEndpointConfiguration().getErrorHandlingStrategy());
            }
        }
    }
}

