/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.client;

import com.consol.citrus.endpoint.AbstractPollableEndpointConfiguration;
import com.consol.citrus.endpoint.resolver.DynamicEndpointUriResolver;
import com.consol.citrus.endpoint.resolver.EndpointUriResolver;
import com.consol.citrus.message.DefaultMessageCorrelator;
import com.consol.citrus.message.ErrorHandlingStrategy;
import com.consol.citrus.message.MessageCorrelator;
import com.consol.citrus.ws.message.converter.SoapMessageConverter;
import com.consol.citrus.ws.message.converter.WebServiceMessageConverter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;

public class WebServiceEndpointConfiguration
extends AbstractPollableEndpointConfiguration {
    private WebServiceTemplate webServiceTemplate;
    private WebServiceMessageFactory messageFactory;
    private WebServiceMessageSender messageSender;
    private WebServiceMessageConverter messageConverter = new SoapMessageConverter();
    private List<ClientInterceptor> interceptors = new ArrayList<ClientInterceptor>();
    private ClientInterceptor interceptor;
    private String defaultUri;
    private MessageCorrelator correlator = new DefaultMessageCorrelator();
    private EndpointUriResolver endpointResolver = new DynamicEndpointUriResolver();
    private ErrorHandlingStrategy errorHandlingStrategy = ErrorHandlingStrategy.THROWS_EXCEPTION;
    private boolean handleMimeHeaders = true;
    private boolean keepSoapEnvelope = false;

    protected WebServiceTemplate createWebServiceTemplate() {
        return new WebServiceTemplate();
    }

    public void setCorrelator(MessageCorrelator correlator) {
        this.correlator = correlator;
    }

    public void setEndpointResolver(EndpointUriResolver endpointResolver) {
        this.endpointResolver = endpointResolver;
    }

    public ErrorHandlingStrategy getErrorHandlingStrategy() {
        return this.errorHandlingStrategy;
    }

    public void setErrorHandlingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
    }

    public MessageCorrelator getCorrelator() {
        return this.correlator;
    }

    public EndpointUriResolver getEndpointResolver() {
        return this.endpointResolver;
    }

    public WebServiceTemplate getWebServiceTemplate() {
        if (this.webServiceTemplate == null) {
            this.webServiceTemplate = this.createWebServiceTemplate();
        }
        return this.webServiceTemplate;
    }

    public void setWebServiceTemplate(WebServiceTemplate webServiceTemplate) {
        this.webServiceTemplate = webServiceTemplate;
    }

    public WebServiceMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(WebServiceMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
        this.getWebServiceTemplate().setMessageFactory(messageFactory);
    }

    public WebServiceMessageSender getMessageSender() {
        return this.messageSender;
    }

    public void setMessageSender(WebServiceMessageSender messageSender) {
        this.messageSender = messageSender;
        this.getWebServiceTemplate().setMessageSender(messageSender);
    }

    public String getDefaultUri() {
        return this.defaultUri;
    }

    public void setDefaultUri(String defaultUri) {
        this.defaultUri = defaultUri;
        this.getWebServiceTemplate().setDefaultUri(defaultUri);
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<ClientInterceptor> interceptors) {
        this.interceptors = interceptors;
        this.getWebServiceTemplate().setInterceptors(interceptors.toArray(new ClientInterceptor[interceptors.size()]));
    }

    public ClientInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(ClientInterceptor interceptor) {
        this.interceptor = interceptor;
        this.getWebServiceTemplate().setInterceptors(new ClientInterceptor[]{interceptor});
    }

    public WebServiceMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(WebServiceMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public boolean isHandleMimeHeaders() {
        return this.handleMimeHeaders;
    }

    public void setHandleMimeHeaders(boolean handleMimeHeaders) {
        this.handleMimeHeaders = handleMimeHeaders;
    }

    public boolean isKeepSoapEnvelope() {
        return this.keepSoapEnvelope;
    }

    public void setKeepSoapEnvelope(boolean keepSoapEnvelope) {
        this.keepSoapEnvelope = keepSoapEnvelope;
    }
}

