/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.config.xml;

import com.consol.citrus.ws.actions.SendSoapFaultAction;
import com.consol.citrus.ws.config.xml.SendSoapMessageActionParser;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SendSoapFaultActionParser
extends SendSoapMessageActionParser {
    @Override
    public BeanDefinitionBuilder parseComponent(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = super.parseComponent(element, parserContext);
        this.parseFault(builder, DomUtils.getChildElementByTagName((Element)element, (String)"fault"));
        return builder;
    }

    private void parseFault(BeanDefinitionBuilder builder, Element faultElement) {
        if (faultElement != null) {
            Element faultActorElement;
            Element faultStringElement;
            Element faultCodeElement = DomUtils.getChildElementByTagName((Element)faultElement, (String)"fault-code");
            if (faultCodeElement != null) {
                builder.addPropertyValue("faultCode", (Object)DomUtils.getTextValue((Element)faultCodeElement).trim());
            }
            if ((faultStringElement = DomUtils.getChildElementByTagName((Element)faultElement, (String)"fault-string")) != null) {
                builder.addPropertyValue("faultString", (Object)DomUtils.getTextValue((Element)faultStringElement).trim());
            }
            if ((faultActorElement = DomUtils.getChildElementByTagName((Element)faultElement, (String)"fault-actor")) != null) {
                builder.addPropertyValue("faultActor", (Object)DomUtils.getTextValue((Element)faultActorElement).trim());
            }
            this.parseFaultDetail(builder, faultElement);
        }
    }

    private void parseFaultDetail(BeanDefinitionBuilder builder, Element faultElement) {
        List faultDetailElements = DomUtils.getChildElementsByTagName((Element)faultElement, (String)"fault-detail");
        ArrayList<String> faultDetails = new ArrayList<String>();
        ArrayList<String> faultDetailResourcePaths = new ArrayList<String>();
        for (Element faultDetailElement : faultDetailElements) {
            if (faultDetailElement.hasAttribute("file")) {
                if (StringUtils.hasText((String)DomUtils.getTextValue((Element)faultDetailElement).trim())) {
                    throw new BeanCreationException("You tried to set fault-detail by file resource attribute and inline text value at the same time! Please choose one of them.");
                }
                String filePath = faultDetailElement.getAttribute("file");
                faultDetailResourcePaths.add(filePath);
                continue;
            }
            String faultDetailData = DomUtils.getTextValue((Element)faultDetailElement).trim();
            if (StringUtils.hasText((String)faultDetailData)) {
                faultDetails.add(faultDetailData);
                continue;
            }
            throw new BeanCreationException("Not content for fault-detail is set! Either use file attribute or inline text value for fault-detail element.");
        }
        builder.addPropertyValue("faultDetails", faultDetails);
        builder.addPropertyValue("faultDetailResourcePaths", faultDetailResourcePaths);
    }

    @Override
    protected Class<?> getBeanDefinitionClass() {
        return SendSoapFaultAction.class;
    }
}

