/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.message;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.ws.message.SoapMessage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.util.StringUtils;
import org.springframework.ws.soap.SoapFaultDetailElement;
import org.springframework.xml.namespace.QNameEditor;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.transform.StringResult;

public class SoapFault
extends SoapMessage {
    private static final String DECORATION_SUFFIX = "}";
    private static final String DECORATION_PREFIX = "{";
    private String faultCode;
    private String faultString;
    private String faultActor;
    private Locale locale = Locale.ENGLISH;
    private List<String> faultDetails = new ArrayList<String>();

    public QName getFaultCodeQName() {
        return QNameUtils.parseQNameString((String)this.faultCode);
    }

    public SoapFault faultCode(String faultCode) {
        this.faultCode = faultCode;
        return this;
    }

    public SoapFault faultString(String faultString) {
        this.faultString = faultString;
        return this;
    }

    public SoapFault faultActor(String faultActor) {
        this.faultActor = faultActor;
        return this;
    }

    public SoapFault faultDetails(List<String> faultDetails) {
        this.faultDetails = faultDetails;
        return this;
    }

    public SoapFault addFaultDetail(String faultDetail) {
        this.faultDetails.add(faultDetail);
        return this;
    }

    public SoapFault locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public SoapFault locale(String locale) {
        LocaleEditor localeEditor = new LocaleEditor();
        localeEditor.setAsText(locale);
        this.locale = (Locale)localeEditor.getValue();
        return this;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public List<String> getFaultDetails() {
        return this.faultDetails;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static SoapFault from(org.springframework.ws.soap.SoapFault fault) {
        QNameEditor qNameEditor = new QNameEditor();
        qNameEditor.setValue((Object)fault.getFaultCode());
        SoapFault soapFault = new SoapFault().faultCode(qNameEditor.getAsText()).faultActor(fault.getFaultActorOrRole()).faultString(fault.getFaultStringOrReason());
        if (fault.getFaultDetail() != null) {
            Iterator details = fault.getFaultDetail().getDetailEntries();
            while (details.hasNext()) {
                SoapFaultDetailElement soapFaultDetailElement = (SoapFaultDetailElement)details.next();
                soapFault.addFaultDetail(SoapFault.extractFaultDetail(soapFaultDetailElement));
            }
        }
        return soapFault;
    }

    private static String extractFaultDetail(SoapFaultDetailElement detail) {
        StringResult detailResult = new StringResult();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(detail.getSource(), (Result)detailResult);
        }
        catch (TransformerException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        return detailResult.toString();
    }

    private static String decorate(String value) {
        return DECORATION_PREFIX + value + DECORATION_SUFFIX;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        QName faultCodeQName = this.getFaultCodeQName();
        if (StringUtils.hasLength((String)faultCodeQName.getNamespaceURI()) && StringUtils.hasLength((String)faultCodeQName.getPrefix())) {
            builder.append(SoapFault.decorate(SoapFault.decorate(faultCodeQName.getNamespaceURI()) + faultCodeQName.getPrefix() + ":" + faultCodeQName.getLocalPart()));
        } else if (StringUtils.hasLength((String)faultCodeQName.getNamespaceURI())) {
            builder.append(SoapFault.decorate(SoapFault.decorate(faultCodeQName.getNamespaceURI()) + faultCodeQName.getLocalPart()));
        } else {
            builder.append(SoapFault.decorate(faultCodeQName.getLocalPart()));
        }
        if (StringUtils.hasText((String)this.getFaultString())) {
            builder.append(SoapFault.decorate(this.getFaultString()));
            if (this.getLocale() != null) {
                builder.append(SoapFault.decorate(this.getLocale().toString()));
            }
            if (this.faultActor != null) {
                builder.append(SoapFault.decorate(this.faultActor));
            }
        }
        return super.toString() + String.format("[fault: %s]", builder.toString());
    }
}

