/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.security;

import com.consol.citrus.ws.security.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class SecurityHandlerFactory
implements InitializingBean,
FactoryBean<SecurityHandler> {
    private List<User> users = new ArrayList<User>();
    private String realm = "realm";
    private Map<String, Constraint> constraints = new HashMap<String, Constraint>();
    private MappedLoginService loginService;
    private Authenticator authenticator = new BasicAuthenticator();

    public SecurityHandler getObject() throws Exception {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setAuthenticator(this.authenticator);
        securityHandler.setRealmName(this.realm);
        for (Map.Entry<String, Constraint> constraint : this.constraints.entrySet()) {
            ConstraintMapping constraintMapping = new ConstraintMapping();
            constraintMapping.setConstraint(constraint.getValue());
            constraintMapping.setPathSpec(constraint.getKey());
            securityHandler.addConstraintMapping(constraintMapping);
        }
        for (User user : this.users) {
            this.loginService.putUser(user.getName(), Credential.getCredential((String)user.getPassword()), user.getRoles());
        }
        securityHandler.setLoginService((LoginService)this.loginService);
        return securityHandler;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.loginService == null) {
            this.loginService = new HashLoginService();
            ((HashLoginService)this.loginService).setName(this.realm);
        }
    }

    public Class<?> getObjectType() {
        return SecurityHandler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Map<String, Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Map<String, Constraint> constraints) {
        this.constraints = constraints;
    }

    public MappedLoginService getLoginService() {
        return this.loginService;
    }

    public void setLoginService(MappedLoginService loginService) {
        this.loginService = loginService;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }
}

