/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.server;

import com.consol.citrus.endpoint.AbstractEndpointBuilder;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.ws.message.converter.WebServiceMessageConverter;
import com.consol.citrus.ws.server.WebServiceServer;
import java.util.List;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.servlet.ServletHandler;
import org.springframework.web.servlet.HandlerInterceptor;

public class WebServiceServerBuilder
extends AbstractEndpointBuilder<WebServiceServer> {
    private WebServiceServer endpoint = new WebServiceServer();

    protected WebServiceServer getEndpoint() {
        return this.endpoint;
    }

    public WebServiceServerBuilder port(int port) {
        this.endpoint.setPort(port);
        return this;
    }

    public WebServiceServerBuilder autoStart(boolean autoStart) {
        this.endpoint.setAutoStart(autoStart);
        return this;
    }

    public WebServiceServerBuilder contextConfigLocation(String configLocation) {
        this.endpoint.setContextConfigLocation(configLocation);
        return this;
    }

    public WebServiceServerBuilder resourceBase(String resourceBase) {
        this.endpoint.setResourceBase(resourceBase);
        return this;
    }

    public WebServiceServerBuilder rootParentContext(boolean rootParentContext) {
        this.endpoint.setUseRootContextAsParent(rootParentContext);
        return this;
    }

    public WebServiceServerBuilder connectors(List<Connector> connectors) {
        this.endpoint.setConnectors(connectors.toArray(new Connector[connectors.size()]));
        return this;
    }

    public WebServiceServerBuilder connector(Connector connector) {
        this.endpoint.setConnector(connector);
        return this;
    }

    public WebServiceServerBuilder servletName(String servletName) {
        this.endpoint.setServletName(servletName);
        return this;
    }

    public WebServiceServerBuilder servletMappingPath(String servletMappingPath) {
        this.endpoint.setServletMappingPath(servletMappingPath);
        return this;
    }

    public WebServiceServerBuilder contextPath(String contextPath) {
        this.endpoint.setContextPath(contextPath);
        return this;
    }

    public WebServiceServerBuilder servletHandler(ServletHandler servletHandler) {
        this.endpoint.setServletHandler(servletHandler);
        return this;
    }

    public WebServiceServerBuilder securityHandler(SecurityHandler securityHandler) {
        this.endpoint.setSecurityHandler(securityHandler);
        return this;
    }

    public WebServiceServerBuilder messageConverter(WebServiceMessageConverter messageConverter) {
        this.endpoint.setMessageConverter(messageConverter);
        return this;
    }

    public WebServiceServerBuilder timeout(long timeout) {
        this.endpoint.setDefaultTimeout(timeout);
        return this;
    }

    public WebServiceServerBuilder endpointAdapter(EndpointAdapter endpointAdapter) {
        this.endpoint.setEndpointAdapter(endpointAdapter);
        return this;
    }

    public WebServiceServerBuilder interceptors(List<HandlerInterceptor> interceptors) {
        this.endpoint.setInterceptors(interceptors);
        return this;
    }

    public WebServiceServerBuilder messageFactory(String messageFactory) {
        this.endpoint.setMessageFactoryName(messageFactory);
        return this;
    }

    public WebServiceServerBuilder keepSoapEnvelope(boolean flag) {
        this.endpoint.setKeepSoapEnvelope(flag);
        return this;
    }

    public WebServiceServerBuilder handleMimeHeaders(boolean flag) {
        this.endpoint.setHandleMimeHeaders(flag);
        return this;
    }

    public WebServiceServerBuilder soapHeaderNamespace(String namespace) {
        this.endpoint.setSoapHeaderNamespace(namespace);
        return this;
    }

    public WebServiceServerBuilder soapHeaderPrefix(String prefix) {
        this.endpoint.setSoapHeaderPrefix(prefix);
        return this;
    }
}

