/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.browser;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.configuration.AcceptAllFramesChecker;
import com.crawljax.core.configuration.IgnoreFrameChecker;
import com.crawljax.core.exception.BrowserConnectionException;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.Identification;
import com.crawljax.forms.FormInput;
import com.crawljax.forms.InputValue;
import com.crawljax.forms.RandomInputValueGenerator;
import com.crawljax.util.DomUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class WebDriverBackedEmbeddedBrowser
implements EmbeddedBrowser {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverBackedEmbeddedBrowser.class);
    private final ImmutableSortedSet<String> filterAttributes;
    private final WebDriver browser;
    private long crawlWaitEvent;
    private long crawlWaitReload;
    private IgnoreFrameChecker ignoreFrameChecker = new AcceptAllFramesChecker();

    public static WebDriverBackedEmbeddedBrowser withRemoteDriver(String hubUrl, ImmutableSortedSet<String> filterAttributes, long crawlWaitEvent, long crawlWaitReload) {
        return WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)WebDriverBackedEmbeddedBrowser.buildRemoteWebDriver(hubUrl), filterAttributes, crawlWaitEvent, crawlWaitReload);
    }

    public static WebDriverBackedEmbeddedBrowser withRemoteDriver(String hubUrl, ImmutableSortedSet<String> filterAttributes, long crawlWaitEvent, long crawlWaitReload, IgnoreFrameChecker ignoreFrameChecker) {
        return WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)WebDriverBackedEmbeddedBrowser.buildRemoteWebDriver(hubUrl), filterAttributes, crawlWaitEvent, crawlWaitReload, ignoreFrameChecker);
    }

    public static WebDriverBackedEmbeddedBrowser withDriver(WebDriver driver, ImmutableSortedSet<String> filterAttributes, long crawlWaitEvent, long crawlWaitReload) {
        return new WebDriverBackedEmbeddedBrowser(driver, filterAttributes, crawlWaitEvent, crawlWaitReload);
    }

    public static WebDriverBackedEmbeddedBrowser withDriver(WebDriver driver, ImmutableSortedSet<String> filterAttributes, long crawlWaitEvent, long crawlWaitReload, IgnoreFrameChecker ignoreFrameChecker) {
        return new WebDriverBackedEmbeddedBrowser(driver, filterAttributes, crawlWaitEvent, crawlWaitReload, ignoreFrameChecker);
    }

    public static WebDriverBackedEmbeddedBrowser withRemoteDriver(String hubUrl) {
        return WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)WebDriverBackedEmbeddedBrowser.buildRemoteWebDriver(hubUrl));
    }

    private static RemoteWebDriver buildRemoteWebDriver(String hubUrl) {
        URL url;
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setPlatform(Platform.ANY);
        try {
            url = new URL(hubUrl);
        }
        catch (MalformedURLException e) {
            LOGGER.error("The given hub url of the remote server is malformed can not continue!", (Throwable)e);
            return null;
        }
        HttpCommandExecutor executor = null;
        try {
            executor = new HttpCommandExecutor(url);
        }
        catch (Exception e) {
            LOGGER.error("Received unknown exception while creating the HttpCommandExecutor, can not continue!", (Throwable)e);
            return null;
        }
        return new RemoteWebDriver((CommandExecutor)executor, (Capabilities)capabilities);
    }

    private WebDriverBackedEmbeddedBrowser(WebDriver driver) {
        this.browser = driver;
        this.filterAttributes = ImmutableSortedSet.of();
    }

    private WebDriverBackedEmbeddedBrowser(WebDriver driver, ImmutableSortedSet<String> filterAttributes, long crawlWaitReload, long crawlWaitEvent) {
        this.browser = driver;
        this.filterAttributes = (ImmutableSortedSet)Preconditions.checkNotNull(filterAttributes);
        this.crawlWaitEvent = crawlWaitEvent;
        this.crawlWaitReload = crawlWaitReload;
    }

    private WebDriverBackedEmbeddedBrowser(WebDriver driver, ImmutableSortedSet<String> filterAttributes, long crawlWaitReload, long crawlWaitEvent, IgnoreFrameChecker ignoreFrameChecker) {
        this(driver, filterAttributes, crawlWaitReload, crawlWaitEvent);
        this.ignoreFrameChecker = ignoreFrameChecker;
    }

    public static WebDriverBackedEmbeddedBrowser withDriver(WebDriver driver) {
        return new WebDriverBackedEmbeddedBrowser(driver);
    }

    @Override
    public void goToUrl(URL url) {
        try {
            this.browser.navigate().to(url);
            Thread.sleep(this.crawlWaitReload);
            this.handlePopups();
        }
        catch (WebDriverException e) {
            this.throwIfConnectionException(e);
            return;
        }
        catch (InterruptedException e) {
            LOGGER.debug("goToUrl got interrupted while waiting for the page to be loaded", (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
    }

    private void handlePopups() {
        try {
            this.executeJavaScript("window.alert = function(msg){return true;};window.confirm = function(msg){return true;};window.prompt = function(msg){return true;};");
        }
        catch (CrawljaxException e) {
            LOGGER.error("Handling of PopUp windows failed", (Throwable)e);
        }
    }

    private boolean fireEventWait(WebElement webElement, Eventable eventable) throws ElementNotVisibleException, InterruptedException {
        switch (eventable.getEventType()) {
            case click: {
                try {
                    webElement.click();
                    break;
                }
                catch (ElementNotVisibleException e) {
                    throw e;
                }
                catch (WebDriverException e) {
                    this.throwIfConnectionException(e);
                    return false;
                }
            }
            case hover: {
                LOGGER.info("Eventype hover called but this isnt implemented yet");
                break;
            }
            default: {
                LOGGER.info("EventType {} not supported in WebDriver.", (Object)eventable.getEventType());
                return false;
            }
        }
        Thread.sleep(this.crawlWaitEvent);
        return true;
    }

    @Override
    public void close() {
        LOGGER.info("Closing the browser...");
        try {
            this.browser.quit();
        }
        catch (WebDriverException e) {
            if (e.getCause() instanceof InterruptedException) {
                LOGGER.info("Interrupted while waiting for the browser to close. It might not close correctly");
                Thread.currentThread().interrupt();
                return;
            }
            throw this.wrapWebDriverExceptionIfConnectionException(e);
        }
        LOGGER.debug("Browser closed...");
    }

    @Override
    @Deprecated
    public String getDom() {
        return this.getStrippedDom();
    }

    @Override
    public String getStrippedDom() {
        try {
            String dom = this.toUniformDOM(DomUtils.getDocumentToString(this.getDomTreeWithFrames()));
            LOGGER.trace(dom);
            return dom;
        }
        catch (CrawljaxException | WebDriverException e) {
            LOGGER.warn("Could not get the dom", e);
            return "";
        }
    }

    @Override
    public String getUnStrippedDom() {
        return this.browser.getPageSource();
    }

    private String toUniformDOM(String html) {
        Pattern p = Pattern.compile("<SCRIPT(.*?)</SCRIPT>", 34);
        Matcher m = p.matcher(html);
        String htmlFormatted = m.replaceAll("");
        p = Pattern.compile("<\\?xml:(.*?)>");
        m = p.matcher(html);
        htmlFormatted = m.replaceAll("");
        htmlFormatted = this.filterAttributes(htmlFormatted);
        return htmlFormatted;
    }

    private String filterAttributes(String html) {
        String filteredHtml = html;
        for (String attribute : this.filterAttributes) {
            String regex = "\\s" + attribute + "=\"[^\"]*\"";
            Pattern p = Pattern.compile(regex, 2);
            Matcher m = p.matcher(html);
            filteredHtml = m.replaceAll("");
        }
        return filteredHtml;
    }

    @Override
    public void goBack() {
        try {
            this.browser.navigate().back();
        }
        catch (WebDriverException e) {
            throw this.wrapWebDriverExceptionIfConnectionException(e);
        }
    }

    @Override
    public boolean input(Identification identification, String text) {
        try {
            WebElement field = this.browser.findElement(identification.getWebDriverBy());
            if (field != null) {
                field.clear();
                field.sendKeys(new CharSequence[]{text});
                return true;
            }
            return false;
        }
        catch (WebDriverException e) {
            this.throwIfConnectionException(e);
            return false;
        }
    }

    @Override
    public synchronized boolean fireEventAndWait(Eventable eventable) throws ElementNotVisibleException, NoSuchElementException, InterruptedException {
        try {
            WebElement webElement;
            boolean handleChanged = false;
            boolean result = false;
            if (eventable.getRelatedFrame() != null && !eventable.getRelatedFrame().equals("")) {
                LOGGER.debug("switching to frame: " + eventable.getRelatedFrame());
                try {
                    this.switchToFrame(eventable.getRelatedFrame());
                }
                catch (NoSuchFrameException e) {
                    LOGGER.debug("Frame not found, possibily while back-tracking..", (Throwable)e);
                }
                handleChanged = true;
            }
            if ((webElement = this.browser.findElement(eventable.getIdentification().getWebDriverBy())) != null) {
                result = this.fireEventWait(webElement, eventable);
            }
            if (handleChanged) {
                this.browser.switchTo().defaultContent();
            }
            return result;
        }
        catch (ElementNotVisibleException | NoSuchElementException e) {
            throw e;
        }
        catch (WebDriverException e) {
            this.throwIfConnectionException(e);
            return false;
        }
    }

    @Override
    public Object executeJavaScript(String code) throws CrawljaxException {
        try {
            JavascriptExecutor js = (JavascriptExecutor)this.browser;
            return js.executeScript(code, new Object[0]);
        }
        catch (WebDriverException e) {
            this.throwIfConnectionException(e);
            throw new CrawljaxException(e);
        }
    }

    @Override
    public boolean isVisible(Identification identification) {
        try {
            WebElement el = this.browser.findElement(identification.getWebDriverBy());
            if (el != null) {
                return el.isDisplayed();
            }
            return false;
        }
        catch (WebDriverException e) {
            this.throwIfConnectionException(e);
            return false;
        }
    }

    @Override
    public String getCurrentUrl() {
        try {
            return this.browser.getCurrentUrl();
        }
        catch (WebDriverException e) {
            throw this.wrapWebDriverExceptionIfConnectionException(e);
        }
    }

    @Override
    public void closeOtherWindows() {
        try {
            String current = this.browser.getWindowHandle();
            for (String handle : this.browser.getWindowHandles()) {
                if (handle.equals(this.browser.getWindowHandle())) continue;
                this.browser.switchTo().window(handle);
                LOGGER.debug("Closing other window with title \"{}\"", (Object)this.browser.getTitle());
                this.browser.close();
                this.browser.switchTo().window(current);
            }
        }
        catch (UnhandledAlertException e) {
            LOGGER.warn("While closing the window, an alert got ignored: {}", (Object)e.getMessage());
        }
        catch (WebDriverException e) {
            throw this.wrapWebDriverExceptionIfConnectionException(e);
        }
    }

    private Document getDomTreeWithFrames() throws CrawljaxException {
        try {
            Document document = DomUtils.asDocument(this.browser.getPageSource());
            this.appendFrameContent(document.getDocumentElement(), document, "");
            return document;
        }
        catch (IOException e) {
            throw new CrawljaxException(e.getMessage(), e);
        }
    }

    private void appendFrameContent(Element orig, Document document, String topFrame) {
        Element frameElement;
        int i;
        NodeList frameNodes = orig.getElementsByTagName("IFRAME");
        ArrayList<Element> nodeList = new ArrayList<Element>();
        for (i = 0; i < frameNodes.getLength(); ++i) {
            frameElement = (Element)frameNodes.item(i);
            nodeList.add(frameElement);
        }
        frameNodes = orig.getElementsByTagName("FRAME");
        for (i = 0; i < frameNodes.getLength(); ++i) {
            frameElement = (Element)frameNodes.item(i);
            nodeList.add(frameElement);
        }
        for (i = 0; i < nodeList.size(); ++i) {
            try {
                this.locateFrameAndgetSource(document, topFrame, (Element)nodeList.get(i));
                continue;
            }
            catch (NoSuchFrameException | ErrorHandler.UnknownServerException e) {
                LOGGER.warn("Could not add frame contents for element {}", nodeList.get(i));
                LOGGER.debug("Could not load frame because of {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void locateFrameAndgetSource(Document document, String topFrame, Element frameElement) throws NoSuchFrameException {
        String nameId;
        String frameIdentification = "";
        if (topFrame != null && !topFrame.equals("")) {
            frameIdentification = frameIdentification + topFrame + ".";
        }
        if ((nameId = DomUtils.getFrameIdentification(frameElement)) != null && !this.ignoreFrameChecker.isFrameIgnored(frameIdentification + nameId)) {
            frameIdentification = frameIdentification + nameId;
            String handle = this.browser.getWindowHandle();
            LOGGER.debug("The current H: " + handle);
            this.switchToFrame(frameIdentification);
            String toAppend = this.browser.getPageSource();
            LOGGER.debug("frame dom: " + toAppend);
            this.browser.switchTo().defaultContent();
            try {
                Element toAppendElement = DomUtils.asDocument(toAppend).getDocumentElement();
                Element importedElement = (Element)document.importNode(toAppendElement, true);
                frameElement.appendChild(importedElement);
                this.appendFrameContent(importedElement, document, frameIdentification);
            }
            catch (IOException | DOMException e) {
                LOGGER.info("Got exception while inspecting a frame:" + frameIdentification + " continuing...", (Throwable)e);
            }
        }
    }

    private void switchToFrame(String frameIdentification) throws NoSuchFrameException {
        LOGGER.debug("frame identification: " + frameIdentification);
        if (frameIdentification.contains(".")) {
            String[] frames;
            for (String frameId : frames = frameIdentification.split("\\.")) {
                LOGGER.debug("switching to frame: " + frameId);
                this.browser.switchTo().frame(frameId);
            }
        } else {
            this.browser.switchTo().frame(frameIdentification);
        }
    }

    @Override
    public String getStrippedDomWithoutIframeContent() {
        try {
            String dom = this.browser.getPageSource();
            String result = this.toUniformDOM(dom);
            return result;
        }
        catch (WebDriverException e) {
            this.throwIfConnectionException(e);
            return "";
        }
    }

    @Override
    public FormInput getInputWithRandomValue(FormInput input) {
        WebElement webElement;
        try {
            webElement = this.browser.findElement(input.getIdentification().getWebDriverBy());
            if (!webElement.isDisplayed()) {
                return null;
            }
        }
        catch (WebDriverException e) {
            this.throwIfConnectionException(e);
            return null;
        }
        HashSet<InputValue> values = new HashSet<InputValue>();
        try {
            this.setRandomValues(input, webElement, values);
        }
        catch (WebDriverException e) {
            this.throwIfConnectionException(e);
            return null;
        }
        if (values.isEmpty()) {
            return null;
        }
        input.setInputValues(values);
        return input;
    }

    private void setRandomValues(FormInput input, WebElement webElement, Set<InputValue> values) {
        Select select;
        String inputString = input.getType().toLowerCase();
        if (inputString.startsWith("text")) {
            values.add(new InputValue(new RandomInputValueGenerator().getRandomString(8), true));
        } else if (inputString.equals("checkbox") || inputString.equals("radio") && !webElement.isSelected()) {
            if (new RandomInputValueGenerator().getCheck()) {
                values.add(new InputValue("1", true));
            } else {
                values.add(new InputValue("0", false));
            }
        } else if (inputString.equals("select") && !(select = new Select(webElement)).getOptions().isEmpty()) {
            WebElement option = (WebElement)new RandomInputValueGenerator().getRandomItem(select.getOptions());
            values.add(new InputValue(option.getText(), true));
        }
    }

    @Override
    public String getFrameDom(String iframeIdentification) {
        try {
            this.switchToFrame(iframeIdentification);
            String frameDom = this.browser.getPageSource();
            this.browser.switchTo().defaultContent();
            return frameDom;
        }
        catch (WebDriverException e) {
            this.throwIfConnectionException(e);
            return "";
        }
    }

    @Override
    public boolean elementExists(Identification identification) {
        try {
            WebElement el = this.browser.findElement(identification.getWebDriverBy());
            return el != null;
        }
        catch (WebDriverException e) {
            this.throwIfConnectionException(e);
            return false;
        }
    }

    @Override
    public WebElement getWebElement(Identification identification) {
        try {
            return this.browser.findElement(identification.getWebDriverBy());
        }
        catch (WebDriverException e) {
            throw this.wrapWebDriverExceptionIfConnectionException(e);
        }
    }

    protected long getCrawlWaitEvent() {
        return this.crawlWaitEvent;
    }

    protected ImmutableSortedSet<String> getFilterAttributes() {
        return this.filterAttributes;
    }

    protected long getCrawlWaitReload() {
        return this.crawlWaitReload;
    }

    @Override
    public void saveScreenShot(File file) throws CrawljaxException {
        try {
            File tmpfile = (File)this.takeScreenShotOnBrowser(this.browser, OutputType.FILE);
            try {
                Files.copy((File)tmpfile, (File)file);
            }
            catch (IOException e) {
                throw new CrawljaxException(e);
            }
        }
        catch (WebDriverException e) {
            throw this.wrapWebDriverExceptionIfConnectionException(e);
        }
    }

    private <T> T takeScreenShotOnBrowser(WebDriver driver, OutputType<T> outType) throws CrawljaxException {
        if (driver instanceof TakesScreenshot) {
            Object screenshot = ((TakesScreenshot)driver).getScreenshotAs(outType);
            this.removeCanvasGeneratedByFirefoxDriverForScreenshots();
            return (T)screenshot;
        }
        if (driver instanceof RemoteWebDriver) {
            WebDriver augmentedWebdriver = new Augmenter().augment(driver);
            return this.takeScreenShotOnBrowser(augmentedWebdriver, outType);
        }
        if (driver instanceof WrapsDriver) {
            return this.takeScreenShotOnBrowser(((WrapsDriver)driver).getWrappedDriver(), outType);
        }
        throw new CrawljaxException("Your current WebDriver doesn't support screenshots.");
    }

    @Override
    public byte[] getScreenShot() throws CrawljaxException {
        try {
            return (byte[])this.takeScreenShotOnBrowser(this.browser, OutputType.BYTES);
        }
        catch (WebDriverException e) {
            throw this.wrapWebDriverExceptionIfConnectionException(e);
        }
    }

    private void removeCanvasGeneratedByFirefoxDriverForScreenshots() {
        String js = "";
        js = js + "var canvas = document.getElementById('fxdriver-screenshot-canvas');";
        js = js + "if(canvas != null){";
        js = js + "canvas.parentNode.removeChild(canvas);";
        js = js + "}";
        try {
            this.executeJavaScript(js);
        }
        catch (CrawljaxException e) {
            LOGGER.error("Removing of Canvas Generated By FirefoxDriver failed, most likely leaving it in the browser", (Throwable)e);
        }
    }

    public WebDriver getBrowser() {
        return this.browser;
    }

    private boolean exceptionIsConnectionException(WebDriverException exception) {
        return exception != null && exception.getCause() != null && exception.getCause() instanceof IOException;
    }

    private RuntimeException wrapWebDriverExceptionIfConnectionException(WebDriverException exception) {
        if (this.exceptionIsConnectionException(exception)) {
            return new BrowserConnectionException(exception);
        }
        return exception;
    }

    private void throwIfConnectionException(WebDriverException exception) {
        if (this.exceptionIsConnectionException(exception)) {
            throw this.wrapWebDriverExceptionIfConnectionException(exception);
        }
    }
}

