/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.browser;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.browser.WebDriverBackedEmbeddedBrowser;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.configuration.ProxyConfiguration;
import com.crawljax.core.plugin.Plugins;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedSet;
import javax.inject.Inject;
import javax.inject.Provider;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.android.AndroidDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverBrowserBuilder
implements Provider<EmbeddedBrowser> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverBrowserBuilder.class);
    private final CrawljaxConfiguration configuration;
    private final Plugins plugins;

    @Inject
    public WebDriverBrowserBuilder(CrawljaxConfiguration configuration, Plugins plugins) {
        this.configuration = configuration;
        this.plugins = plugins;
    }

    public EmbeddedBrowser get() {
        LOGGER.debug("Setting up a Browser");
        ImmutableSortedSet<String> filterAttributes = this.configuration.getCrawlRules().getPreCrawlConfig().getFilterAttributeNames();
        long crawlWaitReload = this.configuration.getCrawlRules().getWaitAfterReloadUrl();
        long crawlWaitEvent = this.configuration.getCrawlRules().getWaitAfterEvent();
        EmbeddedBrowser browser = null;
        switch (this.configuration.getBrowserConfig().getBrowsertype()) {
            case FIREFOX: {
                browser = this.newFireFoxBrowser(filterAttributes, crawlWaitReload, crawlWaitEvent);
                break;
            }
            case INTERNET_EXPLORER: {
                browser = WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)new InternetExplorerDriver(), filterAttributes, crawlWaitEvent, crawlWaitReload);
                break;
            }
            case CHROME: {
                browser = this.newChromeBrowser(filterAttributes, crawlWaitReload, crawlWaitEvent);
                break;
            }
            case REMOTE: {
                browser = WebDriverBackedEmbeddedBrowser.withRemoteDriver(this.configuration.getBrowserConfig().getRemoteHubUrl(), filterAttributes, crawlWaitEvent, crawlWaitReload);
                break;
            }
            case ANDROID: {
                browser = WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)new AndroidDriver(), filterAttributes, crawlWaitEvent, crawlWaitReload);
                break;
            }
            case PHANTOMJS: {
                browser = this.newPhantomJSDriver(filterAttributes, crawlWaitReload, crawlWaitEvent);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized browsertype " + (Object)((Object)this.configuration.getBrowserConfig().getBrowsertype()));
            }
        }
        this.plugins.runOnBrowserCreatedPlugins(browser);
        return browser;
    }

    private EmbeddedBrowser newFireFoxBrowser(ImmutableSortedSet<String> filterAttributes, long crawlWaitReload, long crawlWaitEvent) {
        if (this.configuration.getProxyConfiguration() != null) {
            FirefoxProfile profile = new FirefoxProfile();
            String lang = this.configuration.getBrowserConfig().getLangOrNull();
            if (!Strings.isNullOrEmpty((String)lang)) {
                profile.setPreference("intl.accept_languages", lang);
            }
            profile.setPreference("network.proxy.http", this.configuration.getProxyConfiguration().getHostname());
            profile.setPreference("network.proxy.http_port", this.configuration.getProxyConfiguration().getPort());
            profile.setPreference("network.proxy.type", this.configuration.getProxyConfiguration().getType().toInt());
            profile.setPreference("network.proxy.no_proxies_on", "");
            return WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)new FirefoxDriver(profile), filterAttributes, crawlWaitReload, crawlWaitEvent);
        }
        return WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)new FirefoxDriver(), filterAttributes, crawlWaitEvent, crawlWaitReload);
    }

    private EmbeddedBrowser newChromeBrowser(ImmutableSortedSet<String> filterAttributes, long crawlWaitReload, long crawlWaitEvent) {
        ChromeDriver driverChrome;
        if (this.configuration.getProxyConfiguration() != null && this.configuration.getProxyConfiguration().getType() != ProxyConfiguration.ProxyType.NOTHING) {
            ChromeOptions optionsChrome = new ChromeOptions();
            String lang = this.configuration.getBrowserConfig().getLangOrNull();
            if (!Strings.isNullOrEmpty((String)lang)) {
                optionsChrome.setExperimentalOptions("intl.accept_languages", (Object)lang);
            }
            optionsChrome.addArguments(new String[]{"--proxy-server=http://" + this.configuration.getProxyConfiguration().getHostname() + ":" + this.configuration.getProxyConfiguration().getPort()});
            driverChrome = new ChromeDriver(optionsChrome);
        } else {
            driverChrome = new ChromeDriver();
        }
        return WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)driverChrome, filterAttributes, crawlWaitEvent, crawlWaitReload);
    }

    private EmbeddedBrowser newPhantomJSDriver(ImmutableSortedSet<String> filterAttributes, long crawlWaitReload, long crawlWaitEvent) {
        DesiredCapabilities caps = new DesiredCapabilities();
        caps.setCapability("takesScreenshot", true);
        ProxyConfiguration proxyConf = this.configuration.getProxyConfiguration();
        if (proxyConf != null && proxyConf.getType() != ProxyConfiguration.ProxyType.NOTHING) {
            String proxyAddrCap = "--proxy=" + proxyConf.getHostname() + ":" + proxyConf.getPort();
            String proxyTypeCap = "--proxy-type=http";
            String[] args = new String[]{proxyAddrCap, "--proxy-type=http"};
            caps.setCapability("phantomjs.cli.args", (Object)args);
        }
        PhantomJSDriver phantomJsDriver = new PhantomJSDriver((Capabilities)caps);
        return WebDriverBackedEmbeddedBrowser.withDriver((WebDriver)phantomJsDriver, filterAttributes, crawlWaitEvent, crawlWaitReload);
    }
}

