/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition;

import com.crawljax.condition.Condition;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class ConditionType {
    private final ImmutableList<Condition> preConditions;
    private final String description;
    private final Condition condition;

    public ConditionType(String description, Condition condition) {
        this(description, condition, new Condition[0]);
    }

    public ConditionType(String description, Condition condition, Condition ... preConditions) {
        this(description, condition, Arrays.asList(preConditions));
    }

    public ConditionType(String description, Condition condition, List<Condition> preConditions) {
        this.description = description;
        this.condition = condition;
        this.preConditions = ImmutableList.copyOf(preConditions);
    }

    public String getDescription() {
        return this.description;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public ImmutableList<Condition> getPreConditions() {
        return this.preConditions;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.preConditions, this.description, this.condition});
    }

    public boolean equals(Object object) {
        if (object instanceof ConditionType) {
            ConditionType that = (ConditionType)object;
            return Objects.equal(this.preConditions, that.preConditions) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.condition, (Object)that.condition);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("preConditions", this.preConditions).add("description", (Object)this.description).add("condition", (Object)this.condition).toString();
    }
}

