/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.Condition;
import com.crawljax.condition.ConditionType;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ConditionTypeChecker<T extends ConditionType> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConditionTypeChecker.class);
    private final ImmutableList<T> invariants;

    public ConditionTypeChecker(ImmutableList<T> invariants) {
        Preconditions.checkNotNull(invariants);
        this.invariants = invariants;
    }

    public ImmutableList<T> getFailedConditions(EmbeddedBrowser browser) {
        LOGGER.debug("Checking {} ConditionTypes", (Object)this.invariants.size());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ConditionType invariant : this.invariants) {
            if (!this.preConditionsHold(browser, invariant)) continue;
            Condition invariantCondition = invariant.getCondition();
            LOGGER.debug("Checking ConditionType: {}", (Object)invariant.getDescription());
            if (invariantCondition.check(browser)) continue;
            LOGGER.debug("ConditionType '{}' failed", (Object)invariant.getDescription());
            builder.add((Object)invariant);
        }
        return builder.build();
    }

    private boolean preConditionsHold(EmbeddedBrowser browser, T invariant) {
        for (Condition condition : ((ConditionType)invariant).getPreConditions()) {
            if (condition.check(browser)) continue;
            LOGGER.debug("Precondition failed for ConditionType: {} - PreCondition: {} : ", (Object)((ConditionType)invariant).getDescription(), (Object)condition);
            return false;
        }
        LOGGER.debug("Preconditions hold for ConditionType: {}", (Object)((ConditionType)invariant).getDescription());
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.invariants});
    }

    public boolean equals(Object object) {
        if (object instanceof ConditionTypeChecker) {
            ConditionTypeChecker that = (ConditionTypeChecker)object;
            return Objects.equal(this.invariants, that.invariants);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("invariants", this.invariants).toString();
    }
}

