/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.Condition;
import com.google.common.base.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CountCondition
implements Condition {
    private final Condition condition;
    private final AtomicInteger count = new AtomicInteger(0);
    private final int maxCount;

    public CountCondition(int maxCount, Condition condition) {
        this.maxCount = maxCount;
        this.condition = condition;
    }

    @Override
    public boolean check(EmbeddedBrowser browser) {
        if (this.condition.check(browser)) {
            this.count.getAndIncrement();
        }
        return this.count.get() <= this.maxCount;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("condition", (Object)this.condition).add("maxCount", this.maxCount).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClass(), this.condition, this.maxCount});
    }

    public boolean equals(Object object) {
        if (object instanceof CountCondition) {
            CountCondition that = (CountCondition)object;
            return Objects.equal((Object)this.condition, (Object)that.condition) && Objects.equal((Object)this.maxCount, (Object)that.maxCount);
        }
        return false;
    }
}

