/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.Condition;
import com.crawljax.core.CrawljaxException;
import com.google.common.base.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class JavaScriptCondition
implements Condition {
    private final String expression;

    public JavaScriptCondition(String expression) {
        this.expression = expression;
    }

    @Override
    public boolean check(EmbeddedBrowser browser) {
        String js = "try{ if(" + this.expression + "){return '1';}else{" + "return '0';}}catch(e){" + " return '0';}";
        try {
            Object object = browser.executeJavaScript(js);
            if (object == null) {
                return false;
            }
            return object.toString().equals("1");
        }
        catch (CrawljaxException e) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClass(), this.expression});
    }

    public boolean equals(Object object) {
        if (object instanceof JavaScriptCondition) {
            JavaScriptCondition that = (JavaScriptCondition)object;
            return Objects.equal((Object)this.expression, (Object)that.expression);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("expression", (Object)this.expression).toString();
    }
}

