/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.Condition;
import com.google.common.base.Objects;
import java.util.Arrays;
import net.jcip.annotations.Immutable;

@Immutable
public final class Logic {
    public static Condition not(Condition condition) {
        return new Not(condition);
    }

    public static Condition and(Condition ... conditions) {
        return new And(conditions);
    }

    public static Condition or(Condition ... conditions) {
        return new Or(conditions);
    }

    public static Condition nand(Condition ... conditions) {
        return Logic.not(Logic.and(conditions));
    }

    private Logic() {
    }

    private static class Or
    implements Condition {
        private Condition[] conditions;

        public Or(Condition ... cs) {
            this.conditions = cs;
        }

        @Override
        public boolean check(EmbeddedBrowser browser) {
            for (Condition condition : this.conditions) {
                if (!condition.check(browser)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("condition", (Object)Arrays.deepToString(this.conditions)).toString();
        }

        public int hashCode() {
            int args = Objects.hashCode((Object[])this.conditions);
            return Objects.hashCode((Object[])new Object[]{this.getClass(), args});
        }

        public boolean equals(Object object) {
            if (object instanceof Or) {
                Or that = (Or)object;
                return Arrays.equals(this.conditions, that.conditions);
            }
            return false;
        }
    }

    private static class And
    implements Condition {
        private Condition[] conditions;

        public And(Condition ... cs) {
            this.conditions = cs;
        }

        @Override
        public boolean check(EmbeddedBrowser browser) {
            for (Condition condition : this.conditions) {
                if (condition.check(browser)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("condition", (Object)Arrays.deepToString(this.conditions)).toString();
        }

        public int hashCode() {
            int args = Objects.hashCode((Object[])this.conditions);
            return Objects.hashCode((Object[])new Object[]{this.getClass(), args});
        }

        public boolean equals(Object object) {
            if (object instanceof And) {
                And that = (And)object;
                return Arrays.equals(this.conditions, that.conditions);
            }
            return false;
        }
    }

    private static class Not
    implements Condition {
        private Condition condition;

        public Not(Condition c) {
            this.condition = c;
        }

        @Override
        public boolean check(EmbeddedBrowser browser) {
            return !this.condition.check(browser);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("condition", (Object)this.condition).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getClass(), this.condition});
        }

        public boolean equals(Object object) {
            if (object instanceof Not) {
                Not that = (Not)object;
                return Objects.equal((Object)this.condition, (Object)that.condition);
            }
            return false;
        }
    }
}

