/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.Condition;
import com.google.common.base.Objects;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class RegexCondition
implements Condition {
    private static final Logger LOG = LoggerFactory.getLogger(RegexCondition.class);
    private final String expression;
    private final Pattern pattern;

    public RegexCondition(String expression) {
        this.expression = expression;
        this.pattern = Pattern.compile(expression, 2);
    }

    @Override
    public boolean check(EmbeddedBrowser browser) {
        String dom = browser.getStrippedDom();
        boolean found = this.pattern.matcher(dom).find();
        if (found) {
            LOG.trace("Found expression {} in DOM {}", (Object)this.expression, (Object)dom);
        }
        return found;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClass(), this.expression, this.pattern.toString()});
    }

    public boolean equals(Object object) {
        if (object instanceof RegexCondition) {
            RegexCondition that = (RegexCondition)object;
            return Objects.equal((Object)this.expression, (Object)that.expression) && Objects.equal((Object)this.pattern.toString(), (Object)that.pattern.toString());
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("expression", (Object)this.expression.toString()).add("pattern", (Object)this.pattern.toString()).toString();
    }
}

