/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.Condition;
import com.crawljax.util.DomUtils;
import com.crawljax.util.XPathHelper;
import com.google.common.base.Objects;
import java.io.IOException;
import javax.xml.xpath.XPathExpressionException;
import net.jcip.annotations.Immutable;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@Immutable
public class XPathCondition
implements Condition {
    private final String expression;

    public XPathCondition(String expression) {
        this.expression = expression;
    }

    @Override
    public boolean check(EmbeddedBrowser browser) {
        return this.checkXPathExpression(browser);
    }

    private boolean checkXPathExpression(EmbeddedBrowser browser) {
        try {
            Document document = DomUtils.asDocument(browser.getStrippedDom());
            NodeList nodeList = XPathHelper.evaluateXpathExpression(document, this.expression);
            return nodeList.getLength() > 0;
        }
        catch (IOException | XPathExpressionException e) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClass(), this.expression});
    }

    public boolean equals(Object object) {
        if (object instanceof XPathCondition) {
            XPathCondition that = (XPathCondition)object;
            return Objects.equal((Object)this.expression, (Object)that.expression);
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("expression", (Object)this.expression).toString();
    }
}

