/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition.browserwaiter;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.browserwaiter.ExpectedCondition;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class WaitCondition {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)WaitCondition.class.getName());
    private static final int WAITTIME = 500;
    private final String url;
    private final List<ExpectedCondition> expectedConditions = new ArrayList<ExpectedCondition>();
    private final int timeOut;
    private final int pollingTime = 100;

    public WaitCondition(String url, ExpectedCondition ... expectedConditions) {
        this(url, 500, expectedConditions);
    }

    public WaitCondition(String url, int timeoutMilliseconds, ExpectedCondition ... expectedConditions) {
        this.url = url;
        this.timeOut = timeoutMilliseconds;
        for (ExpectedCondition condition : expectedConditions) {
            this.expectedConditions.add(condition);
        }
    }

    public WaitCondition(String url, int timeoutMilliseconds, List<ExpectedCondition> expectedConditions) {
        this.url = url;
        this.timeOut = timeoutMilliseconds;
        this.expectedConditions.addAll(expectedConditions);
    }

    public int testAndWait(EmbeddedBrowser browser) {
        if (this.expectedConditions.isEmpty()) {
            return 1;
        }
        if (!browser.getCurrentUrl().toLowerCase().contains(this.url.toLowerCase())) {
            return -1;
        }
        ExpectedCondition lastCheckCondition = null;
        ArrayList<ExpectedCondition> toCheckwaitConditions = new ArrayList<ExpectedCondition>();
        toCheckwaitConditions.addAll(this.expectedConditions);
        long currentTime = System.currentTimeMillis();
        long maxTime = currentTime + (long)this.timeOut;
        this.getClass();
        long repeatTime = 100L;
        LOGGER.info("Waiting for " + toCheckwaitConditions.size() + " conditions");
        int index = 0;
        while (index < toCheckwaitConditions.size() && currentTime <= maxTime) {
            ExpectedCondition checkCondition;
            lastCheckCondition = checkCondition = (ExpectedCondition)toCheckwaitConditions.get(index);
            LOGGER.debug("Waiting for: " + checkCondition);
            if (checkCondition.isSatisfied(browser)) {
                ++index;
            } else {
                try {
                    Thread.sleep(repeatTime);
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Intterupted while waiting in condition");
                    Thread.currentThread().interrupt();
                }
            }
            currentTime = System.currentTimeMillis();
        }
        if (currentTime >= maxTime) {
            LOGGER.info("TIMEOUT WaitCondition url " + this.getUrl() + "; Timout while waiting for " + lastCheckCondition);
            return 0;
        }
        return 1;
    }

    protected String getUrl() {
        return this.url;
    }
}

