/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition.browserwaiter;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.browserwaiter.WaitCondition;
import com.crawljax.core.configuration.CrawlRules;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class WaitConditionChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)WaitConditionChecker.class.getName());
    private ImmutableList<WaitCondition> waitConditions;

    @Inject
    public WaitConditionChecker(CrawlRules rules) {
        this.waitConditions = rules.getPreCrawlConfig().getWaitConditions();
    }

    public List<WaitCondition> getWaitConditions() {
        return this.waitConditions;
    }

    public void wait(EmbeddedBrowser browser) {
        if (this.waitConditions == null) {
            return;
        }
        for (WaitCondition waitCondition : this.waitConditions) {
            LOGGER.info("Checking WaitCondition for url: " + waitCondition.getUrl());
            waitCondition.testAndWait(browser);
        }
    }
}

