/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition.eventablecondition;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.Condition;
import com.crawljax.util.XPathHelper;
import java.util.ArrayList;
import java.util.List;

public class EventableCondition {
    private final String id;
    private List<Condition> conditions = new ArrayList<Condition>();
    private String inXPath;
    private List<String> linkedInputFields = new ArrayList<String>();

    public EventableCondition(String id) {
        this.id = id;
    }

    public EventableCondition(String id, List<String> linkedInputFields) {
        this.id = id;
        this.linkedInputFields = linkedInputFields;
    }

    public EventableCondition(String id, Condition ... conditions) {
        this.id = id;
        for (Condition condition : conditions) {
            this.conditions.add(condition);
        }
    }

    public boolean checkAllConditionsSatisfied(EmbeddedBrowser browser) {
        for (Condition condition : this.getConditions()) {
            if (condition.check(browser)) continue;
            return false;
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public String getInXPath() {
        return this.inXPath;
    }

    public List<String> getLinkedInputFields() {
        return this.linkedInputFields;
    }

    public void setLinkedInputFields(List<String> linkedInputFields) {
        this.linkedInputFields = linkedInputFields;
    }

    public void setInXPath(String inXPath) {
        this.inXPath = XPathHelper.formatXPath(inXPath);
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EventableCondition [");
        if (this.id != null) {
            builder.append("id=");
            builder.append(this.id);
            builder.append(", ");
        }
        if (this.conditions != null) {
            builder.append("conditions=");
            builder.append(this.conditions);
            builder.append(", ");
        }
        if (this.inXPath != null) {
            builder.append("inXPath=");
            builder.append(this.inXPath);
            builder.append(", ");
        }
        if (this.linkedInputFields != null) {
            builder.append("linkedInputFields=");
            builder.append(this.linkedInputFields);
        }
        builder.append("]");
        return builder.toString();
    }
}

