/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.condition.eventablecondition;

import com.crawljax.condition.eventablecondition.EventableCondition;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.configuration.CrawlElement;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.util.XPathHelper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class EventableConditionChecker {
    private static final Logger LOG = LoggerFactory.getLogger(EventableConditionChecker.class);
    private final ImmutableList<EventableCondition> eventableConditions;

    @Inject
    public EventableConditionChecker(CrawlRules config) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (CrawlElement crawlTag : config.getAllCrawlElements()) {
            EventableCondition eventableCondition = crawlTag.getEventableCondition();
            if (eventableCondition == null) continue;
            builder.add((Object)eventableCondition);
        }
        this.eventableConditions = builder.build();
        LOG.debug("Evenetable conditions {}", this.eventableConditions);
    }

    public EventableCondition getEventableCondition(String id) {
        if (!Strings.isNullOrEmpty((String)id)) {
            for (EventableCondition eventableCondition : this.eventableConditions) {
                if (!eventableCondition.getId().equalsIgnoreCase(id)) continue;
                return eventableCondition;
            }
        }
        return null;
    }

    public boolean checkXpathStartsWithXpathEventableCondition(Document dom, EventableCondition eventableCondition, String xpath) throws XPathExpressionException {
        if (eventableCondition == null || Strings.isNullOrEmpty((String)eventableCondition.getInXPath())) {
            throw new CrawljaxException("Eventable has no XPath condition");
        }
        ImmutableList<String> expressions = XPathHelper.getXpathForXPathExpressions(dom, eventableCondition.getInXPath());
        return this.checkXPathUnderXPaths(xpath, (List<String>)expressions);
    }

    public boolean checkXPathUnderXPaths(String xpath, List<String> xpathsList) {
        for (String fullXpath : xpathsList) {
            if (xpath.startsWith(fullXpath)) {
                LOG.trace("{} IS under xpath {}", (Object)xpath, (Object)fullXpath);
                return true;
            }
            LOG.trace("{} is not under xpath {}", (Object)xpath, (Object)fullXpath);
        }
        return false;
    }
}

