/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.eventablecondition.EventableCondition;
import com.crawljax.core.state.Identification;
import com.crawljax.forms.FormInput;
import com.crawljax.util.DomUtils;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.w3c.dom.Element;

public class CandidateElement {
    private final Identification identification;
    private final Element element;
    private final ImmutableList<FormInput> formInputs;
    private final String relatedFrame;
    private EventableCondition eventableCondition;

    public CandidateElement(Element element, Identification identification, String relatedFrame, List<FormInput> formInputs) {
        this.identification = identification;
        this.element = element;
        this.relatedFrame = relatedFrame;
        this.formInputs = ImmutableList.copyOf(formInputs);
    }

    public CandidateElement(Element element, String xpath, List<FormInput> formInputs) {
        this(element, new Identification(Identification.How.xpath, xpath), "", formInputs);
    }

    public CandidateElement(Element sourceElement, Identification identification, String relatedFrame) {
        this(sourceElement, identification, relatedFrame, (List<FormInput>)ImmutableList.of());
    }

    public String getGeneralString() {
        ImmutableSet exclude = ImmutableSet.of((Object)"atusa");
        StringBuilder result = new StringBuilder();
        if (this.element != null) {
            result.append(this.element.getNodeName()).append(": ");
        }
        result.append(DomUtils.getElementAttributes(this.element, (ImmutableSet<String>)exclude)).append(' ').append(this.identification).append(' ').append(this.relatedFrame);
        return result.toString();
    }

    public String getUniqueString() {
        String result = "";
        if (this.element != null) {
            result = result + this.element.getNodeName() + ": " + DomUtils.getAllElementAttributes(this.element) + " ";
        }
        result = result + this.identification + " " + this.relatedFrame;
        return result;
    }

    public Element getElement() {
        return this.element;
    }

    public List<FormInput> getFormInputs() {
        return this.formInputs;
    }

    public void setEventableCondition(EventableCondition eventableCondition) {
        this.eventableCondition = eventableCondition;
    }

    public Identification getIdentification() {
        return this.identification;
    }

    public String getRelatedFrame() {
        return this.relatedFrame;
    }

    public boolean allConditionsSatisfied(EmbeddedBrowser browser) {
        if (this.eventableCondition != null) {
            return this.eventableCondition.checkAllConditionsSatisfied(browser);
        }
        return true;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("identification", (Object)this.identification).add("element", (Object)this.element).add("formInputs", this.formInputs).add("eventableCondition", (Object)this.eventableCondition).add("relatedFrame", (Object)this.relatedFrame).toString();
    }
}

