/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.eventablecondition.EventableCondition;
import com.crawljax.condition.eventablecondition.EventableConditionChecker;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.CrawljaxException;
import com.crawljax.core.ExtractorManager;
import com.crawljax.core.configuration.CrawlElement;
import com.crawljax.core.configuration.CrawlRules;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.configuration.PreCrawlConfiguration;
import com.crawljax.core.state.Identification;
import com.crawljax.core.state.StateVertex;
import com.crawljax.forms.FormHandler;
import com.crawljax.util.DomUtils;
import com.crawljax.util.XPathHelper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CandidateElementExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(CandidateElementExtractor.class);
    private final ExtractorManager checkedElements;
    private final EmbeddedBrowser browser;
    private final FormHandler formHandler;
    private final boolean crawlFrames;
    private final ImmutableMultimap<String, CrawlElement> excludeCrawlElements;
    private final ImmutableList<CrawlElement> includedCrawlElements;
    private final boolean clickOnce;
    private final boolean randomizeElementsOrder;
    private final ImmutableSortedSet<String> ignoredFrameIdentifiers;
    private final boolean followExternalLinks;
    private final String siteHostName;

    @Inject
    public CandidateElementExtractor(ExtractorManager checker, @Assisted EmbeddedBrowser browser, FormHandler formHandler, CrawljaxConfiguration config) {
        this.checkedElements = checker;
        this.browser = browser;
        this.formHandler = formHandler;
        CrawlRules rules = config.getCrawlRules();
        PreCrawlConfiguration preCrawlConfig = rules.getPreCrawlConfig();
        this.excludeCrawlElements = this.asMultiMap(preCrawlConfig.getExcludedElements());
        this.includedCrawlElements = ImmutableList.builder().addAll(preCrawlConfig.getIncludedElements()).addAll(rules.getInputSpecification().getCrawlElements()).build();
        this.crawlFrames = rules.shouldCrawlFrames();
        this.clickOnce = rules.isClickOnce();
        this.randomizeElementsOrder = rules.isRandomizeCandidateElements();
        this.ignoredFrameIdentifiers = rules.getIgnoredFrameIdentifiers();
        this.followExternalLinks = rules.followExternalLinks();
        this.siteHostName = config.getUrl().getHost();
    }

    private ImmutableMultimap<String, CrawlElement> asMultiMap(ImmutableList<CrawlElement> elements) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (CrawlElement elem : elements) {
            builder.put((Object)elem.getTagName(), (Object)elem);
        }
        return builder.build();
    }

    public ImmutableList<CandidateElement> extract(StateVertex currentState) throws CrawljaxException {
        LinkedList<CandidateElement> results = new LinkedList<CandidateElement>();
        if (!this.checkedElements.checkCrawlCondition(this.browser)) {
            LOG.info("State {} did not satisfy the CrawlConditions.", (Object)currentState.getName());
            return ImmutableList.of();
        }
        LOG.debug("Looking in state: {} for candidate elements", (Object)currentState.getName());
        try {
            Document dom = DomUtils.asDocument(this.browser.getStrippedDomWithoutIframeContent());
            this.extractElements(dom, results, "");
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new CrawljaxException(e);
        }
        if (this.randomizeElementsOrder) {
            Collections.shuffle(results);
        }
        currentState.setElementsFound(results);
        LOG.debug("Found {} new candidate elements to analyze!", (Object)results.size());
        return ImmutableList.copyOf(results);
    }

    private void extractElements(Document dom, List<CandidateElement> results, String relatedFrame) {
        LOG.debug("Extracting elements for related frame '{}'", (Object)relatedFrame);
        for (CrawlElement tag : this.includedCrawlElements) {
            LOG.debug("Extracting TAG: {}", (Object)tag);
            NodeList frameNodes = dom.getElementsByTagName("FRAME");
            this.addFramesCandidates(dom, results, relatedFrame, frameNodes);
            NodeList iFrameNodes = dom.getElementsByTagName("IFRAME");
            this.addFramesCandidates(dom, results, relatedFrame, iFrameNodes);
            this.evaluateElements(dom, tag, results, relatedFrame);
        }
    }

    private void addFramesCandidates(Document dom, List<CandidateElement> results, String relatedFrame, NodeList frameNodes) {
        if (frameNodes == null) {
            return;
        }
        for (int i = 0; i < frameNodes.getLength(); ++i) {
            Element frameElement = (Element)frameNodes.item(i);
            String nameId = DomUtils.getFrameIdentification(frameElement);
            String frameIdentification = "";
            if (!Strings.isNullOrEmpty((String)relatedFrame)) {
                frameIdentification = frameIdentification + relatedFrame + ".";
            }
            if (nameId == null || this.isFrameIgnored(frameIdentification + nameId)) continue;
            frameIdentification = frameIdentification + nameId;
            LOG.debug("frame Identification: {}", (Object)frameIdentification);
            try {
                Document frameDom = DomUtils.asDocument(this.browser.getFrameDom(frameIdentification));
                this.extractElements(frameDom, results, frameIdentification);
                continue;
            }
            catch (IOException e) {
                LOG.info("Got exception while inspecting a frame: {} continuing...", (Object)frameIdentification, (Object)e);
            }
        }
    }

    private boolean isFrameIgnored(String string) {
        if (this.crawlFrames) {
            for (String ignorePattern : this.ignoredFrameIdentifiers) {
                String pattern;
                if (!(ignorePattern.contains("%") ? string.matches(pattern = ignorePattern.replace("%", ".*")) : ignorePattern.equals(string))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void evaluateElements(Document dom, CrawlElement crawl, List<CandidateElement> results, String relatedFrame) {
        try {
            ImmutableList<Element> nodeListForCrawlElement = this.getNodeListForTagElement(dom, crawl, this.checkedElements.getEventableConditionChecker());
            for (Element sourceElement : nodeListForCrawlElement) {
                this.evaluateElement(results, relatedFrame, crawl, sourceElement);
            }
        }
        catch (CrawljaxException e) {
            LOG.warn("Catched exception during NodeList For Tag Element retrieval", (Throwable)e);
        }
    }

    private ImmutableList<Element> getNodeListForTagElement(Document dom, CrawlElement crawlElement, EventableConditionChecker eventableConditionChecker) {
        ImmutableList.Builder result = ImmutableList.builder();
        if (crawlElement.getTagName() == null) {
            return result.build();
        }
        EventableCondition eventableCondition = eventableConditionChecker.getEventableCondition(crawlElement.getId());
        ImmutableList<String> expressions = this.getFullXpathForGivenXpath(dom, eventableCondition);
        NodeList nodeList = dom.getElementsByTagName(crawlElement.getTagName());
        for (int k = 0; k < nodeList.getLength(); ++k) {
            Element element = (Element)nodeList.item(k);
            boolean matchesXpath = this.elementMatchesXpath(eventableConditionChecker, eventableCondition, expressions, element);
            LOG.debug("Element {} matches Xpath={}", (Object)DomUtils.getElementString(element), (Object)matchesXpath);
            String id = element.getNodeName() + ": " + DomUtils.getAllElementAttributes(element);
            if (matchesXpath && !this.checkedElements.isChecked(id) && !this.isExcluded(dom, element, eventableConditionChecker)) {
                this.addElement(element, (ImmutableList.Builder<Element>)result, crawlElement);
                continue;
            }
            LOG.debug("Element {} was not added", (Object)element);
        }
        return result.build();
    }

    private boolean elementMatchesXpath(EventableConditionChecker eventableConditionChecker, EventableCondition eventableCondition, ImmutableList<String> expressions, Element element) {
        boolean matchesXpath = true;
        if (eventableCondition != null && eventableCondition.getInXPath() != null) {
            try {
                matchesXpath = eventableConditionChecker.checkXPathUnderXPaths(XPathHelper.getXPathExpression(element), (List<String>)expressions);
            }
            catch (RuntimeException e) {
                matchesXpath = false;
            }
        }
        return matchesXpath;
    }

    private ImmutableList<String> getFullXpathForGivenXpath(Document dom, EventableCondition eventableCondition) {
        if (eventableCondition != null && eventableCondition.getInXPath() != null) {
            try {
                ImmutableList<String> result = XPathHelper.getXpathForXPathExpressions(dom, eventableCondition.getInXPath());
                LOG.debug("Xpath {} resolved to xpaths in document: {}", (Object)eventableCondition.getInXPath(), result);
                return result;
            }
            catch (XPathExpressionException e) {
                LOG.debug("Could not load XPath expressions for {}", (Object)eventableCondition, (Object)e);
            }
        }
        return ImmutableList.of();
    }

    private void addElement(Element element, ImmutableList.Builder<Element> builder, CrawlElement crawlElement) {
        if ("A".equalsIgnoreCase(crawlElement.getTagName()) && this.hrefShouldBeIgnored(element)) {
            return;
        }
        builder.add((Object)element);
        LOG.debug("Adding element {}", (Object)element);
        this.checkedElements.increaseElementsCounter();
    }

    private boolean hrefShouldBeIgnored(Element element) {
        String href = Strings.nullToEmpty((String)element.getAttribute("href"));
        return this.isFileForDownloading(href) || href.startsWith("mailto:") || !this.followExternalLinks && this.isExternal(href);
    }

    private boolean isExternal(String href) {
        if (href.startsWith("http")) {
            try {
                URI uri = URI.create(href);
                return !uri.getHost().equalsIgnoreCase(this.siteHostName);
            }
            catch (IllegalArgumentException e) {
                LOG.info("Unreadable externa link {}", (Object)href);
            }
        }
        return false;
    }

    private boolean isFileForDownloading(String href) {
        Pattern p = Pattern.compile(".+.pdf|.+.ps|.+.zip|.+.mp3");
        Matcher m = p.matcher(href);
        return m.matches();
    }

    private void evaluateElement(List<CandidateElement> results, String relatedFrame, CrawlElement crawl, Element sourceElement) {
        EventableCondition eventableCondition = this.checkedElements.getEventableConditionChecker().getEventableCondition(crawl.getId());
        String xpath = XPathHelper.getXPathExpression(sourceElement);
        List<Object> candidateElements = new ArrayList<CandidateElement>();
        if (eventableCondition != null && eventableCondition.getLinkedInputFields() != null && eventableCondition.getLinkedInputFields().size() > 0) {
            candidateElements = this.formHandler.getCandidateElementsForInputs(sourceElement, eventableCondition);
        } else {
            candidateElements.add(new CandidateElement(sourceElement, new Identification(Identification.How.xpath, xpath), relatedFrame));
        }
        for (CandidateElement candidateElement : candidateElements) {
            if (this.clickOnce && !this.checkedElements.markChecked(candidateElement)) continue;
            LOG.debug("Found new candidate element: {} with eventableCondition {}", (Object)candidateElement.getUniqueString(), (Object)eventableCondition);
            candidateElement.setEventableCondition(eventableCondition);
            results.add(candidateElement);
        }
    }

    private boolean isExcluded(Document dom, Element element, EventableConditionChecker eventableConditionChecker) {
        Node parent = element.getParentNode();
        if (parent instanceof Element && this.isExcluded(dom, (Element)parent, eventableConditionChecker)) {
            return true;
        }
        for (CrawlElement crawlElem : this.excludeCrawlElements.get((Object)element.getTagName().toUpperCase())) {
            boolean matchesXPath = false;
            EventableCondition eventableCondition = eventableConditionChecker.getEventableCondition(crawlElem.getId());
            try {
                String asXpath = XPathHelper.getXPathExpression(element);
                matchesXPath = eventableConditionChecker.checkXpathStartsWithXpathEventableCondition(dom, eventableCondition, asXpath);
            }
            catch (CrawljaxException | XPathExpressionException e) {
                LOG.debug("Could not check exclusion by Xpath for element because {}", (Object)e.getMessage());
                matchesXPath = false;
            }
            if (!matchesXPath) continue;
            LOG.info("Excluded element because of xpath: " + element);
            return true;
        }
        return false;
    }

    public boolean checkCrawlCondition() {
        return this.checkedElements.checkCrawlCondition(this.browser);
    }
}

