/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.browser.EmbeddedBrowser;
import com.crawljax.condition.ConditionTypeChecker;
import com.crawljax.condition.crawlcondition.CrawlCondition;
import com.crawljax.condition.eventablecondition.EventableConditionChecker;
import com.crawljax.core.CandidateElement;
import com.crawljax.core.ExtractorManager;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import net.jcip.annotations.GuardedBy;

public class CandidateElementManager
implements ExtractorManager {
    private final AtomicInteger counter = new AtomicInteger();
    private final Collection<String> elements = new ConcurrentLinkedQueue<String>();
    private final EventableConditionChecker eventableConditionChecker;
    private final ConditionTypeChecker<CrawlCondition> crawlConditionChecker;
    private final Object elementsLock = new Object();

    @Inject
    public CandidateElementManager(EventableConditionChecker eventableConditionChecker, ConditionTypeChecker<CrawlCondition> crawlConditionChecker) {
        this.eventableConditionChecker = eventableConditionChecker;
        this.crawlConditionChecker = crawlConditionChecker;
    }

    @Override
    public void increaseElementsCounter() {
        this.counter.getAndIncrement();
    }

    @Override
    public boolean isChecked(String element) {
        return this.elements.contains(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="elementsLock")
    public boolean markChecked(CandidateElement element) {
        String generalString = element.getGeneralString();
        String uniqueString = element.getUniqueString();
        Object object = this.elementsLock;
        synchronized (object) {
            if (this.elements.contains(uniqueString)) {
                return false;
            }
            this.elements.add(generalString);
            this.elements.add(uniqueString);
            return true;
        }
    }

    @Override
    public int numberOfExaminedElements() {
        return this.counter.get();
    }

    @Override
    public EventableConditionChecker getEventableConditionChecker() {
        return this.eventableConditionChecker;
    }

    @Override
    public boolean checkCrawlCondition(EmbeddedBrowser browser) {
        return this.crawlConditionChecker.getFailedConditions(browser).isEmpty();
    }
}

