/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.core.CrawlSession;
import com.crawljax.core.CrawlTaskConsumer;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.plugin.Plugins;
import com.crawljax.core.state.StateVertex;
import com.crawljax.di.CrawlSessionProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CrawlController
implements Callable<CrawlSession> {
    private static final Logger LOG = LoggerFactory.getLogger(CrawlController.class);
    private final Provider<CrawlTaskConsumer> consumerFactory;
    private final ExecutorService executor;
    private final CrawljaxConfiguration config;
    private final CrawlSessionProvider crawlSessionProvider;
    private final Plugins plugins;
    private final long maximumCrawlTime;
    private final ExitNotifier exitNotifier;
    private ExitNotifier.ExitStatus exitReason;

    @Inject
    CrawlController(ExecutorService executor, Provider<CrawlTaskConsumer> consumerFactory, CrawljaxConfiguration config, ExitNotifier exitNotifier, CrawlSessionProvider crawlSessionProvider, Plugins plugins) {
        this.executor = executor;
        this.consumerFactory = consumerFactory;
        this.exitNotifier = exitNotifier;
        this.config = config;
        this.plugins = plugins;
        this.crawlSessionProvider = crawlSessionProvider;
        this.maximumCrawlTime = config.getMaximumRuntime();
    }

    @Override
    public CrawlSession call() {
        this.setMaximumCrawlTimeIfNeeded();
        this.plugins.runPreCrawlingPlugins(this.config);
        CrawlTaskConsumer firstConsumer = (CrawlTaskConsumer)this.consumerFactory.get();
        StateVertex firstState = firstConsumer.crawlIndex();
        this.crawlSessionProvider.setup(firstState);
        this.plugins.runOnNewStatePlugins(firstConsumer.getContext(), firstState);
        this.executeConsumers(firstConsumer);
        return this.crawlSessionProvider.get();
    }

    public CrawlSession run() {
        return this.call();
    }

    public ExitNotifier.ExitStatus getReason() {
        return this.exitReason;
    }

    private void setMaximumCrawlTimeIfNeeded() {
        if (this.maximumCrawlTime == 0L) {
            return;
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.debug("Waiting {} before killing the crawler", (Object)CrawlController.this.maximumCrawlTime);
                    Thread.sleep(CrawlController.this.maximumCrawlTime);
                    LOG.info("Time is up! Shutting down...");
                    CrawlController.this.exitNotifier.signalTimeIsUp();
                }
                catch (InterruptedException e) {
                    LOG.debug("Crawler finished before maximum crawltime exceeded");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeConsumers(CrawlTaskConsumer firstConsumer) {
        LOG.debug("Starting {} consumers", (Object)this.config.getBrowserConfig().getNumberOfBrowsers());
        this.executor.submit(firstConsumer);
        for (int i = 1; i < this.config.getBrowserConfig().getNumberOfBrowsers(); ++i) {
            this.executor.submit((Callable)this.consumerFactory.get());
        }
        try {
            this.exitReason = this.exitNotifier.awaitTermination();
        }
        catch (InterruptedException e) {
            LOG.warn("The crawl was interrupted before it finished. Shutting down...");
            this.exitReason = ExitNotifier.ExitStatus.ERROR;
        }
        finally {
            this.shutDown();
            this.plugins.runPostCrawlingPlugins(this.crawlSessionProvider.get(), this.exitReason);
            LOG.info("Shutdown process complete");
        }
    }

    private void shutDown() {
        LOG.info("Received shutdown notice. Reason is {}", (Object)this.exitReason);
        this.executor.shutdownNow();
        try {
            LOG.debug("Waiting for task consumers to stop...");
            this.executor.awaitTermination(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted before being able to shut down executor pool", (Throwable)e);
            this.exitReason = ExitNotifier.ExitStatus.ERROR;
        }
        LOG.debug("terminated");
    }

    void stop() {
        this.exitNotifier.stop();
    }
}

