/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.codahale.metrics.MetricRegistry;
import com.crawljax.core.configuration.CrawljaxConfiguration;
import com.crawljax.core.state.Eventable;
import com.crawljax.core.state.StateFlowGraph;
import com.crawljax.core.state.StateVertex;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CrawlSession {
    private final StateFlowGraph stateFlowGraph;
    private final Collection<List<Eventable>> crawlPaths = new ConcurrentLinkedQueue<List<Eventable>>();
    private final StateVertex initialState;
    private final CrawljaxConfiguration config;
    private final long startTime;
    private final MetricRegistry registry;

    @Inject
    public CrawlSession(CrawljaxConfiguration config, StateFlowGraph stateFlowGraph, StateVertex state, MetricRegistry registry) {
        this.stateFlowGraph = stateFlowGraph;
        this.initialState = state;
        this.config = config;
        this.registry = registry;
        this.startTime = new Date().getTime();
    }

    public StateFlowGraph getStateFlowGraph() {
        return this.stateFlowGraph;
    }

    public Collection<List<Eventable>> getCrawlPaths() {
        return this.crawlPaths;
    }

    public void addCrawlPath(List<Eventable> crawlPath) {
        this.crawlPaths.add(crawlPath);
    }

    public StateVertex getInitialState() {
        return this.initialState;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected void removeCrawlPath(List<Eventable> path) {
        this.crawlPaths.remove(path);
    }

    public CrawljaxConfiguration getConfig() {
        return this.config;
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }
}

