/*
 * Decompiled with CFR 0.152.
 */
package com.crawljax.core;

import com.crawljax.core.Crawler;
import com.crawljax.core.CrawlerContext;
import com.crawljax.core.ExitNotifier;
import com.crawljax.core.UnfiredCandidateActions;
import com.crawljax.core.state.StateVertex;
import com.google.inject.Inject;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlTaskConsumer
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(CrawlTaskConsumer.class);
    private final AtomicInteger runningConsumers;
    private final Crawler crawler;
    private final UnfiredCandidateActions candidates;
    private final ExitNotifier exitNotifier;

    @Inject
    CrawlTaskConsumer(UnfiredCandidateActions candidates, ExitNotifier exitNotifier, Crawler crawler) {
        this.candidates = candidates;
        this.exitNotifier = exitNotifier;
        this.crawler = crawler;
        this.runningConsumers = new AtomicInteger(0);
    }

    @Override
    public Void call() {
        try {
            while (!Thread.interrupted()) {
                if (this.runningConsumers.get() == 0 && this.candidates.isEmpty()) {
                    LOG.debug("No consumers active and the cache is empty. Crawl is done. Shutting down...");
                    this.exitNotifier.signalCrawlExhausted();
                    break;
                }
                this.pollAndHandleCrawlTasks();
                this.runningConsumers.decrementAndGet();
            }
            this.crawler.close();
        }
        catch (InterruptedException e) {
            LOG.debug("Consumer interrupted");
            this.crawler.close();
        }
        catch (RuntimeException e) {
            LOG.error("Unexpected error " + e.getMessage(), (Throwable)e);
            throw e;
        }
        return null;
    }

    private void pollAndHandleCrawlTasks() throws InterruptedException {
        try {
            LOG.debug("Awaiting task");
            StateVertex crawlTask = this.candidates.awaitNewTask();
            int activeConsumers = this.runningConsumers.incrementAndGet();
            LOG.debug("There are {} active consumers", (Object)activeConsumers);
            this.handleTask(crawlTask);
        }
        catch (RuntimeException e) {
            LOG.error("Cound not complete state crawl: " + e.getMessage(), (Throwable)e);
        }
    }

    private void handleTask(StateVertex state) {
        LOG.debug("Going to handle tasks in {}", (Object)state);
        this.crawler.execute(state);
        LOG.debug("Task executed. Returning to queue polling");
    }

    public StateVertex crawlIndex() {
        return this.crawler.crawlIndex();
    }

    public CrawlerContext getContext() {
        return this.crawler.getContext();
    }
}

